/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database;

import be.yildizgames.common.exception.implementation.ImplementationException;
import be.yildizgames.common.logging.LogFactory;
import be.yildizgames.module.database.DataBaseConnectionProvider;
import be.yildizgames.module.database.DatabaseUpdater;
import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;

public class LiquibaseDatabaseUpdater
implements DatabaseUpdater {
    private final Logger logger = LogFactory.getInstance().getLogger(this.getClass());
    private final String configurationFile;

    private LiquibaseDatabaseUpdater(String configurationFile) {
        ImplementationException.throwForNull((Object)configurationFile);
        this.configurationFile = configurationFile;
    }

    public static LiquibaseDatabaseUpdater fromConfigurationPath(String path) {
        return new LiquibaseDatabaseUpdater(path);
    }

    @Override
    public final void update(DataBaseConnectionProvider provider) throws SQLException {
        ImplementationException.throwForNull((Object)provider);
        this.logger.info("Updating database schema...");
        try (Connection c = provider.getConnection();){
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(c));
            Liquibase liquibase = new Liquibase(this.configurationFile, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update("database-update");
            this.logger.info("Database schema up to date.");
            database.close();
        }
        catch (SQLException | LiquibaseException e) {
            throw new SQLException(e);
        }
    }
}

