/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database;

import be.yildizgames.common.exception.implementation.ImplementationException;
import be.yildizgames.common.util.PropertiesHelper;
import be.yildizgames.module.database.DbProperties;
import java.util.Properties;

public class SimpleDbProperties
implements DbProperties {
    private final String user;
    private final String password;
    private final String database;
    private final String host;
    private final int port;
    private final String system;
    private final String rootUser;
    private final String rootPassword;

    public SimpleDbProperties(Properties properties) {
        ImplementationException.throwForNull((Object)properties);
        this.user = PropertiesHelper.getValue((Properties)properties, (String)"database.user");
        this.password = PropertiesHelper.getValue((Properties)properties, (String)"database.password");
        this.rootUser = PropertiesHelper.getValue((Properties)properties, (String)"database.root.user");
        this.rootPassword = PropertiesHelper.getValue((Properties)properties, (String)"database.root.password");
        this.database = PropertiesHelper.getValue((Properties)properties, (String)"database.name");
        this.host = PropertiesHelper.getValue((Properties)properties, (String)"database.host");
        this.port = PropertiesHelper.getPortValue((Properties)properties, (String)"database.port");
        this.system = PropertiesHelper.getValue((Properties)properties, (String)"database.system");
        DbProperties.DbPropertiesInvariant.check(this.user, this.password, this.rootUser, this.rootPassword, this.database, this.host, this.port, this.system);
    }

    @Override
    public String getDbUser() {
        return this.user;
    }

    @Override
    public int getDbPort() {
        return this.port;
    }

    @Override
    public String getDbPassword() {
        return this.password;
    }

    @Override
    public String getDbHost() {
        return this.host;
    }

    @Override
    public String getDbName() {
        return this.database;
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public String getDbRootUser() {
        return this.rootUser;
    }

    @Override
    public String getDbRootPassword() {
        return this.rootPassword;
    }
}

