/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.module.database;

import be.yildizgames.module.database.DataBaseConnectionProvider;
import be.yildizgames.module.database.TransactionBehavior;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Transaction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DataBaseConnectionProvider connectionProvider;

    public Transaction(DataBaseConnectionProvider p) {
        this.connectionProvider = p;
    }

    public void execute(TransactionBehavior b) {
        try (Connection c = this.connectionProvider.getConnection();){
            this.logger.debug("Starting transaction");
            c.setAutoCommit(false);
            try {
                b.execute(c);
            }
            catch (Exception e) {
                c.rollback();
                this.logger.error("Error in transaction", (Throwable)e);
            }
            c.commit();
            c.setAutoCommit(true);
            this.logger.debug("Complete transaction");
        }
        catch (SQLException e) {
            this.logger.error("Error in transaction", (Throwable)e);
        }
    }
}

