/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.configmetadata.logic;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public abstract class MetaDataGenerator {
    public static final Path GENERAL_META_DATA_PATH = MetaDataGenerator.getGeneralMetaDataPath();
    public static final String TYPE_CONFIG_META_DATA = "META-INF/spring-configuration-metadata.json";
    public static final String TYPE_AUTO_CONFIG = "META-INF/spring.factories";

    public Path write(String metaDataType, String content) throws IOException {
        return this.write(Paths.get(GENERAL_META_DATA_PATH.toString(), metaDataType), content);
    }

    public Path write(Path outputPath, String content) throws IOException {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(outputPath);
        Files.write(outputPath, content.getBytes(), new OpenOption[0]);
        return outputPath;
    }

    private static Path getGeneralMetaDataPath() {
        return Paths.get(System.getProperty("user.dir"), "src/main/resources");
    }
}

