/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.configmetadata.model;

import berlin.yuna.configmetadata.logic.MetaDataGenerator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AutoConfigurationClass
extends MetaDataGenerator {
    private List<Class> autoConfigClasses = new ArrayList<Class>();

    public AutoConfigurationClass() {
    }

    public AutoConfigurationClass(Class ... autoConfigClasses) {
        this.autoConfigClasses.addAll(new ArrayList<Class>(Arrays.asList(autoConfigClasses)));
    }

    public List<Class> getAutoConfigClasses() {
        return this.autoConfigClasses;
    }

    public AutoConfigurationClass newAutoConfigClass(Class ... autoConfigClasses) {
        this.autoConfigClasses.addAll(new ArrayList<Class>(Arrays.asList(autoConfigClasses)));
        return this;
    }

    public Path generate() throws IOException {
        StringBuilder content = new StringBuilder();
        content.append("org.springframework.boot.autoconfigure.EnableAutoConfiguration=\\\n");
        for (Class clazz : this.getAutoConfigClasses()) {
            content.append(clazz.getTypeName()).append("\n");
        }
        return this.write("META-INF/spring.factories", content.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoConfigurationClass that = (AutoConfigurationClass)o;
        return Objects.equals(this.autoConfigClasses, that.autoConfigClasses);
    }

    public int hashCode() {
        return Objects.hash(this.autoConfigClasses);
    }

    public String toString() {
        return "AutoConfigurationClass{autoConfigClasses=" + this.autoConfigClasses + '}';
    }
}

