/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.configmetadata.model;

import berlin.yuna.configmetadata.logic.MetaDataGenerator;
import berlin.yuna.configmetadata.model.Groups;
import berlin.yuna.configmetadata.model.Hints;
import berlin.yuna.configmetadata.model.Properties;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigurationMetadata
extends MetaDataGenerator {
    private ArrayList<Hints> hints = new ArrayList();
    private ArrayList<Groups> groups = new ArrayList();
    private ArrayList<Properties> properties = new ArrayList();

    public ConfigurationMetadata() {
    }

    public ConfigurationMetadata(String group, Class sourceType) {
        Groups groups = new Groups();
        groups.name(group);
        groups.type(sourceType);
        groups.sourceType(sourceType);
        this.groups().add(groups);
    }

    public Path generate() throws IOException {
        return this.write("META-INF/spring-configuration-metadata.json", this.buildJson());
    }

    public Path generate(Path outputPath) throws IOException {
        return this.write(outputPath, this.buildJson());
    }

    public ArrayList<Hints> hints() {
        return this.hints;
    }

    public void hints(ArrayList<Hints> hints) {
        this.hints = hints;
    }

    public Hints newHints() {
        Hints hints = new Hints();
        this.hints().add(hints);
        return hints;
    }

    public ArrayList<Groups> groups() {
        return this.groups;
    }

    public void groups(ArrayList<Groups> groups) {
        this.groups = groups;
    }

    public Groups newGroups() {
        Groups groups = new Groups();
        this.groups().add(groups);
        return groups;
    }

    public Groups newGroups(String group, Class sourceType) {
        Groups groups = new Groups();
        groups.name(group);
        groups.type(sourceType);
        groups.sourceType(sourceType);
        this.groups().add(groups);
        return groups;
    }

    public ArrayList<Properties> properties() {
        return this.properties;
    }

    public void properties(ArrayList<Properties> properties) {
        this.properties = properties;
    }

    public Properties newProperties() {
        Properties properties = new Properties();
        this.properties().add(properties);
        return properties.sourceType(Properties.class);
    }

    private String buildJson() throws JsonProcessingException {
        Groups groups = this.groups().get(0);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        String json = mapper.writeValueAsString((Object)this);
        json = json.replace(Properties.class.getTypeName(), groups.sourceType());
        json = json.replace("${default.group}", groups.name());
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationMetadata that = (ConfigurationMetadata)o;
        return Objects.equals(this.hints, that.hints) && Objects.equals(this.groups, that.groups) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.hints, this.groups, this.properties);
    }

    public String toString() {
        return "ConfigurationMetadata{hints=" + this.hints + ", groups=" + this.groups + ", properties=" + this.properties + '}';
    }
}

