/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.configmetadata.model;

import berlin.yuna.configmetadata.model.Deprecation;
import berlin.yuna.configmetadata.model.Groups;
import java.util.Objects;

public class Properties {
    private String name;
    private String type;
    private String description;
    private String sourceType;
    private Object defaultValue;
    private Deprecation deprecation;

    public Properties() {
    }

    public Properties(String name, String description, Class type) {
        this(name, description, type, Properties.class);
    }

    public Properties(String name, String description, Class type, Class sourceType) {
        this.name(name);
        this.description(description);
        this.type(type);
        this.sourceType(sourceType);
    }

    public String getName() {
        return this.name;
    }

    public Properties name(String name) {
        return this.name("${default.group}", name);
    }

    public Properties name(Groups group, String name) {
        this.sourceType(group.sourceType());
        return this.name(group.name(), name);
    }

    public Properties name(String group, String name) {
        this.name = group.trim() + (group.endsWith(".") ? "" : ".") + name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public Properties type(String type) {
        this.type = type;
        return this;
    }

    public Properties type(Class type) {
        this.type = type.getTypeName();
        return this;
    }

    public String description() {
        return this.description;
    }

    public Properties description(String description) {
        this.description = description;
        return this;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public Properties sourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public Properties sourceType(Class sourceType) {
        this.sourceType = sourceType.getTypeName();
        return this;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public Properties defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Deprecation deprecation() {
        return this.deprecation;
    }

    public Properties deprecation(Deprecation deprecation) {
        this.deprecation = deprecation;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Properties that = (Properties)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description) && Objects.equals(this.sourceType, that.sourceType) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.deprecation, that.deprecation);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.description, this.sourceType, this.defaultValue, this.deprecation);
    }

    public String toString() {
        return "Hints{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", description='" + this.description + '\'' + ", sourceType='" + this.sourceType + '\'' + ", defaultValue=" + this.defaultValue + ", deprecation=" + this.deprecation + '}';
    }
}

