/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.embedded.annotation;

import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.embedded.annotation.EnableNatsServer;
import berlin.yuna.natsserver.embedded.logic.NatsServer;
import berlin.yuna.natsserver.embedded.model.exception.NatsStartException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class EnableNatsServerContextCustomizer
implements ContextCustomizer {
    private final EnableNatsServer enableNatsServer;
    private static final Logger LOG = LoggerFactory.getLogger(EnableNatsServerContextCustomizer.class);

    EnableNatsServerContextCustomizer(EnableNatsServer enableNatsServer) {
        this.enableNatsServer = enableNatsServer;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(DefaultSingletonBeanRegistry.class, (Object)beanFactory);
        ConfigurableEnvironment environment = context.getEnvironment();
        if (this.enableNatsServer == null) {
            LOG.debug("Skipping [{}] cause its not defined", (Object)EnableNatsServer.class.getSimpleName());
            return;
        }
        NatsServer natsServer = new NatsServer(this.enableNatsServer.timeoutMs());
        this.setEnvConfig(natsServer, environment);
        if (this.enableNatsServer.port() != natsServer.port()) {
            natsServer.config(NatsConfig.PORT, String.valueOf(this.enableNatsServer.port()));
        }
        natsServer.config(this.enableNatsServer.config());
        this.configure(natsServer, NatsConfig.NATS_CONFIG_FILE, this.enableNatsServer.configFile());
        this.configure(natsServer, NatsConfig.NATS_BINARY_PATH, this.enableNatsServer.binaryFile());
        this.configure(natsServer, NatsConfig.NATS_DOWNLOAD_URL, this.enableNatsServer.downloadUrl());
        try {
            natsServer.start(this.enableNatsServer.timeoutMs());
        }
        catch (Exception e) {
            natsServer.stop(this.enableNatsServer.timeoutMs());
            throw new NatsStartException("Failed to initialise " + EnableNatsServer.class.getSimpleName(), e);
        }
        beanFactory.initializeBean((Object)natsServer, NatsServer.BEAN_NAME);
        beanFactory.registerSingleton(NatsServer.BEAN_NAME, (Object)natsServer);
        ((DefaultSingletonBeanRegistry)beanFactory).registerDisposableBean(NatsServer.BEAN_NAME, (DisposableBean)natsServer);
    }

    private void configure(NatsServer natsServerBean, NatsConfig key, String value) {
        if (StringUtils.hasText((String)value)) {
            natsServerBean.config(key, value);
        }
    }

    private void setEnvConfig(NatsServer natsServer, ConfigurableEnvironment environment) {
        for (NatsConfig natsConfig : NatsConfig.values()) {
            String key = "nats.server." + natsConfig.name().toLowerCase();
            String value = environment.getProperty(key);
            if (!StringUtils.hasText((String)value)) continue;
            natsServer.config(natsConfig, value);
        }
    }
}

