/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.junit.logic;

import berlin.yuna.natsserver.config.NatsConfig;
import berlin.yuna.natsserver.config.NatsOptionsBuilder;
import berlin.yuna.natsserver.junit.model.annotation.JUnitNatsServer;
import berlin.yuna.natsserver.logic.Nats;
import berlin.yuna.natsserver.logic.NatsUtils;
import berlin.yuna.natsserver.model.exception.NatsStartException;
import io.nats.commons.NatsOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

public class NatsServer
implements BeforeAllCallback,
AfterAllCallback,
ArgumentsProvider,
ExtensionContext.Store.CloseableResource {
    private int pid;
    private Nats nats;
    private int port;
    private String name;
    private String host;
    private long timeoutMs;
    private boolean keepAlive;
    private static final List<NatsServer> NATS_SERVER_LIST = new CopyOnWriteArrayList<NatsServer>();

    public static NatsServer getNatsServer() {
        return NATS_SERVER_LIST.isEmpty() ? null : NATS_SERVER_LIST.get(NATS_SERVER_LIST.size() - 1);
    }

    public static NatsServer getNatsServerByName(String name) {
        return NatsServer.getNatsServerBy(natsServer -> natsServer.getName().equals(name));
    }

    public static NatsServer getNatsServerByPid(int pid) {
        return NatsServer.getNatsServerBy(natsServer -> natsServer.getPid() == pid);
    }

    public static NatsServer getNatsServerByPort(int port) {
        return NatsServer.getNatsServerBy(natsServer -> natsServer.getPort() == port);
    }

    public static NatsServer getNatsServerByHost(String host) {
        return NatsServer.getNatsServerBy(natsServer -> natsServer.getHost().equals(host));
    }

    public static NatsServer getNatsServerBy(Predicate<NatsServer> filter) {
        return NATS_SERVER_LIST.stream().filter(filter).findFirst().orElse(null);
    }

    public void beforeAll(ExtensionContext context) {
        context.getElement().map(annotation -> annotation.getAnnotation(JUnitNatsServer.class)).ifPresent(config -> {
            this.validateKeepAlive(context, (JUnitNatsServer)config);
            NatsOptionsBuilder options = berlin.yuna.natsserver.config.NatsOptions.natsBuilder();
            if (config.port() != ((Integer)NatsConfig.PORT.defaultValue()).intValue()) {
                options.config(NatsConfig.PORT, String.valueOf(config.port()));
            }
            options.config(config.config()).timeoutMs((Number)config.timeoutMs()).version(NatsUtils.isNotEmpty((String)config.version()) ? config.version() : options.version());
            this.configure(options, NatsConfig.NATS_PROPERTY_FILE, config.configFile());
            this.configure(options, NatsConfig.NATS_BINARY_PATH, config.binaryFile());
            this.configure(options, NatsConfig.NATS_DOWNLOAD_URL, config.downloadUrl());
            this.configure(options, NatsConfig.NATS_LOG_NAME, config.name());
            try {
                this.start(options.build(), context, (JUnitNatsServer)config);
                this.port = this.nats.port();
                this.pid = this.nats.pid();
                this.host = this.nats.getValue(NatsConfig.NET);
                this.name = this.nats.getValue(NatsConfig.NATS_LOG_NAME);
                this.timeoutMs = config.timeoutMs();
                this.keepAlive = config.keepAlive();
                NATS_SERVER_LIST.add(this);
            }
            catch (Exception e) {
                Optional.ofNullable(this.nats).ifPresent(Nats::close);
                NATS_SERVER_LIST.remove(this);
                throw new NatsStartException((Throwable)e);
            }
        });
    }

    public void afterAll(ExtensionContext context) {
        if (this.nats != null && !this.keepAlive) {
            this.nats.close();
            NATS_SERVER_LIST.remove(this);
        }
    }

    public void close() {
        NATS_SERVER_LIST.forEach(NatsServer::stop);
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
        return NATS_SERVER_LIST.isEmpty() ? Stream.empty() : Stream.of(Arguments.of((Object[])new Object[]{NATS_SERVER_LIST.get(NATS_SERVER_LIST.size() - 1)}));
    }

    public String getConfig(NatsConfig key) {
        return this.nats.getValue(key);
    }

    public String getConfig(NatsConfig key, Supplier<String> or) {
        return this.nats.getValue(key, or);
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public int getPid() {
        return this.pid;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.name;
    }

    public Nats stop() {
        this.nats.close();
        return this.nats;
    }

    public Nats getNats() {
        return this.nats;
    }

    private void configure(NatsOptionsBuilder options, NatsConfig key, String value) {
        if (NatsUtils.isNotEmpty((String)value)) {
            options.config(key, value);
        }
    }

    private void start(berlin.yuna.natsserver.config.NatsOptions options, ExtensionContext context, JUnitNatsServer config) {
        NatsServer prevNatsServer;
        String stayAliveName = Optional.ofNullable((String)options.config().get(NatsConfig.NATS_LOG_NAME)).filter(NatsUtils::isNotEmpty).orElse(NatsConfig.NATS_LOG_NAME.defaultValueStr());
        NatsServer natsServer = prevNatsServer = config.keepAlive() ? NatsServer.getNatsServerByName(stayAliveName) : null;
        if (prevNatsServer != null) {
            this.nats = prevNatsServer.getNats();
        } else {
            this.nats = new Nats((NatsOptions)options);
            if (config.keepAlive()) {
                context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put((Object)stayAliveName, (Object)this);
            }
        }
    }

    private void validateKeepAlive(ExtensionContext context, JUnitNatsServer config) {
        Optional<Optional> closeableResource = context.getElement().map(annotation -> annotation.getAnnotation(ExtendWith.class)).map(extendWith -> Arrays.stream(extendWith.value()).filter(aClass -> aClass == NatsServer.class).findFirst());
        if (config.keepAlive() && closeableResource.isEmpty()) {
            throw new IllegalStateException("Missing annotation [@ExtendWith(" + NatsServer.class.getSimpleName() + ".class)] in addition of the [keepAlive] flag");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NatsServer that = (NatsServer)o;
        return this.pid == that.pid && this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.pid, this.port, this.host);
    }

    public String toString() {
        return "NatsServer{timeoutMs=" + this.timeoutMs + ", pid=" + this.pid + ", port=" + this.port + ", host='" + this.host + "'}";
    }
}

