/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.paginator.controller;

import berlin.yuna.paginator.model.BaseRequest;
import berlin.yuna.paginator.model.CacheStatistic;
import berlin.yuna.paginator.model.ElementsRequest;
import berlin.yuna.paginator.model.ElementsResponse;
import berlin.yuna.paginator.model.GetPageRequest;
import berlin.yuna.paginator.model.SavePageRequest;
import berlin.yuna.paginator.service.BrowserService;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pages"})
public class BrowserController {
    private final BrowserService browser;

    public BrowserController(BrowserService browser) {
        this.browser = browser;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.PUT}, produces={"application/json"})
    public String getPage(@RequestBody GetPageRequest request) {
        return this.browser.getPage((BaseRequest)request);
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.PUT}, path={"elements"}, produces={"application/json"})
    public Map<String, List<ElementsResponse>> getElements(@RequestBody ElementsRequest request) {
        return this.browser.getHtmlElements(request);
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.PUT}, path={"statistics"}, produces={"application/json"})
    public CacheStatistic getStatistics() {
        return this.browser.getStatistic();
    }

    @PostMapping(produces={"application/json"})
    public String savePage(@RequestBody SavePageRequest request) {
        return this.browser.addToCache((BaseRequest)request, request.getContent());
    }
}

