/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.paginator.service;

import berlin.yuna.paginator.model.BaseRequest;
import berlin.yuna.paginator.model.CacheItem;
import berlin.yuna.paginator.model.CacheStatistic;
import berlin.yuna.paginator.model.ElementsRequest;
import berlin.yuna.paginator.model.ElementsResponse;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.Closeable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BrowserService
implements Closeable {
    private final AtomicReference<ChromeDriver> atomicDriver = new AtomicReference();
    private final Map<String, String> cache = new ConcurrentHashMap();
    private final List<CacheItem> cacheTimes = new CopyOnWriteArrayList();
    private static final Logger LOG = LoggerFactory.getLogger(BrowserService.class);

    public BrowserService() {
        this.start();
    }

    @Scheduled(fixedRate=10000L)
    public void removeOutdated() {
        this.logDeletedItems(this.cleanUpOverTimed(), this.cleanUpOverflow());
    }

    public synchronized void clearBrowserCache() {
        this.close();
    }

    public String addToCache(BaseRequest request, String content) {
        if (StringUtils.hasText((String)request.getUrl()) && StringUtils.hasText((String)content)) {
            this.cache.put(request.getUrl(), content);
            this.registerTimeoutIfNew(request);
        } else {
            LOG.warn("Received empty page from url [{}]", (Object)request.getUrl());
        }
        return content;
    }

    public Map<String, List<ElementsResponse>> getHtmlElements(ElementsRequest request) {
        String html = this.getPage((BaseRequest)request);
        HashMap<String, List<ElementsResponse>> result = new HashMap<String, List<ElementsResponse>>();
        if (StringUtils.hasText((String)html)) {
            Document document = Jsoup.parse((String)html);
            request.cssQueries().forEach((name, cssQuery) -> {
                if (StringUtils.hasText((String)name) && StringUtils.hasText((String)cssQuery)) {
                    result.put((String)name, ElementsResponse.from((Elements)document.select(cssQuery)));
                }
            });
        }
        return result;
    }

    public String getPage(BaseRequest request) {
        return this.getCachedPage(request.getUrl()).orElseGet(() -> this.cacheNewPage(request));
    }

    public CacheStatistic getStatistic() {
        return new CacheStatistic().setSize(Long.valueOf(this.cache.size()));
    }

    private void registerTimeoutIfNew(BaseRequest request) {
        CacheItem cacheItem = new CacheItem(System.currentTimeMillis() + request.getPageCacheMS(), request.getUrl());
        int index = this.cacheTimes.indexOf(cacheItem);
        if (index < 0) {
            this.cacheTimes.add(cacheItem);
        }
    }

    private Optional<String> getCachedPage(String url) {
        return Optional.ofNullable((String)this.cache.get(url));
    }

    private synchronized String cacheNewPage(BaseRequest request) {
        if (this.toUrl(request.getUrl()) != null) {
            try {
                if (this.atomicDriver.get() == null) {
                    this.start();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Page call [%s]", request.getUrl()));
                }
                ChromeDriver driver = (ChromeDriver)this.atomicDriver.get();
                driver.get(request.getUrl());
                return this.addToCache(request, driver.getPageSource());
            }
            catch (Exception e) {
                LOG.warn(String.format("Could not render [%s]", request.getUrl()), (Throwable)e);
                this.clearBrowserCache();
            }
        }
        return "";
    }

    private long cleanUpOverTimed() {
        AtomicLong deletedItems = new AtomicLong(0L);
        long currentTimeMs = System.currentTimeMillis();
        new ArrayList<CacheItem>(this.cacheTimes).forEach(cacheItem -> {
            if (cacheItem.time() < currentTimeMs) {
                deletedItems.incrementAndGet();
                this.cache.remove(cacheItem.id());
                this.cacheTimes.remove(cacheItem);
            }
        });
        return deletedItems.get();
    }

    private long cleanUpOverflow() {
        AtomicLong deletedItems = new AtomicLong(0L);
        long deleteNumber = (long)this.cache.size() - 10000L;
        if (deleteNumber > 0L) {
            List<CacheItem> collect = this.cacheTimes.stream().sorted((o1, o2) -> Long.compare(o2.time(), o1.time())).limit(deleteNumber).collect(Collectors.toList());
            collect.forEach(cacheItem -> {
                deletedItems.incrementAndGet();
                this.cache.remove(cacheItem.id());
            });
            this.cacheTimes.removeAll(collect);
        }
        return deletedItems.get();
    }

    private void logDeletedItems(long overTimed, long overFlow) {
        if (overTimed + overFlow != 0L) {
            String logMessage = String.format("Deleted items [%s], [%s] items CACHE_LIVE_TIME_MS [%s], [%s] items CACHE_ITEM_LIMIT [%s]", overTimed + overFlow, overTimed, 10800000L, overFlow, 10000L);
            LOG.info(logMessage);
        }
    }

    private synchronized void start() {
        WebDriverManager.chromedriver().setup();
        this.atomicDriver.set(new ChromeDriver((ChromeOptions)((ChromeOptions)((ChromeOptions)((ChromeOptions)new ChromeOptions().setHeadless(true)).addArguments(new String[]{"--no-sandbox"})).addArguments(new String[]{"--disable-extensions"})).addArguments(new String[]{"--disable-dev-shm-usage"})));
    }

    private URL toUrl(String url) {
        if (!StringUtils.hasText((String)url)) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }

    @Override
    public synchronized void close() {
        try {
            Optional.ofNullable((ChromeDriver)this.atomicDriver.get()).ifPresent(RemoteWebDriver::quit);
            WebDriverManager.chromedriver().clearResolutionCache();
        }
        catch (Exception e) {
            LOG.warn("Browser quit error", (Throwable)e);
        }
        finally {
            this.atomicDriver.set(null);
        }
    }
}

