/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.commons.config;

import bio.ferlab.datalake.commons.config.Configuration;
import com.typesafe.config.ConfigRenderOptions;
import java.io.File;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pureconfig.ConfigWriter;
import pureconfig.ConfigWriter$;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class ConfigurationWriter$ {
    public static ConfigurationWriter$ MODULE$;
    private final Logger log;

    static {
        new ConfigurationWriter$();
    }

    public Logger log() {
        return this.log;
    }

    public <T extends Configuration> void writeTo(String path, T conf, ConfigWriter<T> writer) {
        String content = this.toHocon(conf, writer);
        String contentWithEnvVariable = this.replaceEnvVariables(content);
        this.log().debug(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append("writting configuration: ").append(path).append(" :\n         |").append(contentWithEnvVariable).append("\n         |").toString())).stripMargin());
        File file = new File(path);
        file.createNewFile();
        PrintWriter pw = new PrintWriter(file);
        pw.write(contentWithEnvVariable);
        pw.close();
    }

    public <T extends Configuration> String toHocon(T conf, ConfigWriter<T> writer) {
        ConfigRenderOptions renderOptions = ConfigRenderOptions.defaults().setJson(false).setComments(false).setOriginComments(false).setFormatted(true);
        String content = ConfigWriter$.MODULE$.apply(writer).to(conf).render(renderOptions);
        return content;
    }

    public String replaceEnvVariables(String content) {
        return content.replaceAll("\"(\\$\\{.*})\"", "$1");
    }

    private ConfigurationWriter$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger((String)this.getClass().getCanonicalName());
    }
}

