/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.commons.file;

import bio.ferlab.datalake.commons.file.File;
import bio.ferlab.datalake.commons.file.FileSystem;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HadoopFileSystem$
implements FileSystem {
    public static HadoopFileSystem$ MODULE$;
    private final Logger log;

    static {
        new HadoopFileSystem$();
    }

    @Override
    public boolean extractPart(String folder, String currentExtention, String newExtension) {
        return FileSystem.extractPart$(this, folder, currentExtention, newExtension);
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void bio$ferlab$datalake$commons$file$FileSystem$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    private org.apache.hadoop.fs.FileSystem getFileSystem(String path) {
        Path folderPath = new Path(path);
        Configuration conf = SparkSession$.MODULE$.active().sparkContext().hadoopConfiguration();
        return folderPath.getFileSystem(conf);
    }

    private File toFile(FileStatus f) {
        return new File(f.getPath().toString(), f.getPath().getName(), f.getLen(), f.isDirectory());
    }

    public Path stringToPath(String path) {
        return new Path(path);
    }

    @Override
    public List<File> list(String path, boolean recursive) {
        org.apache.hadoop.fs.FileSystem fs = this.getFileSystem(path);
        if (recursive) {
            return this.listRecursive$1((List)new .colon.colon((Object)this.stringToPath(path), (List)Nil$.MODULE$), (List)Nil$.MODULE$, fs);
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(this.stringToPath(path)))).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.toFile((FileStatus)f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).toList();
    }

    @Override
    public void copy(String source, String destination, boolean overwrite) {
        org.apache.hadoop.fs.FileSystem fs = this.getFileSystem(source);
        if (fs.exists(this.stringToPath(destination)) && !overwrite) {
            throw new FileAlreadyExistsException(new StringBuilder(27).append("destination ").append(destination).append(" already exists").toString());
        }
        FSDataInputStream inputStream = fs.open(this.stringToPath(source));
        FSDataOutputStream outputStream = fs.create(this.stringToPath(destination));
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        inputStream.close();
        outputStream.close();
    }

    @Override
    public void move(String source, String destination, boolean overwrite) {
        this.copy(source, destination, overwrite);
        this.remove(source);
    }

    @Override
    public void remove(String path) {
        org.apache.hadoop.fs.FileSystem fs = this.getFileSystem(path);
        fs.delete(this.stringToPath(path), true);
    }

    private final List listRecursive$1(List queue, List acc, org.apache.hadoop.fs.FileSystem fs$1) {
        List list;
        while (true) {
            List updatedAcc;
            if (Nil$.MODULE$.equals(list = queue)) {
                return acc;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            Path head = (Path)colon2.head();
            List tail = colon2.tl$access$1();
            FileStatus[] statuses = fs$1.listStatus(head);
            Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FileStatus[] dirs = (FileStatus[])tuple2._1();
            FileStatus[] files = (FileStatus[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)dirs, (Object)files);
            FileStatus[] dirs2 = (FileStatus[])tuple22._1();
            FileStatus[] files2 = (FileStatus[])tuple22._2();
            acc = updatedAcc = (List)((List)acc.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files2)).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.toFile((FileStatus)f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs2)).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.toFile((FileStatus)f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), List$.MODULE$.canBuildFrom());
            queue = (List)tail.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs2)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))), List$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)list);
    }

    private HadoopFileSystem$() {
        MODULE$ = this;
        FileSystem.$init$(this);
    }
}

