/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.spark3.etl;

import bio.ferlab.datalake.commons.config.Configuration;
import bio.ferlab.datalake.commons.config.DatasetConf;
import bio.ferlab.datalake.commons.config.LoadType;
import bio.ferlab.datalake.commons.config.RunStep;
import bio.ferlab.datalake.commons.config.RunStep$;
import bio.ferlab.datalake.commons.config.WriteOptions;
import bio.ferlab.datalake.commons.file.FileSystem;
import bio.ferlab.datalake.spark3.datastore.SqlBinderResolver$;
import bio.ferlab.datalake.spark3.file.FileSystemResolver$;
import bio.ferlab.datalake.spark3.implicits.DatasetConfImplicits$;
import bio.ferlab.datalake.spark3.loader.LoadResolver$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%g!B\u000f\u001f\u0003\u0003I\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I1A\u0019\t\u0011i\u0002!\u0011!Q\u0001\nIBQa\u000f\u0001\u0005\u0002qBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001C\u0011\u0019i\u0005\u0001)A\u0005\u0007\"9a\n\u0001b\u0001\u000e\u0003y\u0005bB*\u0001\u0005\u0004%\t\u0001\u0016\u0005\u0007;\u0002\u0001\u000b\u0011B+\t\u000by\u0003a\u0011A0\t\u0013\u0005m\u0001!%A\u0005\u0002\u0005u\u0001\"CA\u001a\u0001E\u0005I\u0011AA\u000f\u0011\u001d\t)\u0004\u0001D\u0001\u0003oA\u0011\"!\u0012\u0001#\u0003%\t!!\b\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005u\u0001bBA%\u0001\u0011\u0005\u00111\n\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u0003;A\u0011\"!\u0017\u0001#\u0003%\t!!\b\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004\"CAK\u0001E\u0005I\u0011AAL\u0011%\tY\nAI\u0001\n\u0003\ti\nC\u0005\u0002\"\u0002\t\n\u0011\"\u0001\u0002\u001e\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\t9\r\u0001C\u0001\u0003s\u00131!\u0012+M\u0015\ty\u0002%A\u0002fi2T!!\t\u0012\u0002\rM\u0004\u0018M]64\u0015\t\u0019C%\u0001\u0005eCR\fG.Y6f\u0015\t)c%\u0001\u0004gKJd\u0017M\u0019\u0006\u0002O\u0005\u0019!-[8\u0004\u0001M\u0011\u0001A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0002\t\r|gNZ\u000b\u0002eA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0007G>tg-[4\u000b\u0005]\u0012\u0013aB2p[6|gn]\u0005\u0003sQ\u0012QbQ8oM&<WO]1uS>t\u0017!B2p]\u001a\u0004\u0013A\u0002\u001fj]&$h\bF\u0001>)\tq\u0004\t\u0005\u0002@\u00015\ta\u0004C\u00031\u0007\u0001\u000f!'A\u0006nS:$\u0015\r^3US6,W#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001\u0002;j[\u0016T\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\niAj\\2bY\u0012\u000bG/\u001a+j[\u0016\fA\"\\5o\t\u0006$X\rV5nK\u0002\n1\"\\1y\t\u0006$X\rV5nK\u0006aQ.\u0019=ECR,G+[7fA\u0005YA-Z:uS:\fG/[8o+\u0005\u0001\u0006CA\u001aR\u0013\t\u0011FGA\u0006ECR\f7/\u001a;D_:4\u0017a\u00017pOV\tQ\u000b\u0005\u0002W76\tqK\u0003\u0002Y3\u0006)1\u000f\u001c45U*\t!,A\u0002pe\u001eL!\u0001X,\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u000f\u0015DHO]1diR)\u0001-a\u0005\u0002\u0018Q\u0019\u0011-!\u0003\u0011\t\tLGn\u001c\b\u0003G\u001e\u0004\"\u0001\u001a\u0017\u000e\u0003\u0015T!A\u001a\u0015\u0002\rq\u0012xn\u001c;?\u0013\tAG&\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u00141!T1q\u0015\tAG\u0006\u0005\u0002c[&\u0011an\u001b\u0002\u0007'R\u0014\u0018N\\4\u0011\u0007A\f\u0019A\u0004\u0002r}:\u0011!o\u001f\b\u0003gbt!\u0001\u001e<\u000f\u0005\u0011,\u0018\"\u0001.\n\u0005]L\u0016AB1qC\u000eDW-\u0003\u0002zu\u0006)1\u000f]1sW*\u0011q/W\u0005\u0003yv\f1a]9m\u0015\tI(0C\u0002\u0000\u0003\u0003\tq\u0001]1dW\u0006<WM\u0003\u0002}{&!\u0011QAA\u0004\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0000\u0003\u0003Aa!_\u0006A\u0004\u0005-\u0001\u0003BA\u0007\u0003\u001fi!!!\u0001\n\t\u0005E\u0011\u0011\u0001\u0002\r'B\f'o[*fgNLwN\u001c\u0005\t\u0003+Y\u0001\u0013!a\u0001\u0007\u0006yA.Y:u%VtG)\u0019;f)&lW\r\u0003\u0005\u0002\u001a-\u0001\n\u00111\u0001D\u0003I\u0019WO\u001d:f]R\u0014VO\u001c#bi\u0016$\u0016.\\3\u0002#\u0015DHO]1di\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002 )\u001a1)!\t,\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\f-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\t9CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011#\u001a=ue\u0006\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0005\u0002:\u0005u\u0012\u0011IA\")\ry\u00171\b\u0005\u0007s:\u0001\u001d!a\u0003\t\r\u0005}b\u00021\u0001b\u0003\u0011!\u0017\r^1\t\u0011\u0005Ua\u0002%AA\u0002\rC\u0001\"!\u0007\u000f!\u0003\u0005\raQ\u0001\u0014iJ\fgn\u001d4pe6$C-\u001a4bk2$HEM\u0001\u0014iJ\fgn\u001d4pe6$C-\u001a4bk2$HeM\u0001\u0005Y>\fG\r\u0006\u0005\u0002N\u0005E\u00131KA+)\ry\u0017q\n\u0005\u0007sF\u0001\u001d!a\u0003\t\r\u0005}\u0012\u00031\u0001p\u0011!\t)\"\u0005I\u0001\u0002\u0004\u0019\u0005\u0002CA\r#A\u0005\t\u0019A\"\u0002\u001d1|\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005qAn\\1eI\u0011,g-Y;mi\u0012\u001a\u0014a\u00029vE2L7\u000f\u001b\u000b\u0003\u0003?\"B!!\u0019\u0002hA\u00191&a\u0019\n\u0007\u0005\u0015DF\u0001\u0003V]&$\bBB=\u0015\u0001\b\tY!A\u0002sk:$\u0002\"!\u001c\u0002r\u0005-\u00151\u0013\u000b\u0004_\u0006=\u0004BB=\u0016\u0001\b\tY\u0001C\u0005\u0002tU\u0001\n\u00111\u0001\u0002v\u0005A!/\u001e8Ti\u0016\u00048\u000f\u0005\u0004\u0002x\u0005}\u0014Q\u0011\b\u0005\u0003s\niHD\u0002e\u0003wJ\u0011!L\u0005\u0003\u007f2JA!!!\u0002\u0004\n\u00191+Z9\u000b\u0005}d\u0003cA\u001a\u0002\b&\u0019\u0011\u0011\u0012\u001b\u0003\u000fI+hn\u0015;fa\"I\u0011QC\u000b\u0011\u0002\u0003\u0007\u0011Q\u0012\t\u0005W\u0005=5)C\u0002\u0002\u00122\u0012aa\u00149uS>t\u0007\"CA\r+A\u0005\t\u0019AAG\u00035\u0011XO\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0014\u0016\u0005\u0003k\n\t#A\u0007sk:$C-\u001a4bk2$HEM\u000b\u0003\u0003?SC!!$\u0002\"\u0005i!/\u001e8%I\u00164\u0017-\u001e7uIM\n\u0011cZ3u\u0019\u0006\u001cHOU;o\t\u0006$XMR8s)\u0011\t9+a+\u0015\u0007\r\u000bI\u000b\u0003\u0004z3\u0001\u000f\u00111\u0002\u0005\u0007\u0003[K\u0002\u0019\u0001)\u0002\u0005\u0011\u001c\u0018!\u0002:fg\u0016$HCAAZ)\u0011\t\t'!.\t\reT\u00029AA\u0006\u0003!\u0019\u0018-\u001c9mS:<WCAA^!\u0019Y\u0013Q\u00187\u0002B&\u0019\u0011q\u0018\u0017\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004RaKAb_>L1!!2-\u0005%1UO\\2uS>t\u0017'A\beK\u001a\fW\u000f\u001c;TC6\u0004H.\u001b8h\u0001")
public abstract class ETL {
    private final Configuration conf;
    private final LocalDateTime minDateTime;
    private final LocalDateTime maxDateTime;
    private final Logger log;

    public Configuration conf() {
        return this.conf;
    }

    public LocalDateTime minDateTime() {
        return this.minDateTime;
    }

    public LocalDateTime maxDateTime() {
        return this.maxDateTime;
    }

    public abstract DatasetConf destination();

    public Logger log() {
        return this.log;
    }

    public abstract Map<String, Dataset<Row>> extract(LocalDateTime var1, LocalDateTime var2, SparkSession var3);

    public LocalDateTime extract$default$1() {
        return this.minDateTime();
    }

    public LocalDateTime extract$default$2() {
        return LocalDateTime.now();
    }

    public abstract Dataset<Row> transform(Map<String, Dataset<Row>> var1, LocalDateTime var2, LocalDateTime var3, SparkSession var4);

    public LocalDateTime transform$default$2() {
        return this.minDateTime();
    }

    public LocalDateTime transform$default$3() {
        return LocalDateTime.now();
    }

    public Dataset<Row> load(Dataset<Row> data, LocalDateTime lastRunDateTime, LocalDateTime currentRunDateTime, SparkSession spark) {
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("LOADING: ").append(this.destination().id()).toString());
        if (!LoadResolver$.MODULE$.write(spark, this.conf()).isDefinedAt((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.destination().format()), (Object)this.destination().loadtype()))) {
            throw new NotImplementedError(new StringBuilder(33).append("Load is not implemented for [").append(this.destination().format()).append(" / ").append(this.destination().loadtype()).append("]").toString());
        }
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.destination().table().foreach((Function1 & Serializable & scala.Serializable)table -> spark.sql(new StringBuilder(30).append("CREATE DATABASE IF NOT EXISTS ").append(table.database()).toString())));
        return (Dataset)((Function2)LoadResolver$.MODULE$.write(spark, this.conf()).apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.destination().format()), (Object)this.destination().loadtype()))).apply((Object)this.destination(), data);
    }

    public LocalDateTime load$default$2() {
        return this.minDateTime();
    }

    public LocalDateTime load$default$3() {
        return LocalDateTime.now();
    }

    public void publish(SparkSession spark) {
    }

    public Dataset<Row> run(Seq<RunStep> runSteps, Option<LocalDateTime> lastRunDateTime, Option<LocalDateTime> currentRunDateTime, SparkSession spark) {
        block5: {
            Dataset<Row> dataset;
            Dataset<Row> output;
            LocalDateTime lastRunDate = (LocalDateTime)lastRunDateTime.getOrElse((Function0 & Serializable & scala.Serializable)() -> runSteps.contains((Object)RunStep.reset$.MODULE$) ? this.minDateTime() : this.getLastRunDateFor(this.destination(), spark));
            LocalDateTime currentRunDate = (LocalDateTime)currentRunDateTime.getOrElse((Function0 & Serializable & scala.Serializable)() -> LocalDateTime.now());
            if (runSteps.isEmpty()) {
                Predef$.MODULE$.println((Object)"WARNING ETL started with no runSteps. Nothing will be executed.");
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder(14).append("RUN steps: \t\t ").append(runSteps.mkString(" -> ")).toString());
            }
            Predef$.MODULE$.println((Object)new StringBuilder(19).append("RUN lastRunDate: \t ").append(lastRunDate).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("RUN currentRunDate: \t ").append(currentRunDate).toString());
            if (runSteps.contains((Object)RunStep.reset$.MODULE$)) {
                this.reset(spark);
            }
            Map data = runSteps.contains((Object)RunStep.extract$.MODULE$) && runSteps.contains((Object)RunStep.sample$.MODULE$) ? (Map)this.extract(lastRunDate, currentRunDate, spark).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String ds = (String)tuple2._1();
                Dataset df = (Dataset)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ds), ((Function1)this.sampling().apply((Object)ds)).apply((Object)df));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()) : (runSteps.contains((Object)RunStep.extract$.MODULE$) ? this.extract(lastRunDate, currentRunDate, spark) : (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            Dataset<Row> dataset2 = output = runSteps.contains((Object)RunStep.transform$.MODULE$) ? this.transform((Map<String, Dataset<Row>>)data, lastRunDate, currentRunDate, spark) : spark.emptyDataFrame();
            if (runSteps.contains((Object)RunStep.load$.MODULE$)) {
                dataset = this.load(output, this.load$default$2(), this.load$default$3(), spark);
            } else {
                output.show(false);
                dataset = BoxedUnit.UNIT;
            }
            if (!runSteps.contains((Object)RunStep.publish$.MODULE$)) break block5;
            this.publish(spark);
        }
        return (Dataset)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DatasetConfImplicits$.MODULE$.DatasetConfOperations(this.destination()).read(this.conf(), spark)).getOrElse((Function0 & Serializable & scala.Serializable)() -> spark.emptyDataFrame());
    }

    public Seq<RunStep> run$default$1() {
        return RunStep$.MODULE$.default_load();
    }

    public Option<LocalDateTime> run$default$2() {
        return None$.MODULE$;
    }

    public Option<LocalDateTime> run$default$3() {
        return None$.MODULE$;
    }

    public LocalDateTime getLastRunDateFor(DatasetConf ds, SparkSession spark) {
        LoadType loadType = ds.loadtype();
        LocalDateTime localDateTime = LoadType.Scd1$.MODULE$.equals(loadType) ? (LocalDateTime)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((Timestamp)DatasetConfImplicits$.MODULE$.DatasetConfOperations(ds).read(this.conf(), spark).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(functions$.MODULE$.col((String)ds.writeoptions().apply((Object)WriteOptions.UPDATED_ON_COLUMN_NAME$.MODULE$.value())))})).limit(1).as(spark.implicits().newTimeStampEncoder()).head()).toLocalDateTime()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.minDateTime()) : (LoadType.Scd2$.MODULE$.equals(loadType) ? (LocalDateTime)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((Date)DatasetConfImplicits$.MODULE$.DatasetConfOperations(ds).read(this.conf(), spark).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(functions$.MODULE$.col((String)ds.writeoptions().apply((Object)WriteOptions.VALID_FROM_COLUMN_NAME$.MODULE$.value())))})).limit(1).as(spark.implicits().newDateEncoder()).head()).toLocalDate().atStartOfDay()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.minDateTime()) : this.minDateTime());
        return localDateTime;
    }

    public void reset(SparkSession spark) {
        ((FileSystem)FileSystemResolver$.MODULE$.resolve().apply((Object)this.conf().getStorage(this.destination().storageid()).filesystem())).remove(this.destination().path());
        ((Function1)SqlBinderResolver$.MODULE$.drop(spark, this.conf()).apply((Object)this.destination().format())).apply((Object)this.destination());
    }

    public PartialFunction<String, Function1<Dataset<Row>, Dataset<Row>>> sampling() {
        return this.defaultSampling();
    }

    public PartialFunction<String, Function1<Dataset<Row>, Dataset<Row>>> defaultSampling() {
        return new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)df -> df.sample(0.05);
                return (B1)intersect;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = true;
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.Dataset )}, serializedLambda);
            }
        };
    }

    public ETL(Configuration conf) {
        this.conf = conf;
        this.minDateTime = LocalDateTime.of(1900, 1, 1, 0, 0, 0);
        this.maxDateTime = LocalDateTime.of(9999, 12, 31, 23, 59, 55);
        this.log = LoggerFactory.getLogger((String)this.getClass().getCanonicalName());
    }
}

