/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.spark3.file;

import bio.ferlab.datalake.commons.file.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public final class HadoopFileSystem$
implements bio.ferlab.datalake.commons.file.FileSystem {
    public static HadoopFileSystem$ MODULE$;
    private final Logger log;

    static {
        new HadoopFileSystem$();
    }

    public boolean extractPart(String folder, String currentExtention, String newExtension) {
        return bio.ferlab.datalake.commons.file.FileSystem.extractPart$((bio.ferlab.datalake.commons.file.FileSystem)this, (String)folder, (String)currentExtention, (String)newExtension);
    }

    public Logger log() {
        return this.log;
    }

    public void bio$ferlab$datalake$commons$file$FileSystem$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    private FileSystem getFileSystem(String path) {
        Path folderPath = new Path(path);
        Configuration conf = SparkSession$.MODULE$.active().sparkContext().hadoopConfiguration();
        return folderPath.getFileSystem(conf);
    }

    public Path stringToPath(String path) {
        return new Path(path);
    }

    public List<File> list(String path, boolean recursive) {
        FileSystem fs = this.getFileSystem(path);
        RemoteIterator it = fs.listFiles(this.stringToPath(path), true);
        List files = List$.MODULE$.empty();
        while (it.hasNext()) {
            LocatedFileStatus item = (LocatedFileStatus)it.next();
            files = (List)files.$colon$plus((Object)new File(item.getPath().toString(), item.getPath().getName(), item.getLen(), item.isDirectory()), List$.MODULE$.canBuildFrom());
        }
        return files;
    }

    public void copy(String source, String destination, boolean overwrite) {
        FileSystem fs = this.getFileSystem(source);
        fs.copyFromLocalFile(false, overwrite, this.stringToPath(source), this.stringToPath(destination));
    }

    public void move(String source, String destination, boolean overwrite) {
        FileSystem fs = this.getFileSystem(source);
        fs.copyFromLocalFile(true, overwrite, this.stringToPath(source), this.stringToPath(destination));
    }

    public void remove(String path) {
        FileSystem fs = this.getFileSystem(path);
        fs.delete(this.stringToPath(path), true);
    }

    private HadoopFileSystem$() {
        MODULE$ = this;
        bio.ferlab.datalake.commons.file.FileSystem.$init$((bio.ferlab.datalake.commons.file.FileSystem)this);
    }
}

