/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.spark3.file;

import bio.ferlab.datalake.commons.file.File;
import bio.ferlab.datalake.commons.file.FileSystem;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001\u0002\u000b\u0016\u0001\u0001B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006{\u0001!\tA\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0011\u0019a\u0005\u0001)A\u0005\t\"9Q\n\u0001b\u0001\n\u0003\u0019\u0005B\u0002(\u0001A\u0003%A\tC\u0003P\u0001\u0011%\u0001\u000bC\u0003^\u0001\u0011%a\fC\u0003h\u0001\u0011%\u0001\u000eC\u0003n\u0001\u0011%a\u000eC\u0003q\u0001\u0011%\u0011\u000fC\u0003t\u0001\u0011\u0005A\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003z\u0001\u0011%!\u0010C\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0002\r'N2\u0015\u000e\\3TsN$X-\u001c\u0006\u0003-]\tAAZ5mK*\u0011\u0001$G\u0001\u0007gB\f'o[\u001a\u000b\u0005iY\u0012\u0001\u00033bi\u0006d\u0017m[3\u000b\u0005qi\u0012A\u00024fe2\f'MC\u0001\u001f\u0003\r\u0011\u0017n\\\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!bS\"A\u0015\u000b\u0005YQ#BA\u0016\u001a\u0003\u001d\u0019w.\\7p]NL!!L\u0015\u0003\u0015\u0019KG.Z*zgR,W.\u0001\u0005tg\rc\u0017.\u001a8u!\t\u00014(D\u00012\u0015\t\u00114'\u0001\u0002tg)\u0011A'N\u0001\tg\u0016\u0014h/[2fg*\u0011agN\u0001\u0007C^\u001c8\u000fZ6\u000b\u0005aJ\u0014AB1nCj|gNC\u0001;\u0003!\u0019xN\u001a;xCJ,\u0017B\u0001\u001f2\u0005!\u00196g\u00117jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002@\u0003B\u0011\u0001\tA\u0007\u0002+!)aF\u0001a\u0001_\u0005IA)\u0012'J\u001b&#VIU\u000b\u0002\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0005Y\u0006twMC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%AB*ue&tw-\u0001\u0006E\u000b2KU*\u0013+F%\u0002\n\u0011bU\u001a`'\u000eCU)T#\u0002\u0015M\u001btlU\"I\u000b6+\u0005%\u0001\u0007tC:LG/\u001b>f!\u0006$\b\u000e\u0006\u0002R7B\u0011!+\u0017\b\u0003'^\u0003\"\u0001V\u0012\u000e\u0003US!AV\u0010\u0002\rq\u0012xn\u001c;?\u0013\tA6%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0017jS!\u0001W\u0012\t\u000bq;\u0001\u0019A)\u0002\tA\fG\u000f[\u0001\bO\u0016$()Y:f)\tyV\r\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0011\u0006\u0019a.\u001a;\n\u0005\u0011\f'aA+S\u0013\")a\r\u0003a\u0001?\u0006\u0019QO]5\u00027%\u001c\b+\u0019;i)\u0016\u0014X.\u001b8bi\u0016$')\u001f#fY&l\u0017\u000e^3s)\tIG\u000e\u0005\u0002#U&\u00111n\t\u0002\b\u0005>|G.Z1o\u0011\u00151\u0017\u00021\u0001`\u0003iqwN]7bY&TX\rV8ESJ,7\r^8ssB\u0013XMZ5y)\t\tv\u000eC\u0003g\u0015\u0001\u0007q,A\fo_Jl\u0017\r\\5{KR{G)\u001b:fGR|'/_+sSR\u0011qL\u001d\u0005\u0006M.\u0001\raX\u0001\fSN$\u0015N]3di>\u0014\u0018\u0010\u0006\u0002jk\")A\f\u0004a\u0001#\u00061Q\r_5tiN$\"!\u001b=\t\u000bqk\u0001\u0019A)\u0002\u0015\u0015D\u0018n\u001d;t\r&dW\r\u0006\u0002jw\")aM\u0004a\u0001?\u0006!A.[:u)\u0015q\u0018QCA\f!\u0015y\u0018\u0011BA\b\u001d\u0011\t\t!!\u0002\u000f\u0007Q\u000b\u0019!C\u0001%\u0013\r\t9aI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY!!\u0004\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u000f\u0019\u0003c\u0001\u0015\u0002\u0012%\u0019\u00111C\u0015\u0003\t\u0019KG.\u001a\u0005\u00069>\u0001\r!\u0015\u0005\u0007\u00033y\u0001\u0019A5\u0002\u0013I,7-\u001e:tSZ,\u0017\u0001C2paf4\u0015\u000e\\3\u0015\r\u0005}\u00111FA\u0018!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013c\u0005)Qn\u001c3fY&!\u0011\u0011FA\u0012\u0005I\u0019u\u000e]=PE*,7\r\u001e*fgB|gn]3\t\r\u00055\u0002\u00031\u0001R\u0003\u0019\u0019x.\u001e:dK\"1\u0011\u0011\u0007\tA\u0002E\u000b1\u0002Z3ti&t\u0017\r^5p]\u0006!1m\u001c9z)!\t9$!\u0010\u0002@\u0005\u0005\u0003c\u0001\u0012\u0002:%\u0019\u00111H\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003[\t\u0002\u0019A)\t\r\u0005E\u0012\u00031\u0001R\u0011\u0019\t\u0019%\u0005a\u0001S\u0006IqN^3soJLG/Z\u0001\u0005[>4X\r\u0006\u0005\u00028\u0005%\u00131JA'\u0011\u0019\tiC\u0005a\u0001#\"1\u0011\u0011\u0007\nA\u0002ECa!a\u0011\u0013\u0001\u0004I\u0017A\u0002:f[>4X\r\u0006\u0003\u00028\u0005M\u0003\"\u0002/\u0014\u0001\u0004\t\u0006")
public class S3FileSystem
implements FileSystem {
    private final S3Client s3Client;
    private final String DELIMITER;
    private final String S3_SCHEME;
    private final Logger log;

    public boolean extractPart(String folder, String currentExtention, String newExtension) {
        return FileSystem.extractPart$((FileSystem)this, (String)folder, (String)currentExtention, (String)newExtension);
    }

    public Logger log() {
        return this.log;
    }

    public void bio$ferlab$datalake$commons$file$FileSystem$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    public String DELIMITER() {
        return this.DELIMITER;
    }

    public String S3_SCHEME() {
        return this.S3_SCHEME;
    }

    /*
     * WARNING - void declaration
     */
    private String sanitizePath(String path) {
        void var2_2;
        block1: {
            String sPath = path.replaceAll(new StringBuilder(1).append(this.DELIMITER()).append("+").toString(), this.DELIMITER());
            if (!sPath.startsWith(this.DELIMITER())) break block1;
            String string = path;
            String string2 = this.DELIMITER();
            if (string == null ? string2 != null : !string.equals(string2)) {
                sPath = path.substring(1);
            }
        }
        return var2_2;
    }

    private URI getBase(URI uri) {
        return new URI(uri.getScheme(), uri.getHost(), null, null);
    }

    private boolean isPathTerminatedByDelimiter(URI uri) {
        return uri.getPath().endsWith(this.DELIMITER());
    }

    private String normalizeToDirectoryPrefix(URI uri) {
        URI strippedUri = this.getBase(uri).relativize(uri);
        if (this.isPathTerminatedByDelimiter(strippedUri)) {
            return this.sanitizePath(strippedUri.getPath());
        }
        return this.sanitizePath(new StringBuilder(0).append(strippedUri.getPath()).append(this.DELIMITER()).toString());
    }

    private URI normalizeToDirectoryUri(URI uri) {
        if (this.isPathTerminatedByDelimiter(uri)) {
            return uri;
        }
        Predef$.MODULE$.println((Object)uri.getHost());
        return new URI(uri.getScheme(), uri.getHost(), new StringBuilder(0).append(uri.getPath()).append(this.DELIMITER()).toString(), null);
    }

    public boolean isDirectory(String path) {
        boolean bl;
        try {
            String prefix;
            URI uri = new URI(path);
            String string = prefix = this.normalizeToDirectoryPrefix(uri);
            String string2 = this.DELIMITER();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
            ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(uri.getHost()).prefix(prefix).maxKeys(Predef$.MODULE$.int2Integer(2)).build();
            ListObjectsV2Response listObjectsV2Response = this.s3Client.listObjectsV2(listObjectsV2Request);
            bl = listObjectsV2Response.hasContents();
        }
        catch (NoSuchKeyException noSuchKeyException) {
            bl = false;
        }
        return bl;
    }

    public boolean exists(String path) {
        boolean bl;
        try {
            if (this.isDirectory(path)) {
                return true;
            }
            URI pathUri = new URI(path);
            if (this.isPathTerminatedByDelimiter(pathUri)) {
                return false;
            }
            bl = this.existsFile(pathUri);
        }
        catch (NoSuchKeyException noSuchKeyException) {
            bl = false;
        }
        return bl;
    }

    private boolean existsFile(URI uri) {
        boolean bl;
        try {
            URI base = this.getBase(uri);
            String path = this.sanitizePath(base.relativize(uri).getPath());
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(uri.getHost()).key(path).build();
            this.s3Client.headObject(headObjectRequest);
            bl = true;
        }
        catch (NoSuchKeyException noSuchKeyException) {
            bl = false;
        }
        return bl;
    }

    public List<File> list(String path, boolean recursive) {
        URI uriPath = new URI(path);
        String continuationToken = null;
        ObjectRef fileKey = ObjectRef.create((Object)new String());
        boolean isDone = false;
        ObjectRef files = ObjectRef.create((Object)List$.MODULE$.empty());
        String prefix = this.normalizeToDirectoryPrefix(uriPath);
        while (!isDone) {
            ListObjectsV2Request.Builder listObjectsV2RequestBuilder = ListObjectsV2Request.builder().bucket(uriPath.getHost());
            String string = prefix;
            String string2 = this.DELIMITER();
            if (string == null ? string2 != null : !string.equals(string2)) {
                listObjectsV2RequestBuilder = listObjectsV2RequestBuilder.prefix(prefix);
            }
            if (!recursive) {
                listObjectsV2RequestBuilder = listObjectsV2RequestBuilder.delimiter(this.DELIMITER());
            }
            Object object = continuationToken != null ? listObjectsV2RequestBuilder.continuationToken(continuationToken) : BoxedUnit.UNIT;
            ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)listObjectsV2RequestBuilder.build();
            ListObjectsV2Response listObjectsV2Response = this.s3Client.listObjectsV2(listObjectsV2Request);
            java.util.List filesReturned = listObjectsV2Response.contents();
            filesReturned.stream().forEach(element -> {
                if (!element.key().equals(uriPath.getPath()) && !element.key().endsWith(this.DELIMITER())) {
                    fileKey$1.elem = element.key();
                }
                if (((String)fileKey$1.elem).startsWith(this.DELIMITER())) {
                    fileKey$1.elem = ((String)fileKey$1.elem).substring(1);
                }
                files$1.elem = (List)((List)files$1.elem).$colon$plus((Object)new File(new StringBuilder(0).append(this.S3_SCHEME()).append(uriPath.getHost()).append(this.DELIMITER()).append((String)fileKey$1.elem).toString(), (String)fileKey$1.elem, Predef$.MODULE$.Long2long(element.size()), false), List$.MODULE$.canBuildFrom());
            });
            isDone = !Predef$.MODULE$.Boolean2boolean(listObjectsV2Response.isTruncated());
            continuationToken = listObjectsV2Response.nextContinuationToken();
        }
        return (List)files.elem;
    }

    private CopyObjectResponse copyFile(String source, String destination) {
        URI uriSrcPath = new URI(source);
        URI uriDstPath = new URI(destination);
        CopyObjectRequest copyReq = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(uriSrcPath.getHost()).sourceKey(this.sanitizePath(uriSrcPath.getPath())).destinationBucket(uriDstPath.getHost()).destinationKey(this.sanitizePath(uriDstPath.getPath())).build();
        return this.s3Client.copyObject(copyReq);
    }

    public void copy(String source, String destination, boolean overwrite) {
        if (this.exists(destination)) {
            if (!overwrite) {
                this.log().info("Failed to copy! Cannot overwrite existing destination");
                return;
            }
            this.remove(destination);
        }
        URI uriDstPath = new URI(destination);
        URI uriSrc = new URI(source);
        if (!this.isDirectory(source)) {
            this.copyFile(source, destination);
        } else {
            URI uriDst = this.normalizeToDirectoryUri(uriDstPath);
            Path srcPath = Paths.get(uriSrc.getPath(), new String[0]);
            this.list(source, true).foreach((Function1 & Serializable & scala.Serializable)filePath -> {
                URI srcFileURI = URI.create(filePath.path());
                String directoryEntryPrefix = srcFileURI.getPath();
                URI src = new URI(uriSrc.getScheme(), uriSrc.getHost(), directoryEntryPrefix, null);
                String relativeSrcPath = ((Object)srcPath.relativize(Paths.get(directoryEntryPrefix, new String[0]))).toString();
                String dst = uriDst.resolve(relativeSrcPath).toString();
                return this.copyFile(src.toString(), dst);
            });
        }
    }

    public void move(String source, String destination, boolean overwrite) {
        this.copy(source, destination, overwrite);
        this.remove(source);
    }

    public void remove(String path) {
        block5: {
            URI pathUri = new URI(path);
            try {
                if (this.isDirectory(path)) {
                    String prefix = this.normalizeToDirectoryPrefix(pathUri);
                    ListObjectsV2Response listObjectsV2Response = null;
                    ListObjectsV2Request.Builder listObjectsV2RequestBuilder = ListObjectsV2Request.builder().bucket(pathUri.getHost());
                    String string = prefix;
                    String string2 = this.DELIMITER();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)listObjectsV2RequestBuilder.build();
                        listObjectsV2Response = this.s3Client.listObjectsV2(listObjectsV2Request);
                    } else {
                        ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)listObjectsV2RequestBuilder.prefix(prefix).build();
                        listObjectsV2Response = this.s3Client.listObjectsV2(listObjectsV2Request);
                    }
                    listObjectsV2Response.contents().stream().forEach(element -> {
                        DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(pathUri.getHost()).key(element.key()).build();
                        $this.s3Client.deleteObject(deleteObjectRequest);
                    });
                    break block5;
                }
                String prefix = this.sanitizePath(pathUri.getPath());
                DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(pathUri.getHost()).key(prefix).build();
                this.s3Client.deleteObject(deleteObjectRequest);
            }
            catch (NoSuchKeyException noSuchKeyException) {
                this.log().error("Path does not exit!");
            }
        }
    }

    public S3FileSystem(S3Client s3Client) {
        this.s3Client = s3Client;
        FileSystem.$init$((FileSystem)this);
        this.DELIMITER = "/";
        this.S3_SCHEME = "s3://";
    }
}

