/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.spark3.implicits;

import bio.ferlab.datalake.spark3.implicits.GenomicImplicits;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class GenomicImplicits$ {
    public static GenomicImplicits$ MODULE$;
    private final Column id;
    private final Seq<String> locusColumnNames;
    private final Seq<Column> locus;

    static {
        new GenomicImplicits$();
    }

    public Column id() {
        return this.id;
    }

    public Seq<String> locusColumnNames() {
        return this.locusColumnNames;
    }

    public Seq<Column> locus() {
        return this.locus;
    }

    public GenomicImplicits.GenomicOperations GenomicOperations(Dataset<Row> df) {
        return new GenomicImplicits.GenomicOperations(df);
    }

    public Dataset<Row> vcf(String input, Option<String> referenceGenomePath, SparkSession spark) {
        String[] inputs = input.split(",");
        Dataset<Row> df = this.GenomicOperations((Dataset<Row>)spark.read().format("vcf").option("flattenInfoFields", "true").load((Seq)Predef$.MODULE$.wrapRefArray((Object[])inputs)).withColumnRenamed("filters", "INFO_FILTERS")).withSplitMultiAllelic();
        return (Dataset)referenceGenomePath.fold((Function0 & java.io.Serializable & Serializable)() -> df.withColumn("normalizationStatus", functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false)).as("changed"), functions$.MODULE$.lit(null).cast((DataType)StringType$.MODULE$).as("errorMessage")}))), (Function1 & java.io.Serializable & Serializable)path -> MODULE$.GenomicOperations(df).withNormalizedVariants((String)path));
    }

    public Dataset<Row> vcf(List<String> files, Option<String> referenceGenomePath, SparkSession spark) {
        return this.vcf(files.mkString(","), referenceGenomePath, spark);
    }

    private GenomicImplicits$() {
        MODULE$ = this;
        this.id = functions$.MODULE$.sha1(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("chromosome"), functions$.MODULE$.col("start"), functions$.MODULE$.col("reference"), functions$.MODULE$.col("alternate")}))).as("id");
        this.locusColumnNames = (Seq)new .colon.colon((Object)"chromosome", (List)new .colon.colon((Object)"start", (List)new .colon.colon((Object)"reference", (List)new .colon.colon((Object)"alternate", (List)Nil$.MODULE$))));
        this.locus = (Seq)this.locusColumnNames().map((Function1 & java.io.Serializable & Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom());
    }
}

