/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.spark3.implicits;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class SparkUtils$ {
    public static SparkUtils$ MODULE$;
    private final Column filename;
    private final Function1<String, Column> removeEmptyObjectsIn;

    static {
        new SparkUtils$();
    }

    public Column filename() {
        return this.filename;
    }

    public boolean fileExist(String path, SparkSession spark) {
        FileSystem fileSystem;
        Configuration conf = spark.sparkContext().hadoopConfiguration();
        if (path.startsWith("s3a")) {
            String bucket = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.replace("s3a://", "").split("/"))).head();
            fileSystem = FileSystem.get((URI)new URI(new StringBuilder(6).append("s3a://").append(bucket).toString()), (Configuration)conf);
        } else {
            fileSystem = FileSystem.get((Configuration)conf);
        }
        FileSystem fs = fileSystem;
        FileStatus[] statuses = fs.globStatus(new Path(path));
        return statuses != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty();
    }

    public String tableName(String table, String studyId, String releaseId) {
        return new StringBuilder(2).append(table).append("_").append(studyId.toLowerCase()).append("_").append(releaseId.toLowerCase()).toString();
    }

    public String tableName(String table, String studyId, String releaseId, String database) {
        return new StringBuilder(3).append(database).append(".").append(table).append("_").append(studyId.toLowerCase()).append("_").append(releaseId.toLowerCase()).toString();
    }

    public String tableName$default$4() {
        return "variant";
    }

    public Column colFromArrayOrField(Dataset<Row> df, String colName) {
        DataType dataType = df.schema().apply(colName).dataType();
        Column column = dataType instanceof ArrayType ? df.apply(colName).apply((Object)BoxesRunTime.boxToInteger((int)0)) : df.apply(colName);
        return column;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dataset<Row> union(Dataset<Row> df1, Dataset<Row> df2, SparkSession spark) {
        Tuple2 tuple2 = new Tuple2(df1, df2);
        if (tuple2 != null) {
            Dataset p = (Dataset)tuple2._1();
            Dataset c = (Dataset)tuple2._2();
            if (p.isEmpty()) {
                return c;
            }
        }
        if (tuple2 != null) {
            Dataset p = (Dataset)tuple2._1();
            Dataset c = (Dataset)tuple2._2();
            if (c.isEmpty()) {
                return p;
            }
        }
        if (tuple2 == null) return spark.emptyDataFrame();
        Dataset p = (Dataset)tuple2._1();
        Dataset c = (Dataset)tuple2._2();
        return p.union(c);
    }

    public Column firstAs(String c) {
        return functions$.MODULE$.first(functions$.MODULE$.col(c)).as(c);
    }

    public Seq<Column> escapeInfoAndLowercase(Dataset<Row> df, Seq<String> excludes) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).collect((PartialFunction)new scala.Serializable(excludes){
            public static final long serialVersionUID = 0L;
            private final Seq excludes$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.startsWith("INFO") && !this.excludes$1.contains(A1) ? functions$.MODULE$.col(A1).as(A1.replace("INFO_", "").toLowerCase()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = string.startsWith("INFO") && !this.excludes$1.contains((Object)string);
                return bl;
            }
            {
                this.excludes$1 = excludes$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Function1<String, Column> removeEmptyObjectsIn() {
        return this.removeEmptyObjectsIn;
    }

    public Column getColumnOrElse(String colName, Object object) {
        return functions$.MODULE$.when(functions$.MODULE$.col(colName).isNull(), (Object)functions$.MODULE$.lit(object)).otherwise((Object)functions$.MODULE$.trim(functions$.MODULE$.col(colName)));
    }

    public Object getColumnOrElse$default$2() {
        return "";
    }

    private SparkUtils$() {
        MODULE$ = this;
        this.filename = functions$.MODULE$.regexp_extract(functions$.MODULE$.input_file_name(), ".*/(.*)", 1);
        this.removeEmptyObjectsIn = (Function1 & Serializable & scala.Serializable)column -> functions$.MODULE$.when(functions$.MODULE$.to_json(functions$.MODULE$.col(column)).$eq$eq$eq((Object)functions$.MODULE$.lit((Object)"[{}]")), (Object)functions$.MODULE$.array((Seq)Nil$.MODULE$)).otherwise((Object)functions$.MODULE$.col(column));
    }
}

