/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.spark3.loader;

import bio.ferlab.datalake.commons.config.Format;
import bio.ferlab.datalake.spark3.loader.GenericLoader$;
import bio.ferlab.datalake.spark3.loader.Loader;
import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTable$;
import java.io.Serializable;
import java.time.LocalDate;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DeltaLoader$
implements Loader {
    public static DeltaLoader$ MODULE$;

    static {
        new DeltaLoader$();
    }

    private Try<DeltaTable> readTableAsDelta(String location, String databaseName, String tableName) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DeltaTable$.MODULE$.forName(new StringBuilder(1).append(databaseName).append(".").append(tableName).toString())).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DeltaTable$.MODULE$.forPath(location)));
    }

    @Override
    public Dataset<Row> upsert(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        BoxedUnit boxedUnit;
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])updates.columns());
        Predef$.MODULE$.require(primaryKeys.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DeltaLoader$.$anonfun$upsert$1(objectArray, elem))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("requires column [").append(primaryKeys.mkString(", ")).append("]").toString());
        Try<DeltaTable> try_ = this.readTableAsDelta(location, databaseName, tableName);
        if (try_ instanceof Failure) {
            boxedUnit = this.writeOnce(location, databaseName, tableName, updates, partitioning, format, this.writeOnce$default$7(), spark);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            DeltaTable existing = (DeltaTable)success.value();
            Dataset existingDf = existing.toDF();
            Column mergeCondition = (Column)((TraversableOnce)primaryKeys.map((Function1 & Serializable & scala.Serializable)c -> updates.apply(c).$eq$eq$eq((Object)existingDf.apply(c)), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> a.$amp$amp(b));
            existing.as("existing").merge(updates.as("updates"), mergeCondition).whenMatched().updateAll().whenNotMatched().insertAll().execute();
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
        return this.read(location, Format.DELTA$.MODULE$.sparkFormat(), options, (Option<String>)new Some((Object)databaseName), (Option<String>)new Some((Object)tableName), spark);
    }

    @Override
    public Dataset<Row> insert(String location, String databaseName, String tableName, Dataset<Row> updates, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        GenericLoader$.MODULE$.insert(location, databaseName, tableName, updates, partitioning, format, options, spark);
        return this.read(location, Format.DELTA$.MODULE$.sparkFormat(), options, (Option<String>)new Some((Object)databaseName), (Option<String>)new Some((Object)tableName), spark);
    }

    @Override
    public Dataset<Row> scd1(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, String oidName, String createdOnName, String updatedOnName, List<String> partitioning, String format, SparkSession spark) {
        BoxedUnit boxedUnit;
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])updates.columns());
        Predef$.MODULE$.require(primaryKeys.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DeltaLoader$.$anonfun$scd1$1(objectArray, elem))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("requires column [").append(primaryKeys.mkString(", ")).append("]").toString());
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updates.columns())).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(oidName))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("requires column [").append(oidName).append("]").toString());
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updates.columns())).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(createdOnName))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("requires column [").append(createdOnName).append("]").toString());
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updates.columns())).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.equals(updatedOnName))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("requires column [").append(updatedOnName).append("]").toString());
        Try<DeltaTable> try_ = this.readTableAsDelta(location, databaseName, tableName);
        if (try_ instanceof Failure) {
            boxedUnit = this.writeOnce(location, databaseName, tableName, updates, partitioning, format, this.writeOnce$default$7(), spark);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            DeltaTable existing = (DeltaTable)success.value();
            Dataset existingDf = existing.toDF();
            Column mergeCondition = ((Column)((TraversableOnce)primaryKeys.map((Function1 & Serializable & scala.Serializable)c -> updates.apply(c).$eq$eq$eq((Object)existingDf.apply(c)), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> a.$amp$amp(b))).$amp$amp((Object)updates.apply(oidName).$eq$bang$eq((Object)existingDf.apply(oidName)));
            existing.as("existing").merge(updates.as("updates"), mergeCondition).whenMatched().updateExpr((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updates.columns())).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.equals(createdOnName))))).map((Function1 & Serializable & scala.Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), (Object)new StringBuilder(8).append("updates.").append((String)c).toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms())).whenNotMatched().insertAll().execute();
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
        return this.read(location, Format.DELTA$.MODULE$.sparkFormat(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Option<String>)new Some((Object)databaseName), (Option<String>)new Some((Object)tableName), spark);
    }

    @Override
    public Dataset<Row> writeOnce(String location, String databaseName, String tableName, Dataset<Row> df, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        return GenericLoader$.MODULE$.writeOnce(location, databaseName, tableName, df, partitioning, format, options, spark);
    }

    public scala.collection.immutable.Map<String, String> writeOnce$default$7() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataChange"), (Object)"true")}));
    }

    @Override
    public Dataset<Row> overwritePartition(String location, String databaseName, String tableName, Dataset<Row> df, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        if (partitioning.isEmpty()) {
            throw new IllegalArgumentException("Cannot use loadType 'OverWritePartition' without partitions.");
        }
        Object[] partitionValues = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.select((String)partitioning.head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collect())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        String replaceWhereClause = new StringBuilder(8).append(partitioning.head()).append(" in ('").append(Predef$.MODULE$.genericArrayOps((Object)partitionValues).mkString("', '")).append("')").toString();
        return this.writeOnce(location, databaseName, tableName, df, partitioning, format, (scala.collection.immutable.Map<String, String>)options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replaceWhere"), (Object)replaceWhereClause)), spark);
    }

    @Override
    public scala.collection.immutable.Map<String, String> overwritePartition$default$7() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataChange"), (Object)"true")}));
    }

    @Override
    public Dataset<Row> read(String location, String format, scala.collection.immutable.Map<String, String> readOptions, Option<String> databaseName, Option<String> tableName, SparkSession spark) {
        return (Dataset)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> GenericLoader$.MODULE$.read(location, format, readOptions, databaseName, tableName, spark)).getOrElse((Function0 & Serializable & scala.Serializable)() -> DeltaTable$.MODULE$.forPath(location).toDF());
    }

    @Override
    public Dataset<Row> scd2(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, String oidName, String createdOnName, String updatedOnName, List<String> partitioning, String format, String validFromName, String validToName, LocalDate minValidFromDate, LocalDate maxValidToDate, SparkSession spark) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static final /* synthetic */ boolean $anonfun$upsert$1(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$scd1$1(Object[] eta$0$1$2, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$2).contains(elem);
    }

    private DeltaLoader$() {
        MODULE$ = this;
    }
}

