/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.spark3.loader;

import bio.ferlab.datalake.spark3.loader.Loader;
import java.io.Serializable;
import java.time.LocalDate;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class GenericLoader$
implements Loader {
    public static GenericLoader$ MODULE$;

    static {
        new GenericLoader$();
    }

    @Override
    public scala.collection.immutable.Map<String, String> overwritePartition$default$7() {
        return Loader.overwritePartition$default$7$(this);
    }

    private DataFrameWriter<Row> getDataFrameWriter(Dataset<Row> df, String format, SaveMode mode, List<String> partitioning, scala.collection.immutable.Map<String, String> options) {
        return df.write().options(options).format(format).mode(mode).partitionBy(partitioning);
    }

    public Dataset<Row> write(Dataset<Row> df, String format, SaveMode mode, List<String> partitioning, String databaseName, String tableName, String location, scala.collection.immutable.Map<String, String> options) {
        Object object = new StringOps(Predef$.MODULE$.augmentString(databaseName)).nonEmpty() ? df.sparkSession().sql(new StringBuilder(30).append("CREATE DATABASE IF NOT EXISTS ").append(databaseName).toString()) : BoxedUnit.UNIT;
        DataFrameWriter<Row> dataFrameWriter = this.getDataFrameWriter(df, format, mode, partitioning, options);
        String string = tableName;
        if ("".equals(string)) {
            dataFrameWriter.save(location);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            dataFrameWriter.option("path", location).saveAsTable(new StringBuilder(1).append(databaseName).append(".").append(string).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return df;
    }

    @Override
    public Dataset<Row> read(String location, String format, scala.collection.immutable.Map<String, String> readOptions, Option<String> databaseName, Option<String> tableName, SparkSession spark) {
        return (Dataset)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)databaseName, (Object)tableName);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                    Some some = (Some)option2;
                    String name = (String)some.value();
                    return spark.table(name);
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String db = (String)some.value();
                    if (option3 instanceof Some) {
                        Some some2 = (Some)option3;
                        String name = (String)some2.value();
                        return spark.table(new StringBuilder(1).append(db).append(".").append(name).toString());
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            return spark.read().options((Map)readOptions).format(format).load(location);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> spark.read().options((Map)readOptions).format(format).load(location));
    }

    @Override
    public Dataset<Row> writeOnce(String location, String databaseName, String tableName, Dataset<Row> df, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        return this.write(df, format, SaveMode.Overwrite, partitioning, databaseName, tableName, location, options);
    }

    @Override
    public Dataset<Row> upsert(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        Dataset<Row> dataset;
        Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])updates.columns());
        Predef$.MODULE$.require(primaryKeys.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)GenericLoader$.$anonfun$upsert$1(objectArray, elem))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("requires column [").append(primaryKeys.mkString(", ")).append("]").toString());
        String fullName = new StringBuilder(1).append(databaseName).append(".").append(tableName).toString();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.read(location, format, options, (Option<String>)new Some((Object)tableName), (Option<String>)new Some((Object)databaseName), spark));
        if (try_ instanceof Failure) {
            dataset = this.writeOnce(location, databaseName, tableName, updates, partitioning, format, options, spark);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Dataset existing = (Dataset)success.value();
            Dataset data = existing.join(updates, primaryKeys, "left_anti").unionByName(updates).persist();
            data.limit(1).count();
            Dataset<Row> result = this.writeOnce(location, databaseName, tableName, (Dataset<Row>)data, partitioning, format, options, spark);
            Object object = new StringOps(Predef$.MODULE$.augmentString(fullName)).nonEmpty() ? spark.sql(new StringBuilder(14).append("REFRESH TABLE ").append(fullName).toString()) : BoxedUnit.UNIT;
            dataset = result;
        } else {
            throw new MatchError((Object)try_);
        }
        Dataset<Row> writtenData = dataset;
        return writtenData;
    }

    @Override
    public Dataset<Row> insert(String location, String databaseName, String tableName, Dataset<Row> updates, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        return this.write(updates, format, SaveMode.Append, partitioning, databaseName, tableName, location, options);
    }

    @Override
    public Dataset<Row> scd1(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, String oidName, String createdOnName, String updatedOnName, List<String> partitioning, String format, SparkSession spark) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public Dataset<Row> scd2(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, String oidName, String createdOnName, String updatedOnName, List<String> partitioning, String format, String validFromName, String validToName, LocalDate minValidFromDate, LocalDate maxValidToDate, SparkSession spark) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public Dataset<Row> overwritePartition(String location, String databaseName, String tableName, Dataset<Row> df, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static final /* synthetic */ boolean $anonfun$upsert$1(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    private GenericLoader$() {
        MODULE$ = this;
    }
}

