/*
 * Decompiled with CFR 0.152.
 */
package bio.ferlab.datalake.spark3.loader;

import bio.ferlab.datalake.spark3.loader.Loader;
import java.time.LocalDate;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;

public final class JdbcLoader$
implements Loader {
    public static JdbcLoader$ MODULE$;

    static {
        new JdbcLoader$();
    }

    @Override
    public scala.collection.immutable.Map<String, String> overwritePartition$default$7() {
        return Loader.overwritePartition$default$7$(this);
    }

    @Override
    public Dataset<Row> read(String location, String format, scala.collection.immutable.Map<String, String> readOptions, Option<String> databaseName, Option<String> tableName, SparkSession spark) {
        Predef$.MODULE$.require(readOptions.isDefinedAt((Object)"url"), (Function0 & java.io.Serializable & Serializable)() -> "Expecting [url] to be defined in readOptions.");
        Predef$.MODULE$.require(readOptions.isDefinedAt((Object)"user"), (Function0 & java.io.Serializable & Serializable)() -> "Expecting [user] to be defined in readOptions.");
        Predef$.MODULE$.require(readOptions.isDefinedAt((Object)"password"), (Function0 & java.io.Serializable & Serializable)() -> "Expecting [password] to be defined in readOptions.");
        Predef$.MODULE$.require(readOptions.isDefinedAt((Object)"driver"), (Function0 & java.io.Serializable & Serializable)() -> "Expecting [driver] to be defined in readOptions.");
        Predef$.MODULE$.require(readOptions.isDefinedAt((Object)"query") || readOptions.isDefinedAt((Object)"dbtable"), (Function0 & java.io.Serializable & Serializable)() -> "Expecting either [query] or [dbtable] to be defined in readOptions.");
        return spark.read().format(format).options(readOptions).load();
    }

    @Override
    public Dataset<Row> writeOnce(String location, String databaseName, String tableName, Dataset<Row> df, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        df.write().format(format).mode(SaveMode.Overwrite).options((Map)options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)new StringBuilder(1).append(databaseName).append(".").append(tableName).toString()))).save();
        return df;
    }

    @Override
    public Dataset<Row> insert(String location, String databaseName, String tableName, Dataset<Row> updates, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        updates.write().format(format).mode(SaveMode.Append).options((Map)options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)new StringBuilder(1).append(databaseName).append(".").append(tableName).toString()))).save();
        return updates;
    }

    @Override
    public Dataset<Row> upsert(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public Dataset<Row> scd1(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, String oidName, String createdOnName, String updatedOnName, List<String> partitioning, String format, SparkSession spark) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public Dataset<Row> scd2(String location, String databaseName, String tableName, Dataset<Row> updates, Seq<String> primaryKeys, String oidName, String createdOnName, String updatedOnName, List<String> partitioning, String format, String validFromName, String validToName, LocalDate minValidFromDate, LocalDate maxValidToDate, SparkSession spark) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public Dataset<Row> overwritePartition(String location, String databaseName, String tableName, Dataset<Row> df, List<String> partitioning, String format, scala.collection.immutable.Map<String, String> options, SparkSession spark) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private JdbcLoader$() {
        MODULE$ = this;
    }
}

