/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;

public class IndexDefinitionListener
implements ProgressTrackerListener {
    private static final String OAK_INDEX = "/oak:index/";
    private Set<String> paths;
    private List<String> actions;

    public IndexDefinitionListener(String ... actions) {
        this.actions = Arrays.asList(actions);
        this.paths = new HashSet<String>();
    }

    public Set<String> getIndexDefinitionPaths() {
        return Collections.unmodifiableSet(this.paths);
    }

    public void onMessage(ProgressTrackerListener.Mode mode, String action, String path) {
        String mappedPath;
        if (this.actions.contains(action) && (mappedPath = IndexDefinitionListener.getDefinitionPath(path)) != null) {
            this.paths.add(mappedPath);
        }
    }

    public void onError(ProgressTrackerListener.Mode mode, String path, Exception e) {
    }

    private static String getDefinitionPath(String path) {
        int pos = path.indexOf(OAK_INDEX);
        if (pos != -1) {
            int end = path.indexOf(47, pos + OAK_INDEX.length());
            if (end == -1) {
                return path;
            }
            return path.substring(0, end);
        }
        return null;
    }
}

