/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import net.distilledcode.tools.CompoundProgressTrackerListener;
import net.distilledcode.tools.IndexDefinitionListener;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHook;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OakReindexInstallHook
implements InstallHook {
    private static final Logger LOG = LoggerFactory.getLogger(OakReindexInstallHook.class);
    public static final String PN_REINDEX = "reindex";
    public static final String PN_REINDEX_COUNT = "reindexCount";
    private Map<String, ReindexRecord> reindexRecords;
    private final IndexDefinitionListener modificationCollector = new IndexDefinitionListener("A", "U", "D");

    public void execute(InstallContext context) throws PackageException {
        try {
            Session session = context.getSession();
            switch (context.getPhase()) {
                case PREPARE: {
                    Set<String> definitionPaths = OakReindexInstallHook.collectIndexDefinitionPaths(context);
                    this.reindexRecords = OakReindexInstallHook.removeReindexProperties(session, definitionPaths);
                    OakReindexInstallHook.registerChangeListener(context, this.modificationCollector);
                    break;
                }
                case INSTALLED: {
                    Set<String> modifiedIndexDefinitions = this.modificationCollector.getIndexDefinitionPaths();
                    this.reindexRecords = OakReindexInstallHook.handleChangedIndexDefinitions(session, this.reindexRecords, modifiedIndexDefinitions);
                }
                case END: {
                    OakReindexInstallHook.restoreUnchangedProperties(session, this.reindexRecords);
                    this.reindexRecords.clear();
                    if (!session.hasPendingChanges()) break;
                    session.save();
                }
            }
        }
        catch (RepositoryException e) {
            throw new PackageException((Throwable)e);
        }
    }

    private static void registerChangeListener(InstallContext context, ProgressTrackerListener listener) {
        ImportOptions options = context.getOptions();
        options.setListener(CompoundProgressTrackerListener.create(options.getListener(), listener));
    }

    private static Map<String, ReindexRecord> handleChangedIndexDefinitions(Session session, Map<String, ReindexRecord> records, Set<String> paths) throws RepositoryException {
        HashMap<String, ReindexRecord> reindexRecords = new HashMap<String, ReindexRecord>(records);
        for (String path : paths) {
            if (!reindexRecords.containsKey(path)) continue;
            ReindexRecord record = (ReindexRecord)reindexRecords.remove(path);
            record.reindex = true;
            OakReindexInstallHook.restoreIndexingProperties(session, path, record);
            LOG.info("Marked index at {} for reindexing", (Object)path);
        }
        return reindexRecords;
    }

    private static void restoreUnchangedProperties(Session session, Map<String, ReindexRecord> records) throws RepositoryException {
        for (String path : records.keySet()) {
            ReindexRecord record = records.get(path);
            OakReindexInstallHook.restoreIndexingProperties(session, path, record);
            LOG.info("Restored unchanged index properties for {}", (Object)path);
        }
    }

    private static void restoreIndexingProperties(Session session, String path, ReindexRecord record) throws RepositoryException {
        String relPath = path.substring(1);
        if (session.getRootNode().hasNode(relPath)) {
            Node definition = session.getNode(path);
            definition.setProperty(PN_REINDEX, record.reindex);
            if (record.reindexCount != -1L) {
                definition.setProperty(PN_REINDEX_COUNT, record.reindexCount);
            }
        }
    }

    private static Set<String> collectIndexDefinitionPaths(InstallContext context) throws RepositoryException {
        Session session = context.getSession();
        WorkspaceFilter filter = context.getPackage().getArchive().getMetaInf().getFilter();
        IndexDefinitionListener collector = new IndexDefinitionListener("A");
        filter.dumpCoverage(session.getRootNode(), (ProgressTrackerListener)collector);
        return collector.getIndexDefinitionPaths();
    }

    private static Map<String, ReindexRecord> removeReindexProperties(Session session, Set<String> paths) throws RepositoryException {
        HashMap<String, ReindexRecord> records = new HashMap<String, ReindexRecord>();
        for (String path : paths) {
            Property property;
            ReindexRecord record = new ReindexRecord();
            Node definition = session.getNode(path);
            if (definition.hasProperty(PN_REINDEX)) {
                property = definition.getProperty(PN_REINDEX);
                record.reindex = property.getBoolean();
                property.remove();
            }
            if (definition.hasProperty(PN_REINDEX_COUNT)) {
                property = definition.getProperty(PN_REINDEX_COUNT);
                record.reindexCount = property.getLong();
                property.remove();
            }
            records.put(path, record);
        }
        return records;
    }

    private static class ReindexRecord {
        boolean reindex = false;
        long reindexCount = -1L;

        private ReindexRecord() {
        }
    }
}

