/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;

public class CompoundProgressTrackerListener
implements ProgressTrackerListener {
    private List<ProgressTrackerListener> listeners;

    private CompoundProgressTrackerListener(List<ProgressTrackerListener> listeners) {
        this.listeners = listeners;
    }

    public static ProgressTrackerListener create(ProgressTrackerListener ... listeners) {
        ArrayList<ProgressTrackerListener> ptls = new ArrayList<ProgressTrackerListener>();
        for (ProgressTrackerListener listener : listeners) {
            if (listener == null) continue;
            if (listener instanceof CompoundProgressTrackerListener) {
                ptls.addAll(((CompoundProgressTrackerListener)listener).listeners);
                continue;
            }
            ptls.add(listener);
        }
        return new CompoundProgressTrackerListener(ptls);
    }

    public void onMessage(ProgressTrackerListener.Mode mode, String action, String path) {
        for (ProgressTrackerListener listener : this.listeners) {
            listener.onMessage(mode, action, path);
        }
    }

    public void onError(ProgressTrackerListener.Mode mode, String path, Exception e) {
        for (ProgressTrackerListener listener : this.listeners) {
            listener.onError(mode, path, e);
        }
    }
}

