/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.aceservice.impl;

import biz.netcentric.cq.tools.actool.aceservice.AceService;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableCreatorException;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableCreatorService;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableInstallationHistory;
import biz.netcentric.cq.tools.actool.configreader.ConfigFilesRetriever;
import biz.netcentric.cq.tools.actool.configreader.ConfigReader;
import biz.netcentric.cq.tools.actool.configreader.YamlConfigurationMerger;
import biz.netcentric.cq.tools.actool.dumpservice.Dumpservice;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.helper.AceBean;
import biz.netcentric.cq.tools.actool.helper.AclBean;
import biz.netcentric.cq.tools.actool.helper.PurgeHelper;
import biz.netcentric.cq.tools.actool.helper.QueryHelper;
import biz.netcentric.cq.tools.actool.installationhistory.AcHistoryService;
import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang.time.StopWatch;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(metatype=true, label="AC Installation Service", description="Service that installs groups & ACEs according to textual configuration files")
public class AceServiceImpl
implements AceService {
    private static final Logger LOG = LoggerFactory.getLogger(AceServiceImpl.class);
    static final String PROPERTY_CONFIGURATION_PATH = "AceService.configurationPath";
    @Reference
    AuthorizableCreatorService authorizableCreatorService;
    @Reference
    private SlingRepository repository;
    @Reference
    AcHistoryService acHistoryService;
    @Reference
    private Dumpservice dumpservice;
    @Reference
    private ConfigReader configReader;
    @Reference
    private ConfigFilesRetriever configFilesRetriever;
    private boolean isExecuting = false;
    @Property(label="Configuration storage path", description="enter CRX path where ACE configuration gets stored", name="AceService.configurationPath", value={""})
    private String configurationPath;

    @Activate
    public void activate(Map properties) throws Exception {
        LOG.debug("Activated AceService!");
        this.modified(properties);
    }

    @Modified
    public void modified(Map properties) {
        LOG.debug("Modified AceService!");
        this.configurationPath = PropertiesUtil.toString(properties.get(PROPERTY_CONFIGURATION_PATH), (String)"");
    }

    private void installConfigurationFromYamlList(List mergedConfigurations, AcInstallationHistoryPojo history, Session session, Set<AuthorizableInstallationHistory> authorizableHistorySet, Map<String, Set<AceBean>> repositoryDumpAceMap) throws Exception {
        Map authorizablesMapfromConfig = (Map)mergedConfigurations.get(0);
        Map aceMapFromConfig = (Map)mergedConfigurations.get(1);
        if (aceMapFromConfig == null) {
            String message = "ace config not found in YAML file! installation aborted!";
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.removeAcesForAuthorizable(history, session, authorizablesMapfromConfig.keySet(), repositoryDumpAceMap);
        this.installAuthorizables(history, authorizableHistorySet, authorizablesMapfromConfig);
        this.installAces(history, session, aceMapFromConfig);
    }

    private void removeAcesForAuthorizable(AcInstallationHistoryPojo history, Session session, Set<String> authorizablesSet, Map<String, Set<AceBean>> repositoryDumpAceMap) throws UnsupportedRepositoryOperationException, RepositoryException {
        for (Map.Entry<String, Set<AceBean>> entry : repositoryDumpAceMap.entrySet()) {
            Set<AceBean> acl = entry.getValue();
            for (AceBean aceBean : acl) {
                if (!authorizablesSet.contains(aceBean.getPrincipalName())) continue;
                AccessControlUtils.deleteAllEntriesForAuthorizableFromACL(session, aceBean.getJcrPath(), aceBean.getPrincipalName());
                String message = "deleted all ACEs of authorizable " + aceBean.getPrincipalName() + " from ACL of path: " + aceBean.getJcrPath();
                LOG.info(message);
                history.addVerboseMessage(message);
            }
        }
    }

    private void installAces(AcInstallationHistoryPojo history, Session session, Map<String, Set<AceBean>> aceMapFromConfig) throws Exception {
        Map<String, Set<AceBean>> pathBasedAceMapFromConfig = AcHelper.getPathBasedAceMap(aceMapFromConfig, AcHelper.ACE_ORDER_DENY_ALLOW);
        LOG.info("--- start installation of access control configuration ---");
        AcHelper.installPathBasedACEs(pathBasedAceMapFromConfig, session, history);
    }

    private void installAuthorizables(AcInstallationHistoryPojo history, Set<AuthorizableInstallationHistory> authorizableHistorySet, Map<String, LinkedHashSet<AuthorizableConfigBean>> authorizablesMapfromConfig) throws RepositoryException, Exception {
        LOG.info("--- start installation of Authorizable Configuration ---");
        Session authorizableInstallationSession = this.repository.loginAdministrative(null);
        try {
            AuthorizableInstallationHistory authorizableInstallationHistory = new AuthorizableInstallationHistory();
            authorizableHistorySet.add(authorizableInstallationHistory);
            this.authorizableCreatorService.createNewAuthorizables(authorizablesMapfromConfig, authorizableInstallationSession, history, authorizableInstallationHistory);
            authorizableInstallationSession.save();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (authorizableInstallationSession != null) {
                authorizableInstallationSession.logout();
            }
        }
        String message = "finished installation of groups configuration without errors!";
        history.addMessage(message);
        LOG.info(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcInstallationHistoryPojo execute() {
        Session session = null;
        AcInstallationHistoryPojo history = new AcInstallationHistoryPojo();
        LinkedHashSet<AuthorizableInstallationHistory> authorizableInstallationHistorySet = new LinkedHashSet<AuthorizableInstallationHistory>();
        try {
            session = this.repository.loginAdministrative(null);
            String rootPath = this.getConfigurationRootPath();
            Node rootNode = session.getNode(rootPath);
            Map<String, String> newestConfigurations = this.configFilesRetriever.getConfigFileContentFromNode(rootNode);
            this.installNewConfigurations(session, history, newestConfigurations, authorizableInstallationHistorySet);
        }
        catch (AuthorizableCreatorException e) {
            history.addError(e.toString());
        }
        catch (Exception e) {
            session.logout();
            LOG.error("Exception in AceServiceImpl: {}", (Throwable)e);
            history.addError(e.toString());
            for (AuthorizableInstallationHistory authorizableInstallationHistory : authorizableInstallationHistorySet) {
                try {
                    String message = "performing authorizable installation rollback(s)";
                    LOG.info(message);
                    history.addMessage(message);
                    this.authorizableCreatorService.performRollback(this.repository, authorizableInstallationHistory, history);
                }
                catch (RepositoryException e1) {
                    LOG.error("Exception: ", (Throwable)e1);
                }
            }
        }
        finally {
            session.logout();
            this.isExecuting = false;
            this.acHistoryService.persistHistory(history, this.configurationPath);
        }
        return history;
    }

    @Override
    public void installNewConfigurations(Session session, AcInstallationHistoryPojo history, Map<String, String> newestConfigurations, Set<AuthorizableInstallationHistory> authorizableInstallationHistorySet) throws Exception {
        StopWatch sw = new StopWatch();
        sw.start();
        this.isExecuting = true;
        if (newestConfigurations != null) {
            YamlConfigurationMerger configurationMerger = new YamlConfigurationMerger();
            List mergedConfigurations = configurationMerger.getMergedConfigurations(newestConfigurations, history, this.configReader);
            this.installMergedConfigurations(history, session, authorizableInstallationHistorySet, mergedConfigurations);
            history.addMessage("finished (transient) installation of access control configuration without errors!");
            session.save();
            history.addMessage("persisted changes of ACLs");
        }
        sw.stop();
        long executionTime = sw.getTime();
        LOG.info("installation of AccessControlConfiguration took: {} ms", (Object)executionTime);
        history.setExecutionTime(executionTime);
    }

    private void installMergedConfigurations(AcInstallationHistoryPojo history, Session session, Set<AuthorizableInstallationHistory> authorizableInstallationHistorySet, List mergedConfigurations) throws ValueFormatException, RepositoryException, Exception {
        String message = "start installation of merged configurations";
        LOG.info(message);
        history.addMessage(message);
        Map<String, Set<AceBean>> repositoryDumpAceMap = null;
        LOG.info("start building dump from repository");
        repositoryDumpAceMap = this.dumpservice.createAclDumpMap(session, AcHelper.PATH_BASED_ORDER, AcHelper.ACE_ORDER_NONE, this.dumpservice.getQueryExcludePaths()).getAceDump();
        this.installConfigurationFromYamlList(mergedConfigurations, history, session, authorizableInstallationHistorySet, repositoryDumpAceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadyToStart() {
        String rootPath = this.getConfigurationRootPath();
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            Node rootNode = session.getNode(rootPath);
            boolean bl = !this.configFilesRetriever.getConfigFileContentFromNode(rootNode).isEmpty();
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String purgeACL(String path) {
        Session session = null;
        String message = "";
        boolean flag = true;
        try {
            session = this.repository.loginAdministrative(null);
            PurgeHelper.purgeAcl(session, path);
            session.save();
        }
        catch (Exception e) {
            flag = false;
            message = e.toString();
            LOG.error("Exception: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        if (flag) {
            message = "Deleted AccessControlList of node: " + path;
            AcInstallationHistoryPojo history = new AcInstallationHistoryPojo();
            history.addMessage("purge method: purgeACL()");
            history.addMessage(message);
            this.acHistoryService.persistAcePurgeHistory(history);
            return message;
        }
        return "Deletion of ACL failed! Reason:" + message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String purgeACLs(String path) {
        Session session = null;
        String message = "";
        boolean flag = true;
        try {
            session = this.repository.loginAdministrative(null);
            message = PurgeHelper.purgeACLs(session, path);
            AcInstallationHistoryPojo history = new AcInstallationHistoryPojo();
            history.addMessage("purge method: purgeACLs()");
            history.addMessage(message);
            this.acHistoryService.persistAcePurgeHistory(history);
            session.save();
        }
        catch (Exception e) {
            LOG.error("Exception: ", (Throwable)e);
            flag = false;
            message = e.toString();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        if (flag) {
            return message;
        }
        return "Deletion of ACL failed! Reason:" + message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String purgeAuthorizablesFromConfig() {
        Session session = null;
        String message = "";
        try {
            session = this.repository.loginAdministrative(null);
            Set<String> authorizabesFromConfigurations = this.getAllAuthorizablesFromConfig(session);
            message = this.purgeAuthorizables(authorizabesFromConfigurations, session);
            AcInstallationHistoryPojo history = new AcInstallationHistoryPojo();
            history.addMessage("purge method: purgAuthorizablesFromConfig()");
            history.addMessage(message);
            this.acHistoryService.persistAcePurgeHistory(history);
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: ", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Exception: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String purgeAuthorizables(String authorizableIds) {
        Session session = null;
        String message = "";
        try {
            try {
                session = this.repository.loginAdministrative(null);
                authorizableIds = authorizableIds.trim();
                HashSet<String> authorizablesSet = new HashSet<String>(new ArrayList<String>(Arrays.asList(authorizableIds.split(","))));
                message = this.purgeAuthorizables(authorizablesSet, session);
                AcInstallationHistoryPojo history = new AcInstallationHistoryPojo();
                history.addMessage("purge method: purgeAuthorizables()");
                history.addMessage(message);
                this.acHistoryService.persistAcePurgeHistory(history);
            }
            catch (RepositoryException e) {
                LOG.error("Exception: ", (Throwable)e);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return message;
    }

    private String purgeAuthorizables(Set<String> authorizableIds, Session session) {
        StringBuilder message = new StringBuilder();
        String message2 = "";
        try {
            JackrabbitSession js = (JackrabbitSession)session;
            UserManager userManager = js.getUserManager();
            if (userManager.isAutoSave()) {
                try {
                    userManager.autoSave(false);
                }
                catch (UnsupportedRepositoryOperationException e) {
                    LOG.warn("disabling autoSave not possible with this user manager!");
                }
            }
            PrincipalManager principalManager = js.getPrincipalManager();
            for (String authorizableId : authorizableIds) {
                message.append(this.deleteAuthorizableFromHome(authorizableId, userManager, principalManager));
            }
            Set<AclBean> aclBeans = QueryHelper.getAuthorizablesAcls(session, authorizableIds);
            message.append(PurgeHelper.deleteAcesFromAuthorizables(session, authorizableIds, aclBeans));
            session.save();
        }
        catch (RepositoryException e) {
            message2 = message2 + " deletion of ACEs failed! reason: RepositoryException: " + e.toString();
            LOG.error("RepositoryException: ", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Exception: ", (Throwable)e);
        }
        return message + message2;
    }

    private String deleteAuthorizableFromHome(String authorizableId, UserManager userManager, PrincipalManager principalManager) {
        String message;
        if (principalManager.hasPrincipal(authorizableId)) {
            try {
                Authorizable authorizable = userManager.getAuthorizable(authorizableId);
                authorizable.remove();
            }
            catch (RepositoryException e) {
                LOG.error("RepositoryException: ", (Throwable)e);
            }
            message = "removed authorizable: " + authorizableId + " from /home\n";
        } else {
            message = "deletion of authorizable: " + authorizableId + " from home failed! Reason: authorizable doesn't exist\n";
        }
        return message;
    }

    @Override
    public boolean isExecuting() {
        return this.isExecuting;
    }

    @Override
    public String getConfigurationRootPath() {
        return this.configurationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getCurrentConfigurationPaths() {
        Session session = null;
        Set<String> paths = new LinkedHashSet<String>();
        try {
            session = this.repository.loginAdministrative(null);
            Node rootNode = session.getNode(this.configurationPath);
            paths = this.configFilesRetriever.getConfigFileContentFromNode(rootNode).keySet();
        }
        catch (Exception exception) {
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return paths;
    }

    public Set<String> getAllAuthorizablesFromConfig(Session session) throws Exception {
        AcInstallationHistoryPojo history = new AcInstallationHistoryPojo();
        Node rootNode = session.getNode(this.configurationPath);
        Map<String, String> newestConfigurations = this.configFilesRetriever.getConfigFileContentFromNode(rootNode);
        YamlConfigurationMerger configurationMeger = new YamlConfigurationMerger();
        List mergedConfigurations = configurationMeger.getMergedConfigurations(newestConfigurations, history, this.configReader);
        return ((Map)mergedConfigurations.get(0)).keySet();
    }

    protected void bindAuthorizableCreatorService(AuthorizableCreatorService authorizableCreatorService) {
        this.authorizableCreatorService = authorizableCreatorService;
    }

    protected void unbindAuthorizableCreatorService(AuthorizableCreatorService authorizableCreatorService) {
        if (this.authorizableCreatorService == authorizableCreatorService) {
            this.authorizableCreatorService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindAcHistoryService(AcHistoryService acHistoryService) {
        this.acHistoryService = acHistoryService;
    }

    protected void unbindAcHistoryService(AcHistoryService acHistoryService) {
        if (this.acHistoryService == acHistoryService) {
            this.acHistoryService = null;
        }
    }

    protected void bindDumpservice(Dumpservice dumpservice) {
        this.dumpservice = dumpservice;
    }

    protected void unbindDumpservice(Dumpservice dumpservice) {
        if (this.dumpservice == dumpservice) {
            this.dumpservice = null;
        }
    }

    protected void bindConfigReader(ConfigReader configReader) {
        this.configReader = configReader;
    }

    protected void unbindConfigReader(ConfigReader configReader) {
        if (this.configReader == configReader) {
            this.configReader = null;
        }
    }

    protected void bindConfigFilesRetriever(ConfigFilesRetriever configFilesRetriever) {
        this.configFilesRetriever = configFilesRetriever;
    }

    protected void unbindConfigFilesRetriever(ConfigFilesRetriever configFilesRetriever) {
        if (this.configFilesRetriever == configFilesRetriever) {
            this.configFilesRetriever = null;
        }
    }
}

