/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.aceservicejmx.impl;

import biz.netcentric.cq.tools.actool.aceservice.AceService;
import biz.netcentric.cq.tools.actool.aceservicejmx.AceServiceMBean;
import biz.netcentric.cq.tools.actool.dumpservice.Dumpservice;
import biz.netcentric.cq.tools.actool.installationhistory.AcHistoryService;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.Set;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.lang.time.StopWatch;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
@Properties(value={@Property(name="jmx.objectname", value={"biz.netcentric.cq.tools.actool:id='ac installation'"}), @Property(name="pattern", value={"/.*"})})
public class AceServiceMBeanImpl
extends AnnotatedStandardMBean
implements AceServiceMBean {
    private static final Logger LOG = LoggerFactory.getLogger(AceServiceMBeanImpl.class);
    @Reference
    AceService aceService;
    @Reference
    AcHistoryService acHistoryService;
    @Reference
    Dumpservice dumpservice;

    public AceServiceMBeanImpl() throws NotCompliantMBeanException {
        super(AceServiceMBean.class);
    }

    @Override
    public String execute() {
        return this.aceService.execute().toString();
    }

    @Override
    public boolean isReadyToStart() {
        return this.aceService.isReadyToStart();
    }

    @Override
    public String purgeACL(String path) {
        return this.aceService.purgeACL(path);
    }

    @Override
    public String purgeACLs(String path) {
        return this.aceService.purgeACLs(path);
    }

    @Override
    public boolean isExecuting() {
        return this.aceService.isExecuting();
    }

    @Override
    public String[] getConfigurationFiles() {
        Set<String> paths = this.aceService.getCurrentConfigurationPaths();
        StringBuilder sb = new StringBuilder();
        int cnt = 1;
        for (String path : paths) {
            sb.append(cnt + ". " + path + " \n");
            ++cnt;
        }
        return paths.toArray(new String[paths.size()]);
    }

    @Override
    public String[] getSavedLogs() {
        String[] logs = this.acHistoryService.getInstallationLogPaths();
        if (logs.length == 0) {
            return new String[]{"no logs found"};
        }
        return logs;
    }

    @Override
    public String pathBasedDump() {
        StopWatch sw = new StopWatch();
        sw.start();
        String dump = this.dumpservice.getCompletePathBasedDumpsAsString();
        sw.stop();
        LOG.info("path based dump took: " + sw.getTime() + " ms");
        return dump;
    }

    @Override
    public String groupBasedDump() {
        StopWatch sw = new StopWatch();
        sw.start();
        String dump = this.dumpservice.getCompletePrincipalBasedDumpsAsString();
        sw.stop();
        LOG.info("group based dump took: " + sw.getTime() + " ms");
        return dump;
    }

    @Override
    public String showHistoryLog(String n) {
        int i;
        String[] logs = this.acHistoryService.getInstallationLogPaths();
        if (logs.length == 0) {
            return "no logs found";
        }
        int numberOfFoundLogs = logs.length;
        String errorMessage = "please enter a valid log number (between 1 and " + numberOfFoundLogs + ")";
        try {
            i = Integer.parseInt(n);
        }
        catch (NumberFormatException e) {
            return errorMessage;
        }
        if (i < 1 || i > numberOfFoundLogs) {
            return errorMessage;
        }
        return this.acHistoryService.showHistory(i);
    }

    @Override
    public String purgeAllAuthorizablesFromConfigurations() {
        return this.aceService.purgeAuthorizablesFromConfig();
    }

    @Override
    public String purgeAuthorizables(String authorizableIds) {
        return this.aceService.purgeAuthorizables(authorizableIds);
    }

    protected void bindAceService(AceService aceService) {
        this.aceService = aceService;
    }

    protected void unbindAceService(AceService aceService) {
        if (this.aceService == aceService) {
            this.aceService = null;
        }
    }

    protected void bindAcHistoryService(AcHistoryService acHistoryService) {
        this.acHistoryService = acHistoryService;
    }

    protected void unbindAcHistoryService(AcHistoryService acHistoryService) {
        if (this.acHistoryService == acHistoryService) {
            this.acHistoryService = null;
        }
    }

    protected void bindDumpservice(Dumpservice dumpservice) {
        this.dumpservice = dumpservice;
    }

    protected void unbindDumpservice(Dumpservice dumpservice) {
        if (this.dumpservice == dumpservice) {
            this.dumpservice = null;
        }
    }
}

