/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.authorizableutils.impl;

import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableBean;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableCreatorException;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableCreatorService;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableInstallationHistory;
import biz.netcentric.cq.tools.actool.authorizableutils.impl.PrincipalImpl;
import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(metatype=true, label="AuthorizableCreatorService Service", description="Service that installs groups according to textual configuration files")
public class AuthorizableCreatorServiceImpl
implements AuthorizableCreatorService {
    private static final String PATH_HOME_GROUPS = "/home/groups";
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizableCreatorServiceImpl.class);
    AcInstallationHistoryPojo status;
    Map<String, LinkedHashSet<AuthorizableConfigBean>> principalMapFromConfig;
    AuthorizableInstallationHistory authorizableInstallationHistory;

    @Override
    public void createNewAuthorizables(Map<String, LinkedHashSet<AuthorizableConfigBean>> principalMapFromConfig, Session session, AcInstallationHistoryPojo status, AuthorizableInstallationHistory authorizableInstallationHistory) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException, AuthorizableCreatorException {
        this.status = status;
        this.principalMapFromConfig = principalMapFromConfig;
        this.authorizableInstallationHistory = authorizableInstallationHistory;
        Set<String> groupsFromConfigurations = principalMapFromConfig.keySet();
        for (String principalId : groupsFromConfigurations) {
            LinkedHashSet<AuthorizableConfigBean> currentPrincipalData = principalMapFromConfig.get(principalId);
            Iterator it = currentPrincipalData.iterator();
            AuthorizableConfigBean tmpPricipalConfigBean = null;
            while (it.hasNext()) {
                tmpPricipalConfigBean = (AuthorizableConfigBean)it.next();
                status.addVerboseMessage("Starting installation of authorizable bean: " + tmpPricipalConfigBean.toString());
            }
            this.installAuthorizableConfigurationBean(session, tmpPricipalConfigBean, status, authorizableInstallationHistory);
        }
    }

    private void installAuthorizableConfigurationBean(Session session, AuthorizableConfigBean authorizableConfigBean, AcInstallationHistoryPojo history, AuthorizableInstallationHistory authorizableInstallationHistory) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException, AuthorizableExistsException, AuthorizableCreatorException {
        String principalId = authorizableConfigBean.getPrincipalID();
        LOG.info("- start installation of authorizable: {}", (Object)principalId);
        UserManager userManager = this.getUsermanager(session);
        ValueFactory vf = session.getValueFactory();
        if (userManager.getAuthorizable(principalId) == null) {
            this.createNewAuthorizable(authorizableConfigBean, history, authorizableInstallationHistory, userManager, vf);
        } else if (authorizableConfigBean.isGroup()) {
            this.handleIntermediatePath(session, authorizableConfigBean, history, authorizableInstallationHistory, userManager);
            this.mergeGroup(history, authorizableInstallationHistory, authorizableConfigBean, userManager);
        } else {
            String msg = "- authorizable " + principalId + " exists and is a user - moving and updating of users is not implemented yet.";
            LOG.info(msg);
            history.addMessage(msg);
        }
    }

    private UserManager getUsermanager(Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitSession js = (JackrabbitSession)session;
        UserManager userManager = js.getUserManager();
        if (userManager.isAutoSave()) {
            try {
                userManager.autoSave(false);
            }
            catch (UnsupportedRepositoryOperationException e) {
                LOG.warn("disabling autoSave not possible with this user manager!");
            }
        }
        return userManager;
    }

    private void handleIntermediatePath(Session session, AuthorizableConfigBean principalConfigBean, AcInstallationHistoryPojo history, AuthorizableInstallationHistory authorizableInstallationHistory, UserManager userManager) throws RepositoryException, UnsupportedRepositoryOperationException, AuthorizableExistsException, AuthorizableCreatorException, PathNotFoundException, VersionException, LockException, ConstraintViolationException, AccessDeniedException {
        String principalId = principalConfigBean.getPrincipalID();
        Authorizable existingAuthorizable = userManager.getAuthorizable(principalId);
        if (existingAuthorizable.isGroup()) {
            Group existingGroup = (Group)existingAuthorizable;
            String intermediatedPathOfExistingGroup = existingGroup.getPath().substring(0, existingGroup.getPath().lastIndexOf("/"));
            String groupPathFromBean = principalConfigBean.getPath();
            if (groupPathFromBean.charAt(0) != '/') {
                groupPathFromBean = "/home/groups/" + groupPathFromBean;
            }
            if (!StringUtils.equals((String)intermediatedPathOfExistingGroup, (String)groupPathFromBean)) {
                StringBuilder message = new StringBuilder();
                message.append("found change of intermediate path:").append("\n");
                message.append("existing group: " + existingGroup.getID() + " has intermediate path: " + intermediatedPathOfExistingGroup).append("\n");
                message.append("group from config: " + principalConfigBean.getPrincipalID() + " has intermediate path: " + groupPathFromBean).append("\n");
                HashSet membersOfDeletedGroup = new HashSet();
                Iterator memberIt = existingGroup.getDeclaredMembers();
                while (memberIt.hasNext()) {
                    membersOfDeletedGroup.add(memberIt.next());
                }
                existingGroup.remove();
                ValueFactory vf = session.getValueFactory();
                Group newGroup = (Group)this.createNewAuthorizable(principalConfigBean, history, authorizableInstallationHistory, userManager, vf);
                for (Authorizable authorizable : membersOfDeletedGroup) {
                    newGroup.addMember(authorizable);
                }
                this.deleteOldIntermediatePath(session, session.getNode(intermediatedPathOfExistingGroup));
                message.append("recreated group with new intermediate path!");
                history.addMessage(message.toString());
                LOG.warn(message.toString());
            }
        }
    }

    private void deleteOldIntermediatePath(Session session, Node oldIntermediateNode) throws RepositoryException, PathNotFoundException, VersionException, LockException, ConstraintViolationException, AccessDeniedException {
        while (!(StringUtils.equals((String)PATH_HOME_GROUPS, (String)oldIntermediateNode.getPath()) || StringUtils.equals((String)"/home/users", (String)oldIntermediateNode.getPath()) || oldIntermediateNode.hasNodes())) {
            Node parent = oldIntermediateNode.getParent();
            session.removeItem(oldIntermediateNode.getPath());
            oldIntermediateNode = parent;
        }
    }

    private void mergeGroup(AcInstallationHistoryPojo status, AuthorizableInstallationHistory authorizableInstallationHistory, AuthorizableConfigBean principalConfigBean, UserManager userManager) throws RepositoryException, ValueFormatException, UnsupportedRepositoryOperationException, AuthorizableExistsException, AuthorizableCreatorException {
        String[] memberOf = principalConfigBean.getMemberOf();
        String principalId = principalConfigBean.getPrincipalID();
        String message = "Problem while trying to create new authorizable: " + principalId + ". Authorizable already exists!";
        LOG.warn(message);
        Authorizable currentGroupFromRepository = userManager.getAuthorizable(principalId);
        Set<String> membershipGroupsFromConfig = this.getMembershipGroupsFromConfig(memberOf);
        Set<String> membershipGroupsFromRepository = this.getMembershipGroupsFromRepository(currentGroupFromRepository);
        String authorizableName = "";
        if (currentGroupFromRepository.getProperty("profile/givenName") != null) {
            authorizableName = currentGroupFromRepository.getProperty("profile/givenName")[0].getString();
        }
        authorizableInstallationHistory.addAuthorizable(currentGroupFromRepository.getID(), authorizableName, currentGroupFromRepository.getPath(), membershipGroupsFromRepository);
        this.mergeMemberOfGroups(principalId, status, userManager, currentGroupFromRepository, membershipGroupsFromConfig, membershipGroupsFromRepository);
    }

    private Authorizable createNewAuthorizable(AuthorizableConfigBean principalConfigBean, AcInstallationHistoryPojo status, AuthorizableInstallationHistory authorizableInstallationHistory, UserManager userManager, ValueFactory vf) throws AuthorizableExistsException, RepositoryException, AuthorizableCreatorException {
        boolean isGroup = principalConfigBean.isGroup();
        String principalId = principalConfigBean.getPrincipalID();
        Authorizable newAuthorizable = null;
        if (isGroup) {
            newAuthorizable = this.createNewGroup(userManager, principalConfigBean, status, authorizableInstallationHistory, vf, this.principalMapFromConfig);
            authorizableInstallationHistory.addNewCreatedAuthorizabe(principalId);
            LOG.info("Successfully created new Group: {}", (Object)principalId);
        } else {
            newAuthorizable = this.createNewUser(userManager, principalConfigBean, status, authorizableInstallationHistory, vf, this.principalMapFromConfig);
            LOG.info("Successfully created new User: {}", (Object)principalId);
            authorizableInstallationHistory.addNewCreatedAuthorizabe(principalId);
        }
        return newAuthorizable;
    }

    private Set<String> getMembershipGroupsFromRepository(Authorizable currentGroupFromRepository) throws RepositoryException {
        HashSet<String> membershipGroupsFromRepository = new HashSet<String>();
        Iterator memberOfGroupsIterator = currentGroupFromRepository.declaredMemberOf();
        while (memberOfGroupsIterator.hasNext()) {
            Authorizable memberOfGroup = (Authorizable)memberOfGroupsIterator.next();
            membershipGroupsFromRepository.add(memberOfGroup.getID());
        }
        return membershipGroupsFromRepository;
    }

    private Set<String> getMembershipGroupsFromConfig(String[] memberOf) {
        HashSet<String> membershipGroupsFromConfig = new HashSet<String>();
        if (memberOf != null) {
            for (String s : memberOf) {
                membershipGroupsFromConfig.add(s);
            }
        }
        return membershipGroupsFromConfig;
    }

    private void mergeMemberOfGroups(String principalId, AcInstallationHistoryPojo status, UserManager userManager, Authorizable currentGroupFromRepository, Set<String> membershipGroupsFromConfig, Set<String> membershipGroupsFromRepository) throws RepositoryException, AuthorizableExistsException, AuthorizableCreatorException {
        LOG.info("...checking differences");
        if (!this.isMemberOfOtherGroup(currentGroupFromRepository) && membershipGroupsFromConfig.isEmpty()) {
            LOG.info("{}: authorizable in repo is not member of any other group and group in config is not member of any other group. No change necessary here!", (Object)principalId);
        } else if (!this.isMemberOfOtherGroup(currentGroupFromRepository) && !membershipGroupsFromConfig.isEmpty()) {
            this.mergeMemberOfGroupsFromConfig(principalId, status, userManager, membershipGroupsFromConfig);
        } else if (this.isMemberOfOtherGroup(currentGroupFromRepository) && membershipGroupsFromConfig.isEmpty()) {
            this.mergeMemberOfGroupsFromRepo(principalId, userManager, membershipGroupsFromRepository);
        } else if (this.isMemberOfOtherGroup(currentGroupFromRepository) && !membershipGroupsFromConfig.isEmpty()) {
            this.mergeMultipleMembersOfBothGroups(principalId, status, userManager, membershipGroupsFromConfig, membershipGroupsFromRepository);
        }
    }

    private void mergeMemberOfGroupsFromRepo(String principalId, UserManager userManager, Set<String> membershipGroupsFromRepository) throws RepositoryException {
        LOG.info("{}: authorizable in repo is member of at least one other group and authorizable in config is not member of any other group", (Object)principalId);
        for (String group : membershipGroupsFromRepository) {
            LOG.info("{}: delete authorizable from members of group {} in repository", (Object)principalId, (Object)group);
            ((Group)userManager.getAuthorizable(group)).removeMember(userManager.getAuthorizable(principalId));
        }
    }

    private void mergeMemberOfGroupsFromConfig(String principalId, AcInstallationHistoryPojo status, UserManager userManager, Set<String> membershipGroupsFromConfig) throws RepositoryException, AuthorizableExistsException, AuthorizableCreatorException {
        LOG.info("{}: authorizable in repo is not member of any other group  but authorizable in config is member of at least one other group", (Object)principalId);
        Set<Authorizable> validatedGroups = this.validateAssignedGroups(userManager, principalId, membershipGroupsFromConfig.toArray(new String[0]));
        for (Authorizable membershipGroup : validatedGroups) {
            LOG.info("{}: add authorizable to members of group {} in repository", (Object)principalId, (Object)membershipGroup.getID());
            if (StringUtils.equals((String)membershipGroup.getID(), (String)principalId)) {
                String warning = "Attempt to add a group as member of itself (" + membershipGroup.getID() + ").";
                LOG.warn(warning);
                status.addWarning(warning);
                continue;
            }
            ((Group)membershipGroup).addMember(userManager.getAuthorizable(principalId));
        }
    }

    private void mergeMultipleMembersOfBothGroups(String principalId, AcInstallationHistoryPojo status, UserManager userManager, Set<String> membershipGroupsFromConfig, Set<String> membershipGroupsFromRepository) throws RepositoryException, AuthorizableExistsException, AuthorizableCreatorException {
        if (membershipGroupsFromRepository.equals(membershipGroupsFromConfig)) {
            LOG.info("{}: authorizable in repo  and authorizable in config are members of the same group(s). No change necessary here!", (Object)principalId);
        } else {
            LOG.info("{}: authorizable in repo is member of at least one other group and authorizable in config is member of at least one other group", (Object)principalId);
            for (String authorizable : membershipGroupsFromRepository) {
                if (membershipGroupsFromConfig.contains(authorizable)) continue;
                LOG.info("delete {} from members of group {} in repository", (Object)principalId, (Object)authorizable);
                ((Group)userManager.getAuthorizable(authorizable)).removeMember(userManager.getAuthorizable(principalId));
            }
            Set<Authorizable> validatedGroups = this.validateAssignedGroups(userManager, principalId, membershipGroupsFromConfig.toArray(new String[0]));
            for (Authorizable authorizable : validatedGroups) {
                if (membershipGroupsFromRepository.contains(authorizable.getID())) continue;
                LOG.info("add {} to members of group {} in repository", (Object)principalId, (Object)authorizable);
                if (StringUtils.equals((String)authorizable.getID(), (String)principalId)) {
                    String warning = "Attempt to add a group as member of itself (" + authorizable + ").";
                    LOG.warn(warning);
                    status.addWarning(warning);
                    continue;
                }
                ((Group)authorizable).addMember(userManager.getAuthorizable(principalId));
            }
        }
    }

    private boolean isMemberOfOtherGroup(Authorizable group) throws RepositoryException {
        Iterator it = group.declaredMemberOf();
        return it.hasNext();
    }

    private Authorizable createNewGroup(UserManager userManager, AuthorizableConfigBean principalConfigBean, AcInstallationHistoryPojo status, AuthorizableInstallationHistory authorizableInstallationHistory, ValueFactory vf, Map<String, LinkedHashSet<AuthorizableConfigBean>> principalMapFromConfig) throws AuthorizableExistsException, RepositoryException, AuthorizableCreatorException {
        Set<Authorizable> assignedGroups;
        String groupID = principalConfigBean.getPrincipalID();
        String name = principalConfigBean.getPrincipalName();
        String[] memberOf = principalConfigBean.getMemberOf();
        String intermediatePath = principalConfigBean.getPath();
        Group newGroup = null;
        try {
            newGroup = userManager.createGroup((Principal)new PrincipalImpl(groupID), intermediatePath);
        }
        catch (AuthorizableExistsException e) {
            LOG.warn("Group {} already exists in system!", (Object)groupID);
            newGroup = (Group)userManager.getAuthorizable(groupID);
        }
        if (memberOf != null && memberOf.length > 0 && !(assignedGroups = this.validateAssignedGroups(userManager, groupID, memberOf)).isEmpty()) {
            LOG.info("start adding {} to assignedGroups", (Object)groupID);
            for (Authorizable authorizable : assignedGroups) {
                ((Group)authorizable).addMember((Authorizable)newGroup);
                LOG.info("added to {} ", (Object)authorizable);
            }
        }
        if (StringUtils.isNotBlank((String)name)) {
            newGroup.setProperty("profile/givenName", vf.createValue(name));
        }
        return newGroup;
    }

    private Authorizable createNewUser(UserManager userManager, AuthorizableConfigBean principalConfigBean, AcInstallationHistoryPojo status, AuthorizableInstallationHistory authorizableInstallationHistory, ValueFactory vf, Map<String, LinkedHashSet<AuthorizableConfigBean>> principalMapFromConfig) throws AuthorizableExistsException, RepositoryException, AuthorizableCreatorException {
        Set<Authorizable> authorizables;
        String principalId = principalConfigBean.getPrincipalID();
        String name = principalConfigBean.getPrincipalName();
        String[] memberOf = principalConfigBean.getMemberOf();
        String password = principalConfigBean.getPassword();
        boolean isSystemUser = principalConfigBean.isSystemUser();
        String intermediatePath = principalConfigBean.getPath();
        User newUser = null;
        newUser = isSystemUser ? this.userManagerCreateSystemUserViaReflection(userManager, principalId, intermediatePath, status) : userManager.createUser(principalId, password, (Principal)new PrincipalImpl(principalId), intermediatePath);
        if (!isSystemUser && StringUtils.isNotBlank((String)name)) {
            String givenName = StringUtils.substringBeforeLast((String)name, (String)" ");
            String familyName = StringUtils.substringAfterLast((String)name, (String)" ");
            newUser.setProperty("profile/givenName", vf.createValue(givenName));
            newUser.setProperty("profile/familyName", vf.createValue(familyName));
        }
        if (memberOf != null && memberOf.length > 0 && !(authorizables = this.validateAssignedGroups(userManager, principalId, memberOf)).isEmpty()) {
            for (Authorizable authorizable : authorizables) {
                ((Group)authorizable).addMember((Authorizable)newUser);
            }
        }
        return newUser;
    }

    public User userManagerCreateSystemUserViaReflection(UserManager userManager, String userID, String intermediatePath, AcInstallationHistoryPojo status) throws RepositoryException {
        String systemPrefix = "system/";
        if (intermediatePath != null && !intermediatePath.startsWith(systemPrefix)) {
            intermediatePath = systemPrefix + intermediatePath;
        }
        try {
            Method method = userManager.getClass().getMethod("createSystemUser", String.class, String.class);
            User user = (User)method.invoke((Object)userManager, userID, intermediatePath);
            return user;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            status.addError("Could not create system user " + userID + ". e:" + e);
            return null;
        }
    }

    private Set<Authorizable> validateAssignedGroups(UserManager userManager, String authorizablelID, String[] memberOf) throws RepositoryException, AuthorizableCreatorException {
        HashSet<Authorizable> authorizableSet = new HashSet<Authorizable>();
        for (String principal : memberOf) {
            String message;
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable != null) {
                if (authorizable.isGroup()) {
                    authorizableSet.add(authorizable);
                    continue;
                }
                message = "Failed to add authorizable " + authorizablelID + "to autorizable " + principal + "! Authorizable is not a group";
                LOG.warn(message);
                throw new AuthorizableCreatorException("Failed to add authorizable " + authorizablelID + "to autorizable " + principal + "! Authorizable is not a group");
            }
            if (this.principalMapFromConfig.keySet().contains(principal)) {
                LinkedHashSet<AuthorizableConfigBean> authorizableConfigSet = this.principalMapFromConfig.get(principal);
                Iterator it = authorizableConfigSet.iterator();
                AuthorizableConfigBean authorizableConfigBean = null;
                while (it.hasNext()) {
                    authorizableConfigBean = (AuthorizableConfigBean)it.next();
                }
                Group newGroup = userManager.createGroup((Principal)new PrincipalImpl(principal), authorizableConfigBean.getPath());
                authorizableSet.add((Authorizable)newGroup);
                this.authorizableInstallationHistory.addNewCreatedAuthorizabe(newGroup.getID());
                LOG.warn("Failed to add group: {} to authorizable: {}. Didn't find this authorizable under /home! Created group", (Object)authorizablelID, (Object)principal);
                continue;
            }
            message = "Failed to add group: " + authorizablelID + " as member to authorizable: " + principal + ". Neither found this authorizable (" + principal + ") in any of the configurations nor installed in the system!";
            LOG.error(message);
            throw new AuthorizableCreatorException(message);
        }
        return authorizableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performRollback(SlingRepository repository, AuthorizableInstallationHistory authorizableInstallationHistory, AcInstallationHistoryPojo history) throws RepositoryException {
        Session session = repository.loginAdministrative(null);
        ValueFactory vf = session.getValueFactory();
        try {
            JackrabbitSession js = (JackrabbitSession)session;
            UserManager userManager = js.getUserManager();
            Set<String> newCreatedAuthorizables = authorizableInstallationHistory.getNewCreatedAuthorizables();
            String message = "starting rollback of authorizables...";
            history.addWarning(message);
            if (!newCreatedAuthorizables.isEmpty()) {
                history.addWarning("performing Groups rollback!");
                for (String authorizableName : newCreatedAuthorizables) {
                    userManager.getAuthorizable(authorizableName).remove();
                    message = "removed authorizable " + authorizableName + " from the system!";
                    LOG.info(message);
                    history.addWarning(message);
                }
            }
            Set<AuthorizableBean> authorizableBeans = authorizableInstallationHistory.getAuthorizableBeans();
            for (AuthorizableBean snapshotBean : authorizableBeans) {
                Authorizable authorizable = userManager.getAuthorizable(snapshotBean.getName());
                if (authorizable == null) continue;
                history.addMessage("found changed authorizable:" + authorizable.getID());
                Iterator it = authorizable.memberOf();
                HashSet<String> memberOfGroups = new HashSet<String>();
                while (it.hasNext()) {
                    memberOfGroups.add(((Group)it.next()).getID());
                }
                if (snapshotBean.getAuthorizablesSnapshot().equals(memberOfGroups)) {
                    history.addMessage("No change found in memberOfGroups of authorizable: " + authorizable.getID());
                } else {
                    history.addMessage("changes found in memberOfGroups of authorizable: " + authorizable.getID());
                    Iterator it2 = authorizable.memberOf();
                    while (it2.hasNext()) {
                        Group group = (Group)it2.next();
                        group.removeMember(authorizable);
                        history.addWarning("removed authorizable: " + authorizable.getID() + " from members of group: " + group.getID());
                    }
                    for (String group : snapshotBean.getAuthorizablesSnapshot()) {
                        Authorizable groupFromSnapshot = userManager.getAuthorizable(group);
                        if (groupFromSnapshot == null) continue;
                        ((Group)groupFromSnapshot).addMember(authorizable);
                        history.addWarning("add authorizable: " + authorizable.getID() + " to members of group: " + groupFromSnapshot.getID() + " again");
                    }
                }
                String authorizableName = "";
                if (authorizable.hasProperty("profile/givenName")) {
                    authorizableName = authorizable.getProperty("profile/givenName")[0].getString();
                }
                if (snapshotBean.getName().equals(authorizableName)) {
                    history.addMessage("No change found in name of authorizable: " + authorizable.getID());
                    continue;
                }
                history.addMessage("change found in name of authorizable: " + authorizable.getID());
                authorizable.setProperty("profile/givenName", vf.createValue(snapshotBean.getName()));
                history.addMessage("changed name of authorizable from: " + authorizableName + " back to: " + snapshotBean.getName());
            }
        }
        finally {
            if (session != null) {
                session.save();
                session.logout();
            }
        }
    }
}

