/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.configreader.ConfigFilesRetriever;
import com.day.jcr.vault.fs.io.Archive;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(label="AC Config Files Retriever", description="Provides a map path->yamlConfigContent of relevant configs")
public class ConfigFilesRetrieverImpl
implements ConfigFilesRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFilesRetrieverImpl.class);
    @Reference
    private SlingSettingsService slingSettingsService;

    @Override
    public Map<String, String> getConfigFileContentFromNode(Node rootNode) throws Exception {
        if (rootNode == null) {
            throw new IllegalArgumentException("No configuration path configured! please check the configuration of AcService!");
        }
        Map<String, String> configurations = this.getConfigurations(new NodeInJcr(rootNode));
        return configurations;
    }

    @Override
    public Map<String, String> getConfigFileContentFromPackage(Archive archive) throws Exception {
        Archive.Entry rootEntry = archive.getJcrRoot();
        if (rootEntry == null) {
            throw new IllegalStateException("Invalid package: It does not contain a JCR root element");
        }
        Map<String, String> configurations = this.getConfigurations(new EntryInPackage(archive, "/", rootEntry));
        return configurations;
    }

    private Map<String, String> getConfigurations(PackageEntryOrNode configFileOrDir) throws Exception {
        HashMap<String, String> configs = new HashMap<String, String>();
        Set currentRunModes = this.slingSettingsService.getRunModes();
        for (PackageEntryOrNode entry : configFileOrDir.getChildren()) {
            if (entry.isDirectory()) {
                Map<String, String> resultsFromDir = this.getConfigurations(entry);
                configs.putAll(resultsFromDir);
                continue;
            }
            if (!ConfigFilesRetrieverImpl.isRelevantConfiguration(entry.getName(), configFileOrDir.getName(), currentRunModes)) continue;
            LOG.info("Reading YAML file {}", (Object)entry.getName());
            configs.put(entry.getPath(), entry.getContentAsString());
        }
        return configs;
    }

    static boolean isRelevantConfiguration(String entryName, String parentName, Set<String> currentRunModes) {
        if (!entryName.endsWith(".yaml") && !entryName.equals("config")) {
            return false;
        }
        Set<Set<String>> requiredRunModes = ConfigFilesRetrieverImpl.extractRunModesFromName(parentName);
        if (requiredRunModes.isEmpty()) {
            LOG.debug("Install file '{}', because parent name '{}' does not have a run mode specified.", (Object)entryName, (Object)parentName);
            return true;
        }
        for (Set<String> andRunModes : requiredRunModes) {
            boolean restrictionFulfilled = true;
            for (String andRunMode : andRunModes) {
                if (currentRunModes.contains(andRunMode)) continue;
                restrictionFulfilled = false;
                break;
            }
            if (!restrictionFulfilled) continue;
            LOG.debug("The following run modes are all set: {}, there proceed installing file '{}'", (Object)StringUtils.join(andRunModes, (String)","), (Object)entryName);
            return true;
        }
        LOG.debug("The run mode restrictions could not be fullfilled, therefore not installing file '{}'", (Object)entryName);
        return false;
    }

    static Set<Set<String>> extractRunModesFromName(String name) {
        String[] orSegments;
        HashSet<Set<String>> requiredRunModes = new HashSet<Set<String>>();
        int positionDot = name.indexOf(".");
        if (positionDot == -1) {
            return requiredRunModes;
        }
        String allSegments = name.substring(positionDot + 1);
        for (String orSegment : orSegments = allSegments.split(",")) {
            String[] andSegments;
            HashSet<String> andRunModes = new HashSet<String>();
            for (String andSegment : andSegments = orSegment.split("\\.")) {
                andRunModes.add(andSegment);
            }
            requiredRunModes.add(andRunModes);
        }
        return requiredRunModes;
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    private static class EntryInPackage
    implements PackageEntryOrNode {
        private final Archive.Entry entry;
        private final String path;
        private final Archive archive;

        public EntryInPackage(Archive archive, String parentPath, Archive.Entry entry) {
            this.archive = archive;
            this.entry = entry;
            this.path = parentPath + "/" + entry.getName();
        }

        @Override
        public String getName() throws Exception {
            return this.entry.getName();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<PackageEntryOrNode> getChildren() throws Exception {
            LinkedList<PackageEntryOrNode> children = new LinkedList<PackageEntryOrNode>();
            Collection entryChildren = this.entry.getChildren();
            for (Archive.Entry childEntry : entryChildren) {
                children.add(new EntryInPackage(this.archive, this.getPath(), childEntry));
            }
            return children;
        }

        @Override
        public boolean isDirectory() throws Exception {
            return this.entry.isDirectory();
        }

        @Override
        public String getContentAsString() throws Exception {
            LOG.info("Reading YAML file {}", (Object)this.getPath());
            InputStream input = this.archive.getInputSource(this.entry).getByteStream();
            if (input == null) {
                throw new IllegalStateException("Could not get input stream from entry " + this.getPath());
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)input, (Writer)writer, (String)"UTF-8");
            return writer.toString();
        }
    }

    private static class NodeInJcr
    implements PackageEntryOrNode {
        private final Node node;

        public NodeInJcr(Node node) {
            this.node = node;
        }

        @Override
        public String getName() throws Exception {
            return this.node.getName();
        }

        @Override
        public String getPath() throws Exception {
            return this.node.getPath();
        }

        @Override
        public List<PackageEntryOrNode> getChildren() throws Exception {
            LinkedList<PackageEntryOrNode> children = new LinkedList<PackageEntryOrNode>();
            NodeIterator childNodesIt = this.node.getNodes();
            while (childNodesIt.hasNext()) {
                children.add(new NodeInJcr((Node)childNodesIt.next()));
            }
            return children;
        }

        @Override
        public boolean isDirectory() throws Exception {
            return this.node.getPrimaryNodeType().isNodeType("{http://www.jcp.org/jcr/nt/1.0}folder");
        }

        @Override
        public String getContentAsString() throws Exception {
            try (InputStream configInputStream = JcrUtils.readFile((Node)this.node);){
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)configInputStream, (Writer)writer, (String)"UTF-8");
                String configData = writer.toString();
                if (StringUtils.isNotBlank((String)configData)) {
                    LOG.info("found configuration data of node: {}", (Object)this.node.getPath());
                    String string = configData;
                    return string;
                }
                throw new IllegalStateException("File " + this.node.getPath() + " is empty!");
            }
        }
    }

    private static interface PackageEntryOrNode {
        public String getName() throws Exception;

        public String getPath() throws Exception;

        public List<PackageEntryOrNode> getChildren() throws Exception;

        public boolean isDirectory() throws Exception;

        public String getContentAsString() throws Exception;
    }
}

