/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configreader.ConfigReader;
import biz.netcentric.cq.tools.actool.helper.AceBean;
import biz.netcentric.cq.tools.actool.helper.QueryHelper;
import biz.netcentric.cq.tools.actool.validators.AceBeanValidator;
import biz.netcentric.cq.tools.actool.validators.AuthorizableValidator;
import biz.netcentric.cq.tools.actool.validators.exceptions.AcConfigBeanValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(metatype=true, label="AC Yaml Config Reader", description="Service that installs groups & ACEs according to textual configuration files")
public class YamlConfigReader
implements ConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(YamlConfigReader.class);
    private static final String ACE_CONFIG_PROPERTY_GLOB = "repGlob";
    private static final String ACE_CONFIG_PROPERTY_PERMISSION = "permission";
    private static final String ACE_CONFIG_PROPERTY_PRIVILEGES = "privileges";
    private static final String ACE_CONFIG_PROPERTY_ACTIONS = "actions";
    private static final String ACE_CONFIG_PROPERTY_PATH = "path";
    private static final String GROUP_CONFIG_PROPERTY_MEMBER_OF = "isMemberOf";
    private static final String GROUP_CONFIG_PROPERTY_MEMBER_OF_LEGACY = "memberOf";
    private static final String GROUP_CONFIG_PROPERTY_MEMBERS = "members";
    private static final String GROUP_CONFIG_PROPERTY_PATH = "path";
    private static final String GROUP_CONFIG_PROPERTY_PASSWORD = "password";
    private static final String GROUP_CONFIG_PROPERTY_NAME = "name";
    private static final String USER_CONFIG_PROPERTY_IS_SYSTEM_USER = "isSystemUser";
    @Reference
    private SlingRepository repository;
    private final String ASSERTED_EXCEPTION = "assertedException";
    private final Pattern forLoopPattern = Pattern.compile("for (\\w+) in \\[([,/\\s\\w\\-]+)\\]", 2);

    @Override
    public Map<String, Set<AceBean>> getAceConfigurationBeans(Collection<?> aceConfigData, Set<String> groupsFromConfig, AceBeanValidator aceBeanValidator) throws RepositoryException, AcConfigBeanValidationException {
        List aclList = (List)this.getConfigSection("ace_config", aceConfigData);
        if (aclList == null) {
            LOG.error("ACL configuration not found in YAML configuration file");
            return null;
        }
        Map<String, Set<AceBean>> aceMapFromConfig = this.getPreservedOrderdAceMap(aclList, groupsFromConfig, aceBeanValidator);
        return aceMapFromConfig;
    }

    public Map<String, Set<AuthorizableConfigBean>> getGroupConfigurationBeans(Collection yamlList, AuthorizableValidator authorizableValidator) throws AcConfigBeanValidationException {
        List authorizableList = (List)this.getConfigSection("group_config", yamlList);
        if (authorizableList == null) {
            LOG.error("Group configuration not found in YAML configuration file");
            return null;
        }
        Map<String, Set<AuthorizableConfigBean>> principalsMap = this.getAuthorizablesMap(authorizableList, authorizableValidator, true);
        return principalsMap;
    }

    public Map<String, Set<AuthorizableConfigBean>> getUserConfigurationBeans(Collection yamlList, AuthorizableValidator authorizableValidator) throws AcConfigBeanValidationException {
        List authorizableList = (List)this.getConfigSection("user_config", yamlList);
        Map<String, Set<AuthorizableConfigBean>> principalsMap = this.getAuthorizablesMap(authorizableList, authorizableValidator, false);
        return principalsMap;
    }

    private Collection getConfigSection(String sectionName, Collection yamlList) {
        ArrayList yamList = new ArrayList(yamlList);
        for (LinkedHashMap currMap : yamList) {
            if (!sectionName.equals(currMap.keySet().iterator().next())) continue;
            return (List)currMap.get(sectionName);
        }
        return null;
    }

    private Map<String, Set<AuthorizableConfigBean>> getAuthorizablesMap(List<LinkedHashMap> yamlMap, AuthorizableValidator authorizableValidator, boolean isGroupSection) throws AcConfigBeanValidationException {
        HashSet<String> alreadyProcessedGroups = new HashSet<String>();
        LinkedHashMap<String, Set<AuthorizableConfigBean>> principalMap = new LinkedHashMap<String, Set<AuthorizableConfigBean>>();
        if (yamlMap == null) {
            return principalMap;
        }
        for (LinkedHashMap currentMap : yamlMap) {
            String currentPrincipal = (String)currentMap.keySet().iterator().next();
            Matcher matcher = this.forLoopPattern.matcher(currentPrincipal);
            if (matcher.find()) {
                LOG.info("Principal name {} matches FOR loop pattern. Unrolling {}", (Object)currentPrincipal, currentMap.get(currentPrincipal));
                List<AuthorizableConfigBean> groups = this.unrollGroupForLoop(currentPrincipal, (List)currentMap.get(currentPrincipal), new HashMap<String, String>(), isGroupSection);
                for (AuthorizableConfigBean group : groups) {
                    String principal = group.getPrincipalID();
                    if (!alreadyProcessedGroups.add(principal)) {
                        throw new IllegalArgumentException("There is more than one group definition for group: " + principal);
                    }
                    if (authorizableValidator != null) {
                        authorizableValidator.validate(group);
                    }
                    LinkedHashSet<AuthorizableConfigBean> tmpSet = new LinkedHashSet<AuthorizableConfigBean>();
                    tmpSet.add(group);
                    principalMap.put(principal, tmpSet);
                }
                continue;
            }
            if (!alreadyProcessedGroups.add(currentPrincipal)) {
                throw new IllegalArgumentException("There is more than one group definition for group: " + currentPrincipal);
            }
            LOG.info("start reading group configuration");
            LOG.info("Found principal: {} in config", (Object)currentPrincipal);
            LinkedHashSet tmpSet = new LinkedHashSet();
            principalMap.put(currentPrincipal, tmpSet);
            List currentPrincipalData = (List)currentMap.get(currentPrincipal);
            if (currentPrincipalData == null || currentPrincipalData.isEmpty()) continue;
            for (Map currentPrincipalDataMap : currentPrincipalData) {
                AuthorizableConfigBean tmpPrincipalConfigBean = new AuthorizableConfigBean();
                this.setupAuthorizableBean(tmpPrincipalConfigBean, currentPrincipalDataMap, currentPrincipal, isGroupSection);
                if (authorizableValidator != null) {
                    authorizableValidator.validate(tmpPrincipalConfigBean);
                }
                ((Set)principalMap.get(currentPrincipal)).add(tmpPrincipalConfigBean);
            }
        }
        return principalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<AceBean>> getPreservedOrderdAceMap(List<LinkedHashMap> aceYamlList, Set<String> groupsFromCurrentConfig, AceBeanValidator aceBeanValidator) throws RepositoryException, AcConfigBeanValidationException {
        LinkedHashMap<String, Set<AceBean>> aceMap = new LinkedHashMap<String, Set<AceBean>>();
        if (aceYamlList == null) {
            return aceMap;
        }
        Session session = null;
        try {
            if (this.repository != null) {
                session = this.repository.loginAdministrative(null);
            }
            for (Map map : aceYamlList) {
                String principalName = (String)map.keySet().iterator().next();
                Matcher matcher = this.forLoopPattern.matcher(principalName);
                if (matcher.find()) {
                    LOG.info("Principal name {} matches FOR loop pattern. Unrolling {}", (Object)principalName, map.get(principalName));
                    List<AceBean> aces = this.unrollAceForLoop(principalName, (List)map.get(principalName), new HashMap<String, String>());
                    for (AceBean ace : aces) {
                        if (aceMap.get(ace.getPrincipalName()) == null) {
                            LinkedHashSet tmpSet = new LinkedHashSet();
                            aceMap.put(ace.getPrincipalName(), tmpSet);
                        }
                        ((Set)aceMap.get(ace.getPrincipalName())).add(ace);
                    }
                    continue;
                }
                List aceDefinitions = (List)map.get(principalName);
                LOG.info("start reading ACE configuration of authorizable: {}", (Object)principalName);
                if (aceMap.get(principalName) == null) {
                    LinkedHashSet tmpSet = new LinkedHashSet();
                    aceMap.put(principalName, tmpSet);
                }
                if (aceDefinitions == null || aceDefinitions.isEmpty()) {
                    LOG.warn("no ACE definition(s) found for autorizable: {}", (Object)principalName);
                    continue;
                }
                if (aceBeanValidator != null) {
                    aceBeanValidator.setCurrentAuthorizableName(principalName);
                }
                for (Map currentAceDefinition : aceDefinitions) {
                    AceBean newAceBean = new AceBean();
                    this.setupAceBean(principalName, currentAceDefinition, newAceBean);
                    if (aceBeanValidator != null) {
                        aceBeanValidator.validate(newAceBean, session.getAccessControlManager());
                    }
                    if (newAceBean.getJcrPath() != null && newAceBean.getJcrPath().contains("*") && null != session) {
                        this.handleWildcards(session, aceMap, principalName, newAceBean);
                        continue;
                    }
                    ((Set)aceMap.get(principalName)).add(newAceBean);
                }
            }
            LinkedHashMap<String, Set<AceBean>> linkedHashMap = aceMap;
            return linkedHashMap;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected List<AceBean> unrollAceForLoop(String forSpec, List<Map<String, ?>> groups, Map<String, String> substitutions) {
        LinkedList<AceBean> beans = new LinkedList<AceBean>();
        Matcher matcher = this.forLoopPattern.matcher(forSpec);
        if (matcher.find()) {
            String[] values;
            String var = matcher.group(1);
            String in = matcher.group(2);
            for (String value : values = in.split(",\\s+")) {
                String regex = "\\$\\{" + var + "}";
                for (Map<String, ?> group : groups) {
                    String key = group.keySet().iterator().next();
                    Matcher matcher2 = this.forLoopPattern.matcher(key);
                    if (matcher2.find()) {
                        substitutions.put(regex, value);
                        LOG.info("Detected nested loop {}. Unrolling with {}", (Object)key, substitutions);
                        List<AceBean> nestedAces = this.unrollAceForLoop(key, (List)group.get(key), substitutions);
                        beans.addAll(nestedAces);
                        continue;
                    }
                    String principalName = key.replaceAll(regex, value.trim());
                    for (String sub : substitutions.keySet()) {
                        principalName = principalName.replaceAll(sub, substitutions.get(sub).trim());
                    }
                    List aces = (List)group.get(key);
                    for (Map ace : aces) {
                        HashMap<String, String> unrolledGroup = new HashMap<String, String>();
                        AceBean newAceBean = new AceBean();
                        for (String key2 : ace.keySet()) {
                            Object val = ace.get(key2);
                            if (val == null) {
                                unrolledGroup.put(key2, null);
                                continue;
                            }
                            if (!(val instanceof String)) continue;
                            String newVal = ((String)val).replaceAll(regex, value.trim());
                            for (String sub : substitutions.keySet()) {
                                newVal = newVal.replaceAll(sub, substitutions.get(sub).trim());
                            }
                            unrolledGroup.put(key2, newVal);
                        }
                        this.setupAceBean(principalName, unrolledGroup, newAceBean);
                        beans.add(newAceBean);
                    }
                }
            }
        } else {
            LOG.error("Incorrect for loop syntax: {}", (Object)forSpec);
        }
        return beans;
    }

    protected List<AuthorizableConfigBean> unrollGroupForLoop(String forSpec, List<Map<String, ?>> groups, Map<String, String> substitutions, boolean isGroupSection) {
        LinkedList<AuthorizableConfigBean> beans = new LinkedList<AuthorizableConfigBean>();
        Matcher matcher = this.forLoopPattern.matcher(forSpec);
        if (matcher.find()) {
            String[] values;
            String var = matcher.group(1);
            String in = matcher.group(2);
            for (String value : values = in.split(",\\s+")) {
                String regex = "\\$\\{" + var + "}";
                for (Map<String, ?> group : groups) {
                    String key = group.keySet().iterator().next();
                    Matcher matcher2 = this.forLoopPattern.matcher(key);
                    if (matcher2.find()) {
                        substitutions.put(regex, value);
                        LOG.info("Detected nested loop {}. Unrolling with {}", (Object)key, substitutions);
                        List<AuthorizableConfigBean> nestedGroups = this.unrollGroupForLoop(key, (List)group.get(key), substitutions, isGroupSection);
                        beans.addAll(nestedGroups);
                        continue;
                    }
                    String principalName = key.replaceAll(regex, value.trim());
                    for (String sub : substitutions.keySet()) {
                        principalName = principalName.replaceAll(sub, substitutions.get(sub).trim());
                    }
                    List groupMaps = (List)group.get(key);
                    for (Map props : groupMaps) {
                        HashMap<String, String> unrolledGroup = new HashMap<String, String>();
                        AuthorizableConfigBean newGroupBean = new AuthorizableConfigBean();
                        for (String key2 : props.keySet()) {
                            Object val = props.get(key2);
                            if (val == null) {
                                unrolledGroup.put(key2, null);
                                continue;
                            }
                            if (!(val instanceof String)) continue;
                            String newVal = ((String)val).replaceAll(regex, value.trim());
                            for (String sub : substitutions.keySet()) {
                                newVal = newVal.replaceAll(sub, substitutions.get(sub).trim());
                            }
                            unrolledGroup.put(key2, newVal);
                        }
                        this.setupAuthorizableBean(newGroupBean, unrolledGroup, principalName, isGroupSection);
                        beans.add(newGroupBean);
                    }
                }
            }
        } else {
            LOG.error("Incorrect for loop syntax: {}", (Object)forSpec);
        }
        return beans;
    }

    private void handleWildcards(Session session, Map<String, Set<AceBean>> aceMap, String principal, AceBean tmpAclBean) throws InvalidQueryException, RepositoryException {
        String query = "/jcr:root" + tmpAclBean.getJcrPath();
        Set<Node> result = QueryHelper.getNodes(session, query);
        if (result.isEmpty()) {
            return;
        }
        for (Node node : result) {
            if (node.getPath().contains("/rep:policy")) continue;
            AceBean replacementBean = new AceBean();
            replacementBean.setJcrPath(node.getPath());
            replacementBean.setActions(tmpAclBean.getActions());
            replacementBean.setPermission(tmpAclBean.getPermission());
            replacementBean.setPrincipal(tmpAclBean.getPrincipalName());
            replacementBean.setPrivilegesString(tmpAclBean.getPrivilegesString());
            if (!aceMap.get(principal).add(replacementBean)) {
                LOG.warn("wildcard replacement: replacing bean: " + tmpAclBean + ", with bean " + replacementBean + " failed!");
                continue;
            }
            LOG.info("wildcard replacement: replaced bean: " + tmpAclBean + ", with bean " + replacementBean);
        }
    }

    private void setupAceBean(String principal, Map<String, ?> currentAceDefinition, AceBean tmpAclBean) {
        tmpAclBean.setPrincipal(principal);
        tmpAclBean.setJcrPath(this.getMapValueAsString(currentAceDefinition, "path"));
        tmpAclBean.setActionsStringFromConfig(this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_PROPERTY_ACTIONS));
        tmpAclBean.setPrivilegesString(this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_PROPERTY_PRIVILEGES));
        tmpAclBean.setPermission(this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_PROPERTY_PERMISSION));
        tmpAclBean.setRepGlob((String)currentAceDefinition.get(ACE_CONFIG_PROPERTY_GLOB));
        tmpAclBean.setAssertedExceptionString(this.getMapValueAsString(currentAceDefinition, "assertedException"));
        tmpAclBean.setActions(this.parseActionsString(this.getMapValueAsString(currentAceDefinition, ACE_CONFIG_PROPERTY_ACTIONS)));
    }

    private String[] parseActionsString(String actionsStringFromConfig) {
        String[] empty = new String[]{};
        return StringUtils.isNotBlank((String)actionsStringFromConfig) ? actionsStringFromConfig.split(",") : empty;
    }

    private void setupAuthorizableBean(AuthorizableConfigBean authorizableConfigBean, Map<String, String> currentPrincipalDataMap, String authorizableId, boolean isGroupSection) {
        authorizableConfigBean.setPrincipalID(authorizableId);
        authorizableConfigBean.setAuthorizableName(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_NAME));
        authorizableConfigBean.setMemberOfString(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_MEMBER_OF));
        if (!StringUtils.isEmpty((String)this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_MEMBER_OF_LEGACY))) {
            authorizableConfigBean.setMemberOfString(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_MEMBER_OF_LEGACY));
        }
        authorizableConfigBean.setMembersString(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_MEMBERS));
        authorizableConfigBean.setPath(this.getMapValueAsString(currentPrincipalDataMap, "path"));
        authorizableConfigBean.setIsGroup(isGroupSection);
        authorizableConfigBean.setIsSystemUser(Boolean.valueOf(this.getMapValueAsString(currentPrincipalDataMap, USER_CONFIG_PROPERTY_IS_SYSTEM_USER)));
        authorizableConfigBean.setPassword(this.getMapValueAsString(currentPrincipalDataMap, GROUP_CONFIG_PROPERTY_PASSWORD));
        authorizableConfigBean.setAssertedExceptionString(this.getMapValueAsString(currentPrincipalDataMap, "assertedException"));
    }

    private String getMapValueAsString(Map<String, ?> currentAceDefinition, String propertyName) {
        if (currentAceDefinition.get(propertyName) != null) {
            return currentAceDefinition.get(propertyName).toString();
        }
        return "";
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

