/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configreader;

import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configreader.ConfigReader;
import biz.netcentric.cq.tools.actool.configreader.ConfigurationMerger;
import biz.netcentric.cq.tools.actool.helper.AceBean;
import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import biz.netcentric.cq.tools.actool.validators.YamlConfigurationsValidator;
import biz.netcentric.cq.tools.actool.validators.exceptions.AcConfigBeanValidationException;
import biz.netcentric.cq.tools.actool.validators.impl.AceBeanValidatorImpl;
import biz.netcentric.cq.tools.actool.validators.impl.AuthorizableMemberGroupsValidator;
import biz.netcentric.cq.tools.actool.validators.impl.AuthorizableValidatorImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigurationMerger
implements ConfigurationMerger {
    private static final Logger LOG = LoggerFactory.getLogger(YamlConfigurationMerger.class);

    @Override
    public List getMergedConfigurations(Map<String, String> newestConfigurations, AcInstallationHistoryPojo history, ConfigReader configReader) throws RepositoryException, AcConfigBeanValidationException {
        ArrayList c = new ArrayList();
        LinkedHashMap<String, Set<AuthorizableConfigBean>> mergedAuthorizablesMapfromConfig = new LinkedHashMap<String, Set<AuthorizableConfigBean>>();
        LinkedHashMap<String, Set<AceBean>> mergedAceMapFromConfig = new LinkedHashMap<String, Set<AceBean>>();
        HashSet<String> authorizableIdsFromAllConfigs = new HashSet<String>();
        YamlConfigurationsValidator configurationsValidator = new YamlConfigurationsValidator();
        for (Map.Entry<String, String> entry : newestConfigurations.entrySet()) {
            AceBeanValidatorImpl aceBeanValidator;
            Map<String, Set<AceBean>> aceMapFromConfig;
            Map<String, Set<AuthorizableConfigBean>> userAuthorizablesMapFromConfig;
            String message = "Start merging configuration data from: " + entry.getKey();
            configurationsValidator.validateMandatorySectionIdentifiersExistence(entry.getValue(), entry.getKey());
            history.addMessage(message);
            Yaml yaml = new Yaml();
            List yamlList = (List)yaml.load(entry.getValue());
            LinkedHashSet<String> sectionIdentifiers = new LinkedHashSet<String>();
            for (int i = 0; i < yamlList.size(); ++i) {
                sectionIdentifiers.addAll(((LinkedHashMap)yamlList.get(i)).keySet());
            }
            configurationsValidator.validateSectionIdentifiers(sectionIdentifiers, entry.getKey());
            configurationsValidator.validateSectionContentExistence(entry.getKey(), yamlList);
            AuthorizableValidatorImpl authorizableValidator = new AuthorizableValidatorImpl();
            Map<String, Set<AuthorizableConfigBean>> groupAuthorizablesMapFromConfig = configReader.getGroupConfigurationBeans(yamlList, authorizableValidator);
            if (groupAuthorizablesMapFromConfig != null) {
                mergedAuthorizablesMapfromConfig.putAll(groupAuthorizablesMapFromConfig);
            }
            if ((userAuthorizablesMapFromConfig = configReader.getUserConfigurationBeans(yamlList, authorizableValidator)) != null) {
                mergedAuthorizablesMapfromConfig.putAll(userAuthorizablesMapFromConfig);
            }
            HashSet<String> authorizableIdsFromCurrentConfig = new HashSet<String>();
            if (groupAuthorizablesMapFromConfig != null) {
                authorizableIdsFromCurrentConfig.addAll(groupAuthorizablesMapFromConfig.keySet());
            }
            if (userAuthorizablesMapFromConfig != null) {
                authorizableIdsFromCurrentConfig.addAll(userAuthorizablesMapFromConfig.keySet());
            }
            if (authorizableIdsFromCurrentConfig != null) {
                configurationsValidator.validateDuplicateAuthorizables(authorizableIdsFromAllConfigs, authorizableIdsFromCurrentConfig, entry.getKey());
                authorizableIdsFromAllConfigs.addAll(authorizableIdsFromCurrentConfig);
            }
            if ((aceMapFromConfig = configReader.getAceConfigurationBeans(yamlList, authorizableIdsFromAllConfigs, aceBeanValidator = new AceBeanValidatorImpl(authorizableIdsFromAllConfigs))) == null) continue;
            mergedAceMapFromConfig.putAll(aceMapFromConfig);
        }
        AuthorizableMemberGroupsValidator membersValidator = new AuthorizableMemberGroupsValidator();
        membersValidator.validate(mergedAuthorizablesMapfromConfig);
        c.add(mergedAuthorizablesMapfromConfig);
        c.add(mergedAceMapFromConfig);
        return c;
    }
}

