/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.configuploadlistener.impl;

import biz.netcentric.cq.tools.actool.aceservice.AceService;
import biz.netcentric.cq.tools.actool.configuploadlistener.UploadListenerService;
import biz.netcentric.cq.tools.actool.installationhistory.AcHistoryService;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="AC Configuration Upload Listener Service", immediate=true, description="Listens for ACL configuration uploads and triggers ACL Service.")
@Properties(value={@Property(label="Service status", name="AceUploadListener.setStatusService", options={@PropertyOption(name="disabled", value="disabled"), @PropertyOption(name="enabled", value="enabled")})})
@Service(value={UploadListenerService.class})
public class UploadListenerServiceImpl
implements UploadListenerService,
EventListener {
    static final String ACE_UPLOAD_LISTENER_SET_STATUS_SERVICE = "AceUploadListener.setStatusService";
    private String configurationPath;
    private boolean enabled;
    private static final Logger LOG = LoggerFactory.getLogger(UploadListenerServiceImpl.class);
    private Session adminSession;
    @Reference
    SlingRepository repository;
    @Reference
    AceService aceService;
    @Reference
    AcHistoryService acHistoryService;

    public void onEvent(EventIterator events) {
        if (this.enabled) {
            int changes = 0;
            try {
                while (events.hasNext()) {
                    Event event = events.nextEvent();
                    Node node = null;
                    switch (event.getType()) {
                        case 1: {
                            node = this.adminSession.getNode(event.getPath());
                            break;
                        }
                        case 16: {
                            if (!event.getPath().endsWith("jcr:content/jcr:data")) break;
                            node = this.adminSession.getNode(event.getPath().replace("/jcr:content/jcr:data", ""));
                            break;
                        }
                        default: {
                            LOG.warn("Unexpected event: {}", (Object)event);
                        }
                    }
                    if (node != null && node.hasProperty("jcr:content/jcr:data")) {
                        LOG.info("Detected new or changed node at {}.", (Object)node.getPath());
                        ++changes;
                        continue;
                    }
                    LOG.debug("Node {} associated with event does not have configuration data.", (Object)event.getPath());
                }
            }
            catch (RepositoryException e) {
                LOG.error("Error while handling events.", (Throwable)e);
            }
            if (changes > 0) {
                LOG.info("There are {} new or changed files. Triggering reload of configuration.", (Object)changes);
                this.aceService.execute();
            }
        }
    }

    @Activate
    public void activate(Map properties) throws Exception {
        this.configurationPath = this.aceService.getConfigurationRootPath();
        String statusService = PropertiesUtil.toString(properties.get(ACE_UPLOAD_LISTENER_SET_STATUS_SERVICE), (String)"");
        this.enabled = StringUtils.equals((String)statusService, (String)"enabled");
        this.setEventListener();
    }

    private void setEventListener() throws Exception {
        if (StringUtils.isNotBlank((String)this.configurationPath)) {
            try {
                this.adminSession = this.repository.loginAdministrative(null);
                this.adminSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 17, this.configurationPath, true, null, null, false);
                LOG.info("added EventListener for ACE configuration root path: {}", (Object)this.configurationPath);
            }
            catch (RepositoryException e) {
                LOG.error("RepositoryException in UploadListenerService:{}", (Throwable)e);
            }
        } else {
            LOG.warn("no root ACE configuration path configured in AceService");
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.adminSession != null) {
            this.adminSession.logout();
        }
    }

    public void setPath(String path) {
        this.configurationPath = path;
        try {
            this.setEventListener();
        }
        catch (Exception e) {
            LOG.error("Exception in UploadListenerService: {}", (Throwable)e);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindAceService(AceService aceService) {
        this.aceService = aceService;
    }

    protected void unbindAceService(AceService aceService) {
        if (this.aceService == aceService) {
            this.aceService = null;
        }
    }

    protected void bindAcHistoryService(AcHistoryService acHistoryService) {
        this.acHistoryService = acHistoryService;
    }

    protected void unbindAcHistoryService(AcHistoryService acHistoryService) {
        if (this.acHistoryService == acHistoryService) {
            this.acHistoryService = null;
        }
    }
}

