/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.dumpservice;

import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElementVisitor;
import biz.netcentric.cq.tools.actool.dumpservice.CommentingDumpElement;
import biz.netcentric.cq.tools.actool.dumpservice.StructuralDumpElement;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.AceBean;

public class AcDumpElementYamlVisitor
implements AcDumpElementVisitor {
    private static final int PRINCIPAL_BASED_SORTING = 1;
    private static final int PATH_BASED_SORTING = 2;
    public static final int DUMP_INDENTATION_KEY = 4;
    public static final int DUMP_INDENTATION_FIRST_PROPERTY = 7;
    public static final int DUMP_INDENTATION_PROPERTY = 9;
    public static final String YAML_STRUCTURAL_ELEMENT_PREFIX = "- ";
    private final StringBuilder sb;
    private final int mapOrder;

    public AcDumpElementYamlVisitor(int mapOrder, StringBuilder sb) {
        this.mapOrder = mapOrder;
        this.sb = sb;
    }

    @Override
    public void visit(AuthorizableConfigBean authorizableConfigBean) {
        this.sb.append(AcHelper.getBlankString(4)).append(YAML_STRUCTURAL_ELEMENT_PREFIX + authorizableConfigBean.getPrincipalID() + ":").append("\n");
        this.sb.append("\n");
        this.sb.append(AcHelper.getBlankString(7)).append("- name: ").append("\n");
        this.sb.append(AcHelper.getBlankString(9)).append("memberOf: " + authorizableConfigBean.getMemberOfString()).append("\n");
        this.sb.append(AcHelper.getBlankString(9)).append("path: " + authorizableConfigBean.getPath()).append("\n");
        this.sb.append(AcHelper.getBlankString(9)).append("isGroup: '" + authorizableConfigBean.isGroup() + "'").append("\n");
        this.sb.append("\n");
    }

    @Override
    public void visit(AceBean aceBean) {
        if (this.mapOrder == 2) {
            this.sb.append(AcHelper.getBlankString(7)).append("- principal: " + aceBean.getPrincipalName()).append("\n");
        } else if (this.mapOrder == 1) {
            this.sb.append(AcHelper.getBlankString(7)).append("- path: " + aceBean.getJcrPath()).append("\n");
        }
        this.sb.append(AcHelper.getBlankString(9)).append("permission: " + aceBean.getPermission()).append("\n");
        this.sb.append(AcHelper.getBlankString(9)).append("actions: " + aceBean.getActionsString()).append("\n");
        this.sb.append(AcHelper.getBlankString(9)).append("privileges: " + aceBean.getPrivilegesString()).append("\n");
        this.sb.append(AcHelper.getBlankString(9)).append("repGlob: ");
        if (aceBean.getRepGlob() != null) {
            this.sb.append("'" + aceBean.getRepGlob() + "'");
        }
        this.sb.append("\n");
        this.sb.append("\n");
    }

    @Override
    public void visit(CommentingDumpElement commentingDumpElement) {
        this.sb.append("# " + commentingDumpElement.getString());
        this.sb.append("\n");
        this.sb.append("\n");
    }

    @Override
    public void visit(StructuralDumpElement structuralDumpElement) {
        this.sb.append("\n");
        this.sb.append(AcHelper.getBlankString(structuralDumpElement.getLevel() * 2) + YAML_STRUCTURAL_ELEMENT_PREFIX + structuralDumpElement.getString() + ":");
        this.sb.append("\n");
        this.sb.append("\n");
    }
}

