/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.dumpservice;

import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElement;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElementVisitor;
import biz.netcentric.cq.tools.actool.dumpservice.AceDumpData;
import biz.netcentric.cq.tools.actool.dumpservice.DumpComment;
import biz.netcentric.cq.tools.actool.dumpservice.DumpSectionElement;
import biz.netcentric.cq.tools.actool.dumpservice.Dumpservice;
import biz.netcentric.cq.tools.actool.dumpservice.MapKey;
import biz.netcentric.cq.tools.actool.helper.AceBean;
import java.util.Map;
import java.util.Set;

public class CompleteAcDump
implements AcDumpElement {
    private AceDumpData aceDumpData;
    private Set<AuthorizableConfigBean> groupSet;
    private Set<AuthorizableConfigBean> userSet;
    private String dumpComment;
    private Dumpservice dumpservice;

    public CompleteAcDump(AceDumpData aceDumpData, Set<AuthorizableConfigBean> groupSet, Set<AuthorizableConfigBean> userSet, int mapOrder, String dumpComment, Dumpservice dumpservice) {
        this.aceDumpData = aceDumpData;
        this.groupSet = groupSet;
        this.userSet = userSet;
        this.dumpComment = dumpComment;
        this.dumpservice = dumpservice;
    }

    @Override
    public void accept(AcDumpElementVisitor acDumpElementVisitor) {
        Map<String, Set<AceBean>> aceMap = this.aceDumpData.getAceDump();
        this.aceDumpData.getLegacyAceDump();
        acDumpElementVisitor.visit(new DumpComment(this.dumpComment));
        acDumpElementVisitor.visit(new DumpSectionElement("group_config"));
        this.renderAuthorizableBeans(acDumpElementVisitor, this.groupSet);
        if (this.dumpservice.isIncludeUsers()) {
            acDumpElementVisitor.visit(new DumpSectionElement("user_config"));
            this.renderAuthorizableBeans(acDumpElementVisitor, this.userSet);
        }
        acDumpElementVisitor.visit(new DumpSectionElement("ace_config"));
        this.renderAceBeans(acDumpElementVisitor, aceMap);
    }

    private void renderAuthorizableBeans(AcDumpElementVisitor acDumpElementVisitor, Set<AuthorizableConfigBean> authorizableBeans) {
        for (AuthorizableConfigBean authorizableConfigBean : authorizableBeans) {
            authorizableConfigBean.accept(acDumpElementVisitor);
        }
    }

    private void renderAceBeans(AcDumpElementVisitor acDumpElementVisitor, Map<String, Set<AceBean>> aceMap) {
        for (Map.Entry<String, Set<AceBean>> entry : aceMap.entrySet()) {
            Set<AceBean> aceBeanSet = entry.getValue();
            String mapKey = entry.getKey();
            acDumpElementVisitor.visit(new MapKey(mapKey));
            for (AceBean aceBean : aceBeanSet) {
                aceBean.accept(acDumpElementVisitor);
            }
        }
    }
}

