/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.dumpservice.impl;

import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.comparators.AcePathComparator;
import biz.netcentric.cq.tools.actool.comparators.AcePermissionComparator;
import biz.netcentric.cq.tools.actool.comparators.AuthorizableBeanIDComparator;
import biz.netcentric.cq.tools.actool.comparators.JcrCreatedComparator;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElementYamlVisitor;
import biz.netcentric.cq.tools.actool.dumpservice.AceDumpData;
import biz.netcentric.cq.tools.actool.dumpservice.CompleteAcDump;
import biz.netcentric.cq.tools.actool.dumpservice.Dumpservice;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.helper.AceBean;
import biz.netcentric.cq.tools.actool.helper.AceWrapper;
import biz.netcentric.cq.tools.actool.helper.AclBean;
import biz.netcentric.cq.tools.actool.helper.QueryHelper;
import biz.netcentric.cq.tools.actool.installationhistory.impl.HistoryUtils;
import com.day.cq.commons.Externalizer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.version.VersionException;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(metatype=true, label="AC Dump Service", description="Service that creates dumps of the current AC configurations (groups&ACEs)")
@Properties(value={@Property(label="Number of dumps to save", name="DumpService.nrOfSavedDumps", value={"5"}, description="number of last dumps which get saved in CRX under /var/statistics/achistory"), @Property(label="Include user ACEs in dumps", name="DumpService.includeUsers", boolValue={false}, description="if selected, also user based ACEs (and their respective users) get added to dumps"), @Property(label="filtered dump", name="DumpService.isFiltered", boolValue={true}, description="if selected, ACEs of cq actions modify, create and delete containing a repGlob get also added to dumps in section: user_config"), @Property(label="AC query exclude paths", name="DumpService.queryExcludePaths", value={"/home", "/jcr:system", "/tmp"}, description="direct children of jcr:root which get excluded from all dumps (also from internal dumps)")})
public class DumpserviceImpl
implements Dumpservice {
    private static final Logger LOG = LoggerFactory.getLogger(DumpserviceImpl.class);
    private static final String DUMP_FILE_EXTENSION = ".yaml";
    private static final String DUMP_NODE_PREFIX = "dump_";
    public static final int PRINCIPAL_BASED_SORTING = 1;
    public static final int PATH_BASED_SORTING = 2;
    public static final int DENY_ALLOW_ACL_SORTING = 1;
    public static final int NO_ACL_SORTING = 2;
    protected static final int NR_OF_DUMPS_TO_SAVE_DEFAULT = 5;
    static final String DUMP_SERVICE_EXCLUDE_PATHS_PATH = "DumpService.queryExcludePaths";
    static final String DUMP_SERVICE_NR_OF_SAVED_DUMPS = "DumpService.nrOfSavedDumps";
    static final String DUMP_INCLUDE_USERS = "DumpService.includeUsers";
    static final String DUMP_IS_FILTERED = "DumpService.isFiltered";
    static final String DUMP_IS_SHOW_LEGACY_ACES = "DumpService.isShowLegacyAces";
    private String[] queryExcludePaths;
    private int nrOfSavedDumps;
    private boolean includeUsersInDumps = false;
    private boolean isFilteredDump = false;
    private boolean isShowLegacyAces = false;
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private String bundleDescription;

    @Activate
    public void activate(Map properties, ComponentContext context) throws Exception {
        this.updateProperties(properties, context);
    }

    @Modified
    public void modified(Map properties, ComponentContext context) throws Exception {
        this.updateProperties(properties, context);
    }

    private void updateProperties(Map properties, ComponentContext context) {
        this.queryExcludePaths = PropertiesUtil.toStringArray(properties.get(DUMP_SERVICE_EXCLUDE_PATHS_PATH), null);
        this.nrOfSavedDumps = PropertiesUtil.toInteger(properties.get(DUMP_SERVICE_NR_OF_SAVED_DUMPS), (int)5);
        this.includeUsersInDumps = PropertiesUtil.toBoolean(properties.get(DUMP_INCLUDE_USERS), (boolean)false);
        this.isFilteredDump = PropertiesUtil.toBoolean(properties.get(DUMP_IS_FILTERED), (boolean)true);
        this.isShowLegacyAces = PropertiesUtil.toBoolean(properties.get(DUMP_IS_SHOW_LEGACY_ACES), (boolean)true);
        this.bundleDescription = (String)context.getBundleContext().getBundle().getHeaders().get("Bundle-Description");
    }

    public String getBundleDescription() {
        return this.bundleDescription;
    }

    @Override
    public boolean isIncludeUsers() {
        return this.includeUsersInDumps;
    }

    @Override
    public String[] getQueryExcludePaths() {
        return this.queryExcludePaths;
    }

    @Override
    public void returnAceDumpAsFile(SlingHttpServletRequest request, SlingHttpServletResponse response, Session session, int mapOrder, int aceOrder) {
        try {
            Map<String, Set<AceBean>> aclDumpMap = AcHelper.createAceMap(request, mapOrder, aceOrder, this.queryExcludePaths, this);
            this.returnAceDumpAsFile(response, aclDumpMap, mapOrder);
        }
        catch (ValueFormatException e) {
            LOG.error("ValueFormatException in AceServiceImpl: {}", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.error("IllegalStateException in AceServiceImpl: {}", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IOException in AceServiceImpl: {}", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException in AceServiceImpl: {}", (Throwable)e);
        }
    }

    @Override
    public String getCompletePathBasedDumpsAsString() {
        String dump = this.getCompleteDump(2, 2);
        this.persistDump(dump);
        return dump;
    }

    @Override
    public String getCompletePrincipalBasedDumpsAsString() {
        String dump = this.getCompleteDump(1, 1);
        this.persistDump(dump);
        return dump;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistDump(String dump) {
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            Node rootNode = HistoryUtils.getAcHistoryRootNode(session);
            this.createTransientDumpNode(dump, rootNode);
            session.save();
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: {}", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void createTransientDumpNode(String dump, Node rootNode) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, ValueFormatException {
        NodeIterator nodeIt = rootNode.getNodes();
        TreeSet<Node> dumpNodes = new TreeSet<Node>(new JcrCreatedComparator());
        Node previousDumpNode = null;
        while (nodeIt.hasNext()) {
            Node currNode = nodeIt.nextNode();
            if (!currNode.getName().startsWith(DUMP_NODE_PREFIX)) continue;
            dumpNodes.add(currNode);
        }
        if (!dumpNodes.isEmpty()) {
            previousDumpNode = dumpNodes.first();
        }
        if (dumpNodes.size() > this.nrOfSavedDumps - 1) {
            Node oldestDumpNode = dumpNodes.last();
            oldestDumpNode.remove();
        }
        Node dumpNode = this.getNewDumpNode(dump, rootNode);
        if (previousDumpNode != null) {
            rootNode.orderBefore(dumpNode.getName(), previousDumpNode.getName());
        }
    }

    private Node getNewDumpNode(String dump, Node rootNode) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, ValueFormatException {
        long timestamp = System.currentTimeMillis();
        Node dumpNode = rootNode.addNode(DUMP_NODE_PREFIX + timestamp + DUMP_FILE_EXTENSION, "nt:file");
        Node dumpJcrContenNodet = dumpNode.addNode("jcr:content", "nt:resource");
        dumpJcrContenNodet.setProperty("jcr:mimeType", "text/plain");
        dumpJcrContenNodet.setProperty("jcr:encoding", "utf-8");
        dumpJcrContenNodet.setProperty("jcr:data", dump);
        return dumpNode;
    }

    private Node getNewestDumpNode(Set<Node> dumpNodes) {
        Iterator<Node> it = dumpNodes.iterator();
        Node node = null;
        while (it.hasNext()) {
            node = it.next();
        }
        return node;
    }

    @Override
    public void returnCompleteDumpAsFile(SlingHttpServletResponse response, Map<String, Set<AceBean>> aceMap, Set<AuthorizableConfigBean> authorizableSet, Session session, int mapOrder, int aceOrder) throws IOException {
        this.returnConfigurationDumpAsFile(response, aceMap, authorizableSet, mapOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCompleteDump(int aclMapKeyOrder, int mapOrder) {
        Session session = null;
        ResourceResolver resourceResolver = null;
        try {
            session = this.repository.loginAdministrative(null);
            AceDumpData aceDumpData = this.createAclDumpMap(session, aclMapKeyOrder, AcHelper.ACE_ORDER_ALPHABETICAL, this.queryExcludePaths);
            Map<String, Set<AceBean>> aclDumpMap = aceDumpData.getAceDump();
            Set<AuthorizableConfigBean> groupBeans = this.getGroupBeans(session);
            Set<User> usersFromACEs = this.getUsersFromAces(mapOrder, session, aclDumpMap);
            Set<AuthorizableConfigBean> userBeans = this.getUserBeans(usersFromACEs);
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Externalizer externalizer = (Externalizer)resourceResolver.adaptTo(Externalizer.class);
            String serverUrl = externalizer.authorLink(resourceResolver, "");
            String string = this.getConfigurationDumpAsString(aceDumpData, groupBeans, userBeans, mapOrder, serverUrl);
            return string;
        }
        catch (ValueFormatException e) {
            LOG.error("ValueFormatException in AceServiceImpl: {}", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.error("IllegalStateException in AceServiceImpl: {}", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IOException in AceServiceImpl: {}", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException in AceServiceImpl: {}", (Throwable)e);
        }
        catch (LoginException e) {
            LOG.error("LoginException in AceServiceImpl: {}", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        return null;
    }

    private Set<User> getUsersFromAces(int mapOrder, Session session, Map<String, Set<AceBean>> aclDumpMap) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<User> usersFromACEs;
        block4: {
            UserManager um;
            block3: {
                usersFromACEs = new HashSet<User>();
                um = ((JackrabbitSession)session).getUserManager();
                if (mapOrder != 1) break block3;
                Set<Object> userIds = new HashSet();
                userIds = aclDumpMap.keySet();
                for (String string : userIds) {
                    Authorizable authorizable = um.getAuthorizable(string);
                    if (authorizable.isGroup()) continue;
                    User user = (User)authorizable;
                    usersFromACEs.add(user);
                }
                break block4;
            }
            if (mapOrder != 2) break block4;
            for (Map.Entry<String, Set<AceBean>> entry : aclDumpMap.entrySet()) {
                Set<AceBean> set = entry.getValue();
                for (AceBean aceBean : set) {
                    String principalId = aceBean.getPrincipalName();
                    Authorizable authorizable = um.getAuthorizable(principalId);
                    if (authorizable.isGroup()) continue;
                    User user = (User)authorizable;
                    usersFromACEs.add(user);
                }
            }
        }
        return usersFromACEs;
    }

    @Override
    public void returnAceDump(PrintWriter out, Map<String, Set<AceBean>> aceMap, int mapOrdering, int aceOrdering) {
        if (mapOrdering == 2) {
            LOG.debug("path based ordering required therefor getting path based ACE map");
            int aclOrder = 2;
            if (aceOrdering == 1) {
                aclOrder = 1;
            }
            aceMap = AcHelper.getPathBasedAceMap(aceMap, aclOrder);
        }
        Set<String> keySet = aceMap.keySet();
        for (String principal : keySet) {
            Set<AceBean> aceBeanSet = aceMap.get(principal);
            out.println("- " + principal + ":");
            for (AceBean bean : aceBeanSet) {
                out.println();
                out.println("   - path: " + bean.getJcrPath());
                out.println("     permission: " + bean.getPermission());
                out.println("     actions: " + bean.getActionsString());
                out.println("     privileges: " + bean.getPrivilegesString());
                out.print("     repGlob: ");
                if (!bean.getRepGlob().isEmpty()) {
                    out.println("'" + bean.getRepGlob() + "'");
                    continue;
                }
                out.println();
            }
            out.println();
        }
        out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnAceDumpAsFile(SlingHttpServletResponse response, Map<String, Set<AceBean>> aceMap, int mapOrder) throws IOException {
        String mimetype = "application/octet-stream";
        response.setContentType(mimetype);
        try (ServletOutputStream outStream = null;){
            try {
                outStream = response.getOutputStream();
            }
            catch (IOException e) {
                LOG.error("Exception in AclDumpUtils: {}", (Throwable)e);
            }
            String fileName = "ACE_Dump_" + new Date(System.currentTimeMillis());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            try {
                this.writeAclConfigToStream(aceMap, mapOrder, outStream);
            }
            catch (IOException e) {
                LOG.error("Exception in AclDumpUtils: {}", (Throwable)e);
            }
        }
    }

    @Override
    public String getConfigurationDumpAsString(AceDumpData aceDumpData, Set<AuthorizableConfigBean> groupSet, Set<AuthorizableConfigBean> userSet, int mapOrder, String serverUrl) throws IOException {
        StringBuilder sb = new StringBuilder(20000);
        String dumpComment = this.bundleDescription + "\n# Dump created: " + new Date() + " on: " + serverUrl;
        new CompleteAcDump(aceDumpData, groupSet, userSet, mapOrder, dumpComment, this).accept(new AcDumpElementYamlVisitor(mapOrder, sb));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConfigurationDumpAsFile(SlingHttpServletResponse response, Map<String, Set<AceBean>> aceMap, Set<AuthorizableConfigBean> authorizableSet, int mapOrder) throws IOException {
        String mimetype = "application/octet-stream";
        response.setContentType(mimetype);
        try (ServletOutputStream outStream = null;){
            try {
                outStream = response.getOutputStream();
            }
            catch (IOException e) {
                LOG.error("Exception in AclDumpUtils: {}", (Throwable)e);
            }
            String fileName = "ACL_Configuration_Dump_" + new Date(System.currentTimeMillis());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            try {
                this.writeAuthorizableConfigToStream(authorizableSet, outStream);
                outStream.println();
                this.writeAclConfigToStream(aceMap, mapOrder, outStream);
            }
            catch (IOException e) {
                LOG.error("Exception in AclDumpUtils: {}", (Throwable)e);
            }
        }
    }

    private ServletOutputStream writeAclConfigToStream(Map<String, Set<AceBean>> aceMap, int mapOrder, ServletOutputStream outStream) throws IOException {
        Set<String> keys = aceMap.keySet();
        outStream.println("- ace_config:");
        outStream.println();
        for (String mapKey : keys) {
            Set<AceBean> aceBeanSet = aceMap.get(mapKey);
            outStream.println(AcHelper.getBlankString(4) + "- " + mapKey + ":");
            for (AceBean bean : aceBeanSet) {
                outStream.println();
                if (mapOrder == 2) {
                    outStream.println(AcHelper.getBlankString(7) + "- principal: " + bean.getPrincipalName());
                } else if (mapOrder == 1) {
                    outStream.println(AcHelper.getBlankString(7) + "- path: " + bean.getJcrPath());
                }
                outStream.println(AcHelper.getBlankString(9) + "permission: " + bean.getPermission());
                outStream.println(AcHelper.getBlankString(9) + "actions: " + bean.getActionsString());
                outStream.println(AcHelper.getBlankString(9) + "privileges: " + bean.getPrivilegesString());
                outStream.print(AcHelper.getBlankString(9) + "repGlob: ");
                if (!bean.getRepGlob().isEmpty()) {
                    outStream.println("'" + bean.getRepGlob() + "'");
                    continue;
                }
                outStream.println();
            }
            outStream.println();
        }
        outStream.println();
        return outStream;
    }

    @Override
    public Set<AclBean> getACLDumpBeans(Session session) throws RepositoryException {
        List<String> excludeNodesList = Arrays.asList(this.queryExcludePaths);
        for (String path : excludeNodesList) {
            try {
                if (session.itemExists(path)) continue;
                LOG.error("Query exclude path: {} doesn't exist in repository! AccessControl installation aborted! Check exclude paths in OSGi configuration of AceService!", (Object)path);
                throw new IllegalArgumentException("Query exclude path: " + path + " doesn't exist in repository! AccessControl installation aborted! Check exclude paths in OSGi configuration of AceService!");
            }
            catch (RepositoryException e) {
                LOG.error("RepositoryException: {}", (Throwable)e);
                throw e;
            }
        }
        Set<Node> resultNodeSet = QueryHelper.getRepPolicyNodes(session, excludeNodesList);
        LinkedHashSet<AclBean> accessControBeanSet = new LinkedHashSet<AclBean>();
        for (Node node : resultNodeSet) {
            try {
                accessControBeanSet.add(new AclBean(AccessControlUtils.getAccessControlList(session, node.getParent().getPath()), node.getParent().getPath()));
            }
            catch (AccessDeniedException e) {
                LOG.error("AccessDeniedException: {}", (Throwable)e);
            }
            catch (ItemNotFoundException e) {
                LOG.error("ItemNotFoundException: {}", (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.error("RepositoryException: {}", (Throwable)e);
            }
        }
        return accessControBeanSet;
    }

    @Override
    public AceDumpData createAclDumpMap(Session session, int keyOrder, int aclOrdering, String[] excludePaths) throws ValueFormatException, IllegalArgumentException, IllegalStateException, RepositoryException {
        return this.createAclDumpMap(session, keyOrder, aclOrdering, excludePaths, this.includeUsersInDumps);
    }

    private AceDumpData createAclDumpMap(Session session, int keyOrder, int aclOrdering, String[] excludePaths, boolean isIncludeUsers) throws ValueFormatException, IllegalArgumentException, IllegalStateException, RepositoryException {
        AceDumpData aceDumpData = new AceDumpData();
        UserManager um = ((JackrabbitSession)session).getUserManager();
        TreeMap<String, Set<AceBean>> aceMap = null;
        TreeMap<String, Set<AceBean>> legacyAceMap = new TreeMap<String, Set<AceBean>>();
        if (keyOrder == AcHelper.PRINCIPAL_BASED_ORDER) {
            aceMap = new TreeMap<String, Set<AceBean>>();
        } else if (keyOrder == AcHelper.PATH_BASED_ORDER) {
            aceMap = new TreeMap();
        }
        Set<AclBean> aclBeanSet = this.getACLDumpBeans(session);
        for (AclBean aclBean : aclBeanSet) {
            if (aclBean.getAcl() == null) continue;
            for (AccessControlEntry ace : aclBean.getAcl().getAccessControlEntries()) {
                if (!(ace instanceof JackrabbitAccessControlEntry)) {
                    throw new IllegalStateException("AC entry is not a JackrabbitAccessControlEntry: " + ace);
                }
                AceWrapper tmpBean = new AceWrapper((JackrabbitAccessControlEntry)ace, aclBean.getJcrPath());
                AceBean tmpAceBean = AcHelper.getAceBean(tmpBean);
                Authorizable authorizable = um.getAuthorizable(tmpAceBean.getPrincipalName());
                if (authorizable != null) {
                    if (!authorizable.isGroup() && !isIncludeUsers) continue;
                    this.addBeanToMap(keyOrder, aclOrdering, aceMap, tmpAceBean);
                    continue;
                }
                this.addBeanToMap(keyOrder, aclOrdering, legacyAceMap, tmpAceBean);
            }
        }
        aceDumpData.setAceDump(aceMap);
        aceDumpData.setLegacyAceDump(legacyAceMap);
        return aceDumpData;
    }

    private void addBeanToMap(int keyOrder, int aclOrdering, Map<String, Set<AceBean>> aceMap, AceBean aceBean) {
        if (keyOrder == AcHelper.PRINCIPAL_BASED_ORDER) {
            String principalName = aceBean.getPrincipalName();
            if (!aceMap.containsKey(principalName)) {
                Set<AceBean> aceSet = this.getNewAceSet(aclOrdering);
                aceSet.add(aceBean);
                aceMap.put(principalName, aceSet);
            } else {
                aceMap.get(principalName).add(aceBean);
            }
        } else if (keyOrder == AcHelper.PATH_BASED_ORDER) {
            String jcrPath = aceBean.getJcrPath();
            if (!aceMap.containsKey(jcrPath)) {
                Set<AceBean> aceSet = this.getNewAceSet(aclOrdering);
                aceSet.add(aceBean);
                aceMap.put(jcrPath, aceSet);
            } else {
                aceMap.get(jcrPath).add(aceBean);
            }
        }
    }

    private String getIntermediatePath(String intermediatePath, String groupID) {
        int index = StringUtils.lastIndexOf((String)intermediatePath, (String)("/" + groupID));
        if (index != -1) {
            intermediatePath = intermediatePath.replace(intermediatePath.substring(index), "");
        }
        return intermediatePath;
    }

    public void returnAuthorizableDumpAsFile(SlingHttpServletResponse response, Set<AuthorizableConfigBean> authorizableSet) throws IOException {
        String mimetype = "application/octet-stream";
        response.setContentType(mimetype);
        ServletOutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
        }
        catch (IOException e) {
            LOG.error("Exception in AuthorizableDumpUtils: {}", (Throwable)e);
        }
        String fileName = "Authorizable_Dump_" + new Date(System.currentTimeMillis());
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        try {
            this.writeAuthorizableConfigToStream(authorizableSet, outStream);
        }
        catch (IOException e) {
            LOG.error("Exception in AuthorizableDumpUtils: {}", (Throwable)e);
        }
        outStream.close();
    }

    public void writeAuthorizableConfigToStream(Set<AuthorizableConfigBean> authorizableSet, ServletOutputStream outStream) throws IOException {
        outStream.println("- group_config:");
        outStream.println();
        for (AuthorizableConfigBean bean : authorizableSet) {
            outStream.println(AcHelper.getBlankString(4) + "- " + bean.getPrincipalID() + ":");
            outStream.println();
            outStream.println(AcHelper.getBlankString(7) + "- name: ");
            outStream.println(AcHelper.getBlankString(9) + "memberOf: " + bean.getMemberOfString());
            outStream.println(AcHelper.getBlankString(9) + "path: " + bean.getPath());
            outStream.println(AcHelper.getBlankString(9) + "isGroup: " + "'" + bean.isGroup() + "'");
            outStream.println();
        }
    }

    public Set<AuthorizableConfigBean> getUserBeans(Set<User> usersFromACEs) throws RepositoryException, UnsupportedRepositoryOperationException {
        TreeSet<AuthorizableConfigBean> userBeans = new TreeSet<AuthorizableConfigBean>(new AuthorizableBeanIDComparator());
        if (!usersFromACEs.isEmpty()) {
            for (User user : usersFromACEs) {
                AuthorizableConfigBean newBean = new AuthorizableConfigBean();
                newBean.setPrincipalID(user.getID());
                String intermediatePath = this.getIntermediatePath(user.getPath(), user.getID());
                newBean.setPath(intermediatePath);
                newBean.setIsGroup(false);
                new HashSet();
                this.addDeclaredMembers((Authorizable)user, newBean);
                userBeans.add(newBean);
            }
        }
        return userBeans;
    }

    @Override
    public Set<AuthorizableConfigBean> getGroupBeans(Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitSession js = (JackrabbitSession)session;
        UserManager userManager = js.getUserManager();
        LinkedHashSet<AuthorizableConfigBean> groupBeans = new LinkedHashSet<AuthorizableConfigBean>();
        Iterator result = userManager.findAuthorizables(new Query(){

            public void build(QueryBuilder builder) {
                builder.setSortOrder("@rep:principalName", QueryBuilder.Direction.ASCENDING);
                builder.setSelector(Group.class);
            }
        });
        while (result.hasNext()) {
            Group group = (Group)result.next();
            if (group != null) {
                AuthorizableConfigBean bean = new AuthorizableConfigBean();
                bean.setPrincipalID(group.getID());
                this.addDeclaredMembers((Authorizable)group, bean);
                bean.setIsGroup(group.isGroup());
                bean.setPath(this.getIntermediatePath(group.getPath(), group.getID()));
                groupBeans.add(bean);
                continue;
            }
            LOG.debug("group is null !");
        }
        return groupBeans;
    }

    private void addDeclaredMembers(Authorizable authorizable, AuthorizableConfigBean bean) throws RepositoryException {
        Iterator it = authorizable.declaredMemberOf();
        ArrayList<String> memberOfList = new ArrayList<String>();
        while (it.hasNext()) {
            memberOfList.add(((Group)it.next()).getID());
        }
        bean.setMemberOf(memberOfList.toArray(new String[memberOfList.size()]));
    }

    private Set<AceBean> getNewAceSet(int aclOrdering) {
        AbstractSet aceSet = null;
        if (aclOrdering == AcHelper.ACE_ORDER_NONE) {
            aceSet = new LinkedHashSet<AceBean>();
        } else if (aclOrdering == AcHelper.ACE_ORDER_DENY_ALLOW) {
            aceSet = new TreeSet<AceBean>(new AcePermissionComparator());
        } else if (aclOrdering == AcHelper.ACE_ORDER_ALPHABETICAL) {
            aceSet = new TreeSet<AceBean>(new AcePathComparator());
        }
        return aceSet;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

