/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.comparators.AcePermissionComparator;
import biz.netcentric.cq.tools.actool.dumpservice.Dumpservice;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.helper.AceBean;
import biz.netcentric.cq.tools.actool.helper.AceWrapper;
import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import java.security.Principal;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcHelper {
    public static final Logger LOG = LoggerFactory.getLogger(AcHelper.class);
    public static int ACE_ORDER_DENY_ALLOW = 1;
    public static int ACE_ORDER_NONE = 2;
    public static int ACE_ORDER_ALPHABETICAL = 3;
    public static int PRINCIPAL_BASED_ORDER = 1;
    public static int PATH_BASED_ORDER = 2;

    private AcHelper() {
    }

    public static AceBean getAceBean(AceWrapper ace) throws ValueFormatException, IllegalStateException, RepositoryException {
        AceBean aceBean = new AceBean();
        aceBean.setPermission(ace.isAllow() ? "allow" : "deny");
        aceBean.setJcrPath(ace.getJcrPath());
        aceBean.setPrincipal(ace.getPrincipal().getName());
        aceBean.setPrivilegesString(ace.getPrivilegesString());
        aceBean.setRepGlob(ace.getRestrictionAsString("rep:glob"));
        return aceBean;
    }

    public static String getBlankString(int nrOfBlanks) {
        return StringUtils.repeat((String)" ", (int)nrOfBlanks);
    }

    public static void installPathBasedACEs(Map<String, Set<AceBean>> pathBasedAceMapFromConfig, Session session, AcInstallationHistoryPojo history) throws Exception {
        Set<String> paths = pathBasedAceMapFromConfig.keySet();
        LOG.info("Paths in merged config = {}", paths);
        history.addVerboseMessage("found: " + paths.size() + "  paths in merged config");
        for (String path : paths) {
            Set<AceBean> aceBeanSetFromConfig = pathBasedAceMapFromConfig.get(path);
            TreeSet<AceBean> orderedAceBeanSetFromConfig = new TreeSet<AceBean>(new AcePermissionComparator());
            orderedAceBeanSetFromConfig.addAll(aceBeanSetFromConfig);
            for (AceBean bean : orderedAceBeanSetFromConfig) {
                AccessControlUtils.deleteAllEntriesForAuthorizableFromACL(session, path, bean.getPrincipalName());
                String message = "deleted all ACEs of authorizable " + bean.getPrincipalName() + " from ACL of path: " + path;
                LOG.info(message);
                history.addVerboseMessage(message);
            }
            AcHelper.writeAcBeansToRepository(session, history, orderedAceBeanSetFromConfig);
        }
    }

    private static void writeAcBeansToRepository(Session session, AcInstallationHistoryPojo history, Set<AceBean> aceBeanSetFromConfig) throws RepositoryException, UnsupportedRepositoryOperationException {
        for (AceBean bean : aceBeanSetFromConfig) {
            LOG.debug("Writing bean to repository {}", (Object)bean);
            Principal currentPrincipal = AcHelper.getPrincipal(session, bean);
            if (currentPrincipal == null) {
                String errMessage = "Could not find definition for authorizable " + bean.getPrincipalName() + " in groups config while installing ACE for: " + bean.getJcrPath() + "! Skipped installation of ACEs for this authorizable!\n";
                LOG.error(errMessage);
                history.addError(errMessage);
                continue;
            }
            history.addVerboseMessage("starting installation of bean: \n" + bean);
            bean.install(session, currentPrincipal, history);
        }
    }

    private static Principal getPrincipal(Session session, AceBean aceBean) throws InvalidQueryException, RepositoryException {
        Principal principal = null;
        String principalName = aceBean.getPrincipalName();
        principal = AcHelper.getPrincipalForName(session, principalName);
        if (principal == null) {
            String query = "/jcr:root/home/groups//*[(@jcr:primaryType = 'rep:Group') and jcr:like(@rep:principalName, 'cn=" + principalName + "%')]";
            LOG.debug("Fallback query did not return results for principalName={}, using second fallback query (ldap name): {}", (Object)principalName, (Object)query);
            principal = AcHelper.getPrincipalByQuery(query, session);
        }
        LOG.debug("Returning {} for principal {}", (Object)principal, (Object)principalName);
        return principal;
    }

    private static Principal getPrincipalForName(Session session, String principalName) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        Principal principal = null;
        JackrabbitSession js = (JackrabbitSession)session;
        UserManager userManager = js.getUserManager();
        Authorizable authorizable = userManager.getAuthorizable(principalName);
        principal = authorizable != null ? authorizable.getPrincipal() : null;
        return principal;
    }

    private static Principal getPrincipalByQuery(String queryStringGroups, Session session) throws InvalidQueryException, RepositoryException {
        Query queryGroups = session.getWorkspace().getQueryManager().createQuery(queryStringGroups, "xpath");
        QueryResult queryResultGroups = queryGroups.execute();
        NodeIterator nitGroups = queryResultGroups.getNodes();
        if (!nitGroups.hasNext()) {
            LOG.debug("Executing query '{}' did not have any results", (Object)queryStringGroups);
            return null;
        }
        Node node = nitGroups.nextNode();
        if (node.hasProperty("rep:principalName")) {
            String principalName = node.getProperty("rep:principalName").getString();
            Principal principal = AcHelper.getPrincipalForName(session, principalName);
            return principal;
        }
        LOG.debug("Group '{}' did not have a rep:principalName property", (Object)node.getPath());
        return null;
    }

    public static Map<String, Set<AceBean>> createAceMap(SlingHttpServletRequest request, int keyOrdering, int aclOrdering, String[] excludePaths, Dumpservice dumpservice) throws ValueFormatException, IllegalStateException, RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        return dumpservice.createAclDumpMap(session, keyOrdering, aclOrdering, excludePaths).getAceDump();
    }

    public static Map<String, Set<AceBean>> getPathBasedAceMap(Map<String, Set<AceBean>> groupBasedAceMap, int sorting) {
        HashMap<String, Set<AceBean>> pathBasedAceMap = new HashMap<String, Set<AceBean>>(groupBasedAceMap.size());
        for (Map.Entry<String, Set<AceBean>> entry : groupBasedAceMap.entrySet()) {
            String principal = entry.getKey();
            Set<AceBean> tmpSet = entry.getValue();
            for (AceBean bean : tmpSet) {
                bean.setPrincipal(principal);
                if (pathBasedAceMap.get(bean.getJcrPath()) == null) {
                    AbstractSet aceSet = null;
                    if (sorting == ACE_ORDER_NONE) {
                        aceSet = new HashSet<AceBean>();
                    } else if (sorting == ACE_ORDER_DENY_ALLOW) {
                        aceSet = new TreeSet<AceBean>(new AcePermissionComparator());
                    }
                    aceSet.add(bean);
                    pathBasedAceMap.put(bean.getJcrPath(), aceSet);
                    continue;
                }
                ((Set)pathBasedAceMap.get(bean.getJcrPath())).add(bean);
            }
        }
        return pathBasedAceMap;
    }

    public static boolean isEqualBean(AceBean bean1, AceBean bean2) {
        HashSet<String> bean1Privileges = new HashSet<String>(Arrays.asList(bean1.getPrivilegesString().split(",")));
        HashSet<String> bean2Privileges = new HashSet<String>(Arrays.asList(bean2.getPrivilegesString().split(",")));
        return bean1.getJcrPath().equals(bean2.getJcrPath()) && bean1.getPrincipalName().equals(bean2.getPrincipalName()) && bean1.isAllow() == bean2.isAllow() && bean1.getRepGlob().equals(bean2.getRepGlob()) && bean1.getPermission().equals(bean2.getPermission()) && bean1Privileges.containsAll(bean2Privileges);
    }
}

