/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.helper.AcHelper;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AccessControlUtils.class);

    private AccessControlUtils() {
    }

    public static Privilege[] privilegesFromNames(Session session, String ... privilegeNames) throws RepositoryException {
        return AccessControlUtils.privilegesFromNames(session.getAccessControlManager(), privilegeNames);
    }

    public static Privilege[] privilegesFromNames(AccessControlManager accessControlManager, String ... privilegeNames) throws RepositoryException {
        HashSet<Privilege> privileges = new HashSet<Privilege>(privilegeNames.length);
        for (String privName : privilegeNames) {
            privileges.add(accessControlManager.privilegeFromName(privName));
        }
        return privileges.toArray(new Privilege[privileges.size()]);
    }

    public static String[] namesFromPrivileges(Privilege ... privileges) {
        if (privileges == null || privileges.length == 0) {
            return new String[0];
        }
        String[] names = new String[privileges.length];
        for (int i = 0; i < privileges.length; ++i) {
            names[i] = privileges[i].getName();
        }
        return names;
    }

    public static JackrabbitAccessControlList getAccessControlList(Session session, String absPath) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        return AccessControlUtils.getAccessControlList(acMgr, absPath);
    }

    public static JackrabbitAccessControlList getAccessControlPolicies(Session session, Principal principal) throws UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitAccessControlManager acMgr = (JackrabbitAccessControlManager)session.getAccessControlManager();
        if (acMgr.getPolicies(principal).length > 0) {
            JackrabbitAccessControlList jACL = (JackrabbitAccessControlList)acMgr.getPolicies(principal)[0];
            return jACL;
        }
        return null;
    }

    public static JackrabbitAccessControlList getAccessControlList(AccessControlManager accessControlManager, String absPath) throws RepositoryException {
        AccessControlPolicy[] pcls;
        AccessControlPolicyIterator itr = accessControlManager.getApplicablePolicies(absPath);
        while (itr.hasNext()) {
            AccessControlPolicy policy = itr.nextAccessControlPolicy();
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)policy;
        }
        for (AccessControlPolicy policy : pcls = accessControlManager.getPolicies(absPath)) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)policy;
        }
        LOG.warn("no policy found for path: {}", (Object)absPath);
        return null;
    }

    public static boolean addAccessControlEntry(Session session, String absPath, Principal principal, String[] privilegeNames, boolean isAllow) throws RepositoryException {
        return AccessControlUtils.addAccessControlEntry(session, absPath, principal, AccessControlUtils.privilegesFromNames(session, privilegeNames), isAllow);
    }

    public static boolean addAccessControlEntry(Session session, String absPath, Principal principal, Privilege[] privileges, boolean isAllow) throws RepositoryException {
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList(session, absPath);
        if (acl != null && acl.addEntry(principal, privileges, isAllow)) {
            session.getAccessControlManager().setPolicy(absPath, (AccessControlPolicy)acl);
            return true;
        }
        return false;
    }

    private static Principal getEveryonePrincipal(Session session) throws RepositoryException {
        if (session instanceof JackrabbitSession) {
            return ((JackrabbitSession)session).getPrincipalManager().getEveryone();
        }
        throw new UnsupportedOperationException("Failed to retrieve everyone principal: JackrabbitSession expected.");
    }

    static Set<Privilege> getPrivilegeSet(String[] privNames, AccessControlManager acMgr) throws RepositoryException {
        if (privNames == null) {
            return Collections.emptySet();
        }
        HashSet<Privilege> privileges = new HashSet<Privilege>(privNames.length);
        for (String name : privNames) {
            Privilege p = acMgr.privilegeFromName(name);
            if (p.isAggregate()) {
                privileges.addAll(Arrays.asList(p.getAggregatePrivileges()));
                continue;
            }
            privileges.add(p);
        }
        return privileges;
    }

    public static void deleteAllEntriesForAuthorizableFromACL(Session session, String path, String authorizableID) throws UnsupportedRepositoryOperationException, RepositoryException {
        AccessControlEntry[] aces;
        AccessControlManager accessControlManager = session.getAccessControlManager();
        JackrabbitAccessControlList acl = AccessControlUtils.getModifiableAcl(accessControlManager, path);
        if (acl == null) {
            return;
        }
        for (AccessControlEntry ace : aces = acl.getAccessControlEntries()) {
            JackrabbitAccessControlEntry jace = (JackrabbitAccessControlEntry)ace;
            if (!StringUtils.equals((String)jace.getPrincipal().getName(), (String)authorizableID)) continue;
            acl.removeAccessControlEntry((AccessControlEntry)jace);
            accessControlManager.setPolicy(path, (AccessControlPolicy)acl);
        }
    }

    static JackrabbitAccessControlList getModifiableAcl(AccessControlManager acMgr, String path) throws RepositoryException, AccessDeniedException {
        AccessControlPolicy[] existing = null;
        try {
            existing = acMgr.getPolicies(path);
        }
        catch (PathNotFoundException e) {
            AcHelper.LOG.warn("No node could be found under: {}. Application of ACL for that node cancelled!", (Object)path);
        }
        if (existing != null) {
            for (AccessControlPolicy p : existing) {
                if (!(p instanceof JackrabbitAccessControlList)) continue;
                return (JackrabbitAccessControlList)p;
            }
            AccessControlPolicyIterator it = acMgr.getApplicablePolicies(path);
            while (it.hasNext()) {
                AccessControlPolicy p = it.nextAccessControlPolicy();
                if (!(p instanceof JackrabbitAccessControlList)) continue;
                return (JackrabbitAccessControlList)p;
            }
            throw new AccessControlException("No modifiable ACL at " + path);
        }
        return null;
    }

    public static void extendExistingAceWithRestrictions(JackrabbitAccessControlList accessControlList, JackrabbitAccessControlEntry accessControlEntry, Map<String, Value> restrictions) throws AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        if (!accessControlList.addEntry(accessControlEntry.getPrincipal(), accessControlEntry.getPrivileges(), accessControlEntry.isAllow(), restrictions)) {
            throw new IllegalStateException("Could not add entry, probably because it was already there!");
        }
        AccessControlEntry newAccessControlEntry = accessControlList.getAccessControlEntries()[accessControlList.size() - 1];
        accessControlList.orderBefore(newAccessControlEntry, (AccessControlEntry)accessControlEntry);
        accessControlList.removeAccessControlEntry((AccessControlEntry)accessControlEntry);
    }
}

