/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElement;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElementVisitor;
import biz.netcentric.cq.tools.actool.helper.AccessControlUtils;
import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import com.day.cq.security.util.CqActions;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;

public class AceBean
implements AcDumpElement {
    private String jcrPath;
    private String repGlob;
    private String actionsStringFromConfig;
    private String privilegesString;
    private String principal;
    private String permission;
    private String[] actions;
    private String assertedExceptionString;
    public static final String RESTRICTION_NAME_GLOB = "rep:glob";

    public String getAssertedExceptionString() {
        return this.assertedExceptionString;
    }

    public void setAssertedExceptionString(String assertedException) {
        this.assertedExceptionString = assertedException;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permissionString) {
        this.permission = permissionString;
    }

    public void clearActions() {
        this.actions = null;
        this.actionsStringFromConfig = "";
    }

    public String getPrincipalName() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getJcrPath() {
        return this.jcrPath;
    }

    public void setJcrPath(String jcrPath) {
        this.jcrPath = jcrPath;
    }

    public boolean isAllow() {
        return "allow".equalsIgnoreCase(this.permission);
    }

    public String getRepGlob() {
        return this.repGlob;
    }

    public void setRepGlob(String repGlob) {
        this.repGlob = repGlob;
    }

    public String getActionsString() {
        if (this.actions != null) {
            StringBuilder sb = new StringBuilder();
            for (String action : this.actions) {
                sb.append(action).append(",");
            }
            return StringUtils.chomp((String)sb.toString(), (String)",");
        }
        return "";
    }

    public String getActionsStringFromConfig() {
        return this.actionsStringFromConfig;
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    public void setActionsStringFromConfig(String actionsString) {
        this.actionsStringFromConfig = actionsString;
    }

    public String[] getActions() {
        return this.actions;
    }

    public String getPrivilegesString() {
        return this.privilegesString;
    }

    public String[] getPrivileges() {
        if (StringUtils.isNotBlank((String)this.privilegesString)) {
            return this.privilegesString.split(",");
        }
        return null;
    }

    public void setPrivilegesString(String privilegesString) {
        this.privilegesString = privilegesString;
    }

    public String toString() {
        return "AceBean [jcrPath=" + this.jcrPath + "\n" + ", permission=" + this.permission + "\n" + ", repGlob=" + this.repGlob + "\n" + ", actionsString=" + this.actionsStringFromConfig + "\n" + ", privilegesString=" + this.privilegesString + "\n" + ", principal=" + this.principal + "\n" + ", actions=" + Arrays.toString(this.actions) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.actions);
        result = 31 * result + (this.actionsStringFromConfig == null ? 0 : this.actionsStringFromConfig.hashCode());
        result = 31 * result + (this.jcrPath == null ? 0 : this.jcrPath.hashCode());
        result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        result = 31 * result + (this.privilegesString == null ? 0 : this.privilegesString.hashCode());
        result = 31 * result + (this.repGlob == null ? 0 : this.repGlob.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AceBean other = (AceBean)obj;
        if (!Arrays.equals(this.actions, other.actions)) {
            return false;
        }
        if (this.actionsStringFromConfig == null ? other.actionsStringFromConfig != null : !this.actionsStringFromConfig.equals(other.actionsStringFromConfig)) {
            return false;
        }
        if (this.jcrPath == null ? other.jcrPath != null : !this.jcrPath.equals(other.jcrPath)) {
            return false;
        }
        if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
            return false;
        }
        if (this.permission == null ? other.permission != null : !this.permission.equals(other.permission)) {
            return false;
        }
        if (this.privilegesString == null ? other.privilegesString != null : !this.privilegesString.equals(other.privilegesString)) {
            return false;
        }
        return !(this.repGlob == null ? other.repGlob != null : !this.repGlob.equals(other.repGlob));
    }

    @Override
    public void accept(AcDumpElementVisitor acDumpElementVisitor) {
        acDumpElementVisitor.visit(this);
    }

    private void removeRedundantPrivileges(Session session) throws RepositoryException {
        Set<String> cleanedPrivileges = AceBean.removeRedundantPrivileges(session, this.getPrivileges(), this.getActions());
        this.privilegesString = StringUtils.join(cleanedPrivileges, (String)",");
    }

    private static Set<String> removeRedundantPrivileges(Session session, String[] privileges, String[] actions) throws RepositoryException {
        CqActions cqActions = new CqActions(session);
        HashSet<String> cleanedPrivileges = new HashSet<String>();
        if (privileges == null) {
            return cleanedPrivileges;
        }
        cleanedPrivileges.addAll(Arrays.asList(privileges));
        if (actions == null) {
            return cleanedPrivileges;
        }
        for (String action : actions) {
            Set coveredPrivileges = cqActions.getPrivileges(action);
            for (Privilege coveredPrivilege : coveredPrivileges) {
                cleanedPrivileges.remove(coveredPrivilege.getName());
            }
        }
        return cleanedPrivileges;
    }

    private Map<String, Value> getSingleValueRestrictions(Session session, JackrabbitAccessControlList acl) throws ValueFormatException, UnsupportedRepositoryOperationException, RepositoryException {
        List<String> supportedRestrictionNames = Arrays.asList(acl.getRestrictionNames());
        if (this.getRepGlob() != null) {
            if (!supportedRestrictionNames.contains(RESTRICTION_NAME_GLOB)) {
                throw new IllegalStateException("The AccessControlList at " + acl.getPath() + " does not support setting rep:glob restrictions!");
            }
            Value v = session.getValueFactory().createValue(this.getRepGlob(), acl.getRestrictionType(RESTRICTION_NAME_GLOB));
            return Collections.singletonMap(RESTRICTION_NAME_GLOB, v);
        }
        return Collections.emptyMap();
    }

    private Map<String, Boolean> getActionMap() {
        if (this.actions == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> actionMap = new HashMap<String, Boolean>();
        for (String action : this.actions) {
            actionMap.put(action, this.isAllow());
        }
        return actionMap;
    }

    private JackrabbitAccessControlList installActions(Principal principal, JackrabbitAccessControlList acl, Session session, AccessControlManager acMgr) throws RepositoryException {
        Map<String, Boolean> actionMap = this.getActionMap();
        if (actionMap.isEmpty()) {
            return acl;
        }
        int previousAclSize = acl.size();
        CqActions cqActions = new CqActions(session);
        Collection inheritedAllows = cqActions.getAllowedActions(this.getJcrPath(), Collections.singleton(principal));
        cqActions.installActions(this.getJcrPath(), principal, actionMap, inheritedAllows);
        JackrabbitAccessControlList newAcl = AccessControlUtils.getAccessControlList(session, this.getJcrPath());
        Map<String, Value> restrictions = this.getSingleValueRestrictions(session, acl);
        if (restrictions.isEmpty()) {
            return newAcl;
        }
        int newAclSize = newAcl.size();
        if (previousAclSize >= newAclSize) {
            throw new IllegalStateException("No new entries have been set for AccessControlList at " + this.getJcrPath());
        }
        AccessControlEntry[] aces = newAcl.getAccessControlEntries();
        for (int acEntryIndex = previousAclSize; acEntryIndex < newAclSize; ++acEntryIndex) {
            if (!(aces[acEntryIndex] instanceof JackrabbitAccessControlEntry)) {
                throw new IllegalStateException("Can not deal with non JackrabbitAccessControlEntrys, but entry is of type " + aces[acEntryIndex].getClass().getName());
            }
            JackrabbitAccessControlEntry ace = (JackrabbitAccessControlEntry)aces[acEntryIndex];
            if (ace.getRestrictions(RESTRICTION_NAME_GLOB) != null) continue;
            AccessControlUtils.extendExistingAceWithRestrictions(newAcl, ace, restrictions);
        }
        return newAcl;
    }

    private boolean installPrivileges(Principal principal, JackrabbitAccessControlList acl, Session session, AccessControlManager acMgr) throws RepositoryException {
        Set<Privilege> privileges = AccessControlUtils.getPrivilegeSet(this.getPrivileges(), acMgr);
        if (!privileges.isEmpty()) {
            Map<String, Value> restrictions = this.getSingleValueRestrictions(session, acl);
            if (!restrictions.isEmpty()) {
                acl.addEntry(principal, privileges.toArray(new Privilege[privileges.size()]), this.isAllow(), restrictions);
            } else {
                acl.addEntry(principal, privileges.toArray(new Privilege[privileges.size()]), this.isAllow());
            }
            return true;
        }
        return false;
    }

    public void install(Session session, Principal principal, AcInstallationHistoryPojo history) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        JackrabbitAccessControlList acl = AccessControlUtils.getModifiableAcl(acMgr, this.getJcrPath());
        if (acl == null) {
            history.addWarning("Skipped installing privileges/actions for non existing path: " + this.getJcrPath());
            return;
        }
        JackrabbitAccessControlList newAcl = this.installActions(principal, acl, session, acMgr);
        if (acl != newAcl) {
            history.addVerboseMessage("added action(s) for path: " + this.getJcrPath() + ", principal: " + principal.getName() + ", actions: " + this.getActionsString() + ", allow: " + this.isAllow());
            this.removeRedundantPrivileges(session);
            acl = newAcl;
        }
        if (this.installPrivileges(principal, acl, session, acMgr)) {
            history.addVerboseMessage("added privilege(s) for path: " + this.getJcrPath() + ", principal: " + principal.getName() + ", privileges: " + this.getPrivilegesString() + ", allow: " + this.isAllow());
        }
        acMgr.setPolicy(this.getJcrPath(), (AccessControlPolicy)acl);
    }
}

