/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import java.security.Principal;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;

public class AceWrapper
implements JackrabbitAccessControlEntry {
    private JackrabbitAccessControlEntry ace;
    private String jcrPath;

    public AceWrapper(JackrabbitAccessControlEntry ace, String jcrPath) {
        this.ace = ace;
        this.jcrPath = jcrPath;
    }

    public String getJcrPath() {
        return this.jcrPath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ace == null ? 0 : this.ace.hashCode());
        result = 31 * result + (this.jcrPath == null ? 0 : this.jcrPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AceWrapper other = (AceWrapper)obj;
        if (this.ace == null ? other.ace != null : !this.ace.equals(other.ace)) {
            return false;
        }
        return !(this.jcrPath == null ? other.jcrPath != null : !this.jcrPath.equals(other.jcrPath));
    }

    public String toString() {
        return "AceWrapper [ace=" + this.ace + ", jcrPath=" + this.jcrPath + "]";
    }

    public String getRestrictionAsString(String name) throws RepositoryException {
        Value val = this.ace.getRestriction(name);
        if (val != null) {
            return this.ace.getRestriction(name).getString();
        }
        return null;
    }

    public String getPrivilegesString() {
        Privilege[] privileges = this.ace.getPrivileges();
        String privilegesString = "";
        for (Privilege privilege : privileges) {
            privilegesString = privilegesString + privilege.getName() + ",";
        }
        privilegesString = StringUtils.chop((String)privilegesString);
        return privilegesString;
    }

    public Principal getPrincipal() {
        return this.ace.getPrincipal();
    }

    public Privilege[] getPrivileges() {
        return this.ace.getPrivileges();
    }

    public boolean isAllow() {
        return this.ace.isAllow();
    }

    public String[] getRestrictionNames() throws RepositoryException {
        return this.ace.getRestrictionNames();
    }

    public Value getRestriction(String restrictionName) throws ValueFormatException, RepositoryException {
        return this.ace.getRestriction(restrictionName);
    }

    public Value[] getRestrictions(String restrictionName) throws RepositoryException {
        return this.ace.getRestrictions(restrictionName);
    }
}

