/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;

public class AclBean {
    private String jcrPath;
    private String parentPath;
    private JackrabbitAccessControlList acl;

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public AclBean(JackrabbitAccessControlList acl, String jcrPath) {
        this.jcrPath = jcrPath;
        this.acl = acl;
    }

    public AclBean() {
    }

    public String getJcrPath() {
        return this.jcrPath;
    }

    public void setJcrPath(String jcrPath) {
        this.jcrPath = jcrPath;
    }

    public JackrabbitAccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(JackrabbitAccessControlList acl) {
        this.acl = acl;
    }

    public String[] getAces(JackrabbitAccessControlList acl) throws RepositoryException {
        return this.acl.getRestrictionNames();
    }

    public List<AccessControlEntry> getGroupBasedACEs(Session session, Principal principal) throws UnsupportedRepositoryOperationException, RepositoryException {
        ArrayList<AccessControlEntry> aceList = new ArrayList<AccessControlEntry>();
        if (this.acl != null) {
            AccessControlEntry[] aces;
            for (AccessControlEntry ace : aces = this.acl.getAccessControlEntries()) {
                if (!ace.getPrincipal().getName().equals(principal.getName())) continue;
                aceList.add(ace);
            }
        }
        return aceList;
    }

    public String toString() {
        return "[" + this.jcrPath + " " + this.acl.toString() + "]";
    }

    public boolean equals(Object obj) {
        return this.acl.equals(obj);
    }
}

