/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import biz.netcentric.cq.tools.actool.helper.AcHelper;
import biz.netcentric.cq.tools.actool.helper.AclBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;

public class QueryHelper {
    public static Set<Node> getRepPolicyNodes(Session session, List<String> excludePaths) {
        NodeIterator nodeIt = null;
        try {
            nodeIt = session.getRootNode().getNodes();
        }
        catch (RepositoryException e) {
            AcHelper.LOG.error("Exception: {}", (Throwable)e);
        }
        TreeSet<String> paths = new TreeSet<String>();
        while (nodeIt.hasNext()) {
            String currentPath = null;
            Node currentNode = nodeIt.nextNode();
            try {
                currentPath = currentNode.getPath();
            }
            catch (RepositoryException e) {
                AcHelper.LOG.error("Exception: {}", (Throwable)e);
            }
            try {
                if (currentNode.hasProperty("rep:AuthorizableFolder") || excludePaths.contains(currentPath)) continue;
                paths.add(currentPath);
            }
            catch (RepositoryException e) {
                AcHelper.LOG.error("Exception: {}", (Throwable)e);
            }
        }
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        try {
            if (session.nodeExists("/rep:policy")) {
                nodes.add(session.getNode("/rep:policy"));
            }
            if (session.nodeExists("/home/rep:policy")) {
                nodes.add(session.getNode("/home/rep:policy"));
            }
            for (String path : paths) {
                String query = "SELECT * FROM [rep:ACL] WHERE ISDESCENDANTNODE([" + path + "])";
                nodes.addAll(QueryHelper.getNodes(session, query, "JCR-SQL2"));
            }
        }
        catch (InvalidQueryException e) {
            AcHelper.LOG.error("InvalidQueryException: {}", (Throwable)e);
        }
        catch (RepositoryException e) {
            AcHelper.LOG.error("RepositoryException: {}", (Throwable)e);
        }
        return nodes;
    }

    public static Set<Node> getNodes(Session session, String xpathQuery) throws InvalidQueryException, RepositoryException {
        Set<Node> nodes = QueryHelper.getNodes(session, xpathQuery, "xpath");
        return nodes;
    }

    public static Set<Node> getNodes(Session session, String queryStatement, String queryLanguageType) throws InvalidQueryException, RepositoryException {
        HashSet<Node> nodes = new HashSet<Node>();
        Query query = session.getWorkspace().getQueryManager().createQuery(queryStatement, queryLanguageType);
        QueryResult queryResult = query.execute();
        NodeIterator nit = queryResult.getNodes();
        ArrayList<String> paths = new ArrayList<String>();
        while (nit.hasNext()) {
            Node node = nit.nextNode();
            paths.add(node.getPath());
            nodes.add(node);
        }
        return nodes;
    }

    public static Set<String> getUsersFromHome(Session session) throws InvalidQueryException, RepositoryException {
        Set<String> users = QueryHelper.getPrincipalsFromHome(session, "rep:User");
        return users;
    }

    public static Set<String> getGroupsFromHome(Session session) throws InvalidQueryException, RepositoryException {
        Set<String> groups = QueryHelper.getPrincipalsFromHome(session, "rep:Group");
        return groups;
    }

    private static Set<String> getPrincipalsFromHome(Session session, String principalNodeType) throws InvalidQueryException, RepositoryException {
        TreeSet<String> principals = new TreeSet<String>();
        String queryStringPrincipals = "SELECT * FROM [" + principalNodeType + "]";
        Query queryPrincipals = session.getWorkspace().getQueryManager().createQuery(queryStringPrincipals, "JCR-SQL2");
        QueryResult queryResultPrincipals = queryPrincipals.execute();
        NodeIterator nitPrincipals = queryResultPrincipals.getNodes();
        while (nitPrincipals.hasNext()) {
            Node node = nitPrincipals.nextNode();
            String tmp = node.getProperty("rep:principalName").getString();
            principals.add(tmp);
        }
        return principals;
    }

    public static Set<AclBean> getAuthorizablesAcls(Session session, Set<String> authorizableIds) throws InvalidQueryException, RepositoryException {
        LinkedHashSet<Node> nodeSet = new LinkedHashSet<Node>();
        Iterator<String> authorizablesIdIterator = authorizableIds.iterator();
        while (authorizablesIdIterator.hasNext()) {
            StringBuilder queryStringBuilder = new StringBuilder();
            queryStringBuilder.append("SELECT * FROM [rep:ACE] WHERE ");
            queryStringBuilder.append((CharSequence)QueryHelper.getAuthorizablesQueryStringBuilder(authorizablesIdIterator, 100));
            nodeSet.addAll(QueryHelper.getNodes(session, queryStringBuilder.toString(), "JCR-SQL2"));
        }
        return QueryHelper.buildAclBeansFromNodeSet(session, nodeSet);
    }

    private static Set<AclBean> buildAclBeansFromNodeSet(Session session, Set<Node> nodeSet) throws UnsupportedRepositoryOperationException, RepositoryException, PathNotFoundException, AccessDeniedException, ItemNotFoundException {
        AccessControlManager aMgr = session.getAccessControlManager();
        LinkedHashSet<AclBean> aclSet = new LinkedHashSet<AclBean>();
        for (Node node : nodeSet) {
            AccessControlList acl = (AccessControlList)aMgr.getPolicies(node.getParent().getParent().getPath())[0];
            AclBean aclBean = new AclBean();
            aclBean.setParentPath(node.getParent().getParent().getPath());
            aclBean.setAcl((JackrabbitAccessControlList)acl);
            aclBean.setJcrPath(node.getParent().getPath());
            aclSet.add(aclBean);
        }
        return aclSet;
    }

    private static StringBuilder getAuthorizablesQueryStringBuilder(Iterator<String> authorizablesIdIterator, int authorizbalesLimitPerQuery) {
        int authorizableCounter = 0;
        StringBuilder querySb = new StringBuilder();
        if (!authorizablesIdIterator.hasNext()) {
            return querySb;
        }
        while (true) {
            querySb.append("[rep:principalName] = '" + authorizablesIdIterator.next() + "'");
            if (++authorizableCounter >= authorizbalesLimitPerQuery || !authorizablesIdIterator.hasNext()) break;
            querySb.append(" or ");
        }
        return querySb;
    }

    public static Set<AclBean> getAuthorizablesAcls(Session session, String authorizableId) throws InvalidQueryException, RepositoryException {
        LinkedHashSet<Node> nodeSet = new LinkedHashSet<Node>();
        String query = "SELECT * FROM [rep:ACE] WHERE [rep:principalName] = '" + authorizableId + "'";
        nodeSet.addAll(QueryHelper.getNodes(session, query, "JCR-SQL2"));
        Set<AclBean> aclSet = QueryHelper.buildAclBeansFromNodeSet(session, nodeSet);
        return aclSet;
    }
}

