/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.installationhistory;

import biz.netcentric.cq.tools.actool.comparators.HistoryEntryComparator;
import biz.netcentric.cq.tools.actool.installationhistory.HistoryEntry;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcInstallationHistoryPojo {
    private static final Logger LOG = LoggerFactory.getLogger(AcInstallationHistoryPojo.class);
    private static final String MSG_IDENTIFIER_EXCEPTION = "EXCEPTION:";
    private static final String MSG_IDENTIFIER_WARNING = "WARNING:";
    private Set<HistoryEntry> warnings = new HashSet<HistoryEntry>();
    private Set<HistoryEntry> messages = new HashSet<HistoryEntry>();
    private Set<HistoryEntry> exceptions = new HashSet<HistoryEntry>();
    private Set<HistoryEntry> verboseMessages = new HashSet<HistoryEntry>();
    private boolean success = true;
    private Date installationDate;
    private long executionTime;
    private long msgIndex = 0L;
    Rendition rendition;

    public AcInstallationHistoryPojo() {
        this.rendition = Rendition.TXT;
        this.setInstallationDate(new Date());
    }

    public AcInstallationHistoryPojo(Rendition rendition) {
        this.rendition = rendition;
        this.setInstallationDate(new Date());
    }

    public Date getInstallationDate() {
        return this.installationDate;
    }

    public void setInstallationDate(Date installationDate) {
        this.installationDate = installationDate;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long time) {
        this.executionTime = time;
    }

    public Set<HistoryEntry> getWarnings() {
        return this.warnings;
    }

    public void addWarning(String warning) {
        if (this.rendition.equals((Object)Rendition.HTML)) {
            this.warnings.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), "<font color='orange'><b>WARNING: " + warning + "</b></font>"));
        } else if (this.rendition.equals((Object)Rendition.TXT)) {
            this.warnings.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), "WARNING: " + warning));
        }
        ++this.msgIndex;
    }

    public void addMessage(String message) {
        this.messages.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), " " + message));
        ++this.msgIndex;
    }

    public void addError(String exception) {
        if (this.rendition.equals((Object)Rendition.HTML)) {
            this.exceptions.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), "<font color='red'><b>EXCEPTION:</b> " + exception + "</b></font>"));
        } else if (this.rendition.equals((Object)Rendition.TXT)) {
            this.exceptions.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), "EXCEPTION: " + exception));
        }
        this.success = false;
        ++this.msgIndex;
    }

    public void addVerboseMessage(String message) {
        this.verboseMessages.add(new HistoryEntry(this.msgIndex, new Timestamp(new Date().getTime()), " " + message));
        ++this.msgIndex;
    }

    public Set<HistoryEntry> getMessages() {
        return this.messages;
    }

    public Set<HistoryEntry> getException() {
        return this.exceptions;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nInstallation triggered: " + this.installationDate.toString() + "\n");
        sb.append("\n" + this.getMessageHistory() + "\n");
        sb.append("\nExecution time: " + this.executionTime + " ms\n");
        if (this.rendition.equals((Object)Rendition.HTML)) {
            if (this.success) {
                sb.append("<font color='green'><b>");
            } else {
                sb.append("<font color='red'><b>");
            }
        }
        sb.append("\nSuccess: " + this.success);
        if (this.rendition.equals((Object)Rendition.HTML)) {
            sb.append("</b></font>");
        }
        return sb.toString();
    }

    public String getMessageHistory() {
        return this.getMessageString(this.getMessageSet(this.warnings, this.messages, this.exceptions));
    }

    public String getVerboseMessageHistory() {
        return this.getMessageString(this.getMessageSet(this.warnings, this.messages, this.verboseMessages, this.exceptions));
    }

    private Set<HistoryEntry> getMessageSet(Set<HistoryEntry> ... sets) {
        TreeSet<HistoryEntry> resultSet = new TreeSet<HistoryEntry>(new HistoryEntryComparator());
        for (Set<HistoryEntry> set : sets) {
            for (HistoryEntry entry : set) {
                resultSet.add(entry);
            }
        }
        return resultSet;
    }

    private String getMessageString(Set<HistoryEntry> messageHistorySet) {
        StringBuilder sb = new StringBuilder();
        if (!messageHistorySet.isEmpty()) {
            for (HistoryEntry entry : messageHistorySet) {
                sb.append("\n" + entry.getTimestamp() + ": " + entry.getMessage());
            }
        }
        return sb.toString();
    }

    public static enum Rendition {
        HTML,
        TXT;

    }
}

