/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.installationhistory.impl;

import biz.netcentric.cq.tools.actool.comparators.TimestampPropertyComparator;
import biz.netcentric.cq.tools.actool.installationhistory.AcHistoryService;
import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import biz.netcentric.cq.tools.actool.installationhistory.impl.HistoryUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(metatype=true, label="AC History Service", immediate=true, description="Service that writes & fetches Ac installation histories")
@Properties(value={@Property(label="ACL number of histories to save", name="AceService.nrOfSavedHistories", value={"5"})})
public class AcHistoryServiceImpl
implements AcHistoryService {
    private static final String INSTALLED_CONFIGS_NODE_NAME = "installedConfigs";
    private static final int NR_OF_HISTORIES_TO_SAVE_DEFAULT = 5;
    private static final Logger LOG = LoggerFactory.getLogger(AcHistoryServiceImpl.class);
    private static final String PURGE_HISTORY_NODE_NAME_PREFIX = "purgeACL";
    private int nrOfSavedHistories;
    @Reference
    private SlingRepository repository;

    @Activate
    public void activate(Map properties) throws Exception {
        this.nrOfSavedHistories = PropertiesUtil.toInteger(properties.get("AceService.nrOfSavedHistories"), (int)5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistHistory(AcInstallationHistoryPojo history, String configurationRootPath) {
        block7: {
            Session session = null;
            try {
                try {
                    session = this.repository.loginAdministrative(null);
                    Node historyNode = HistoryUtils.persistHistory(session, history, this.nrOfSavedHistories);
                    session.save();
                    if (!history.isSuccess()) break block7;
                    Node configurationRootNode = session.getNode(configurationRootPath);
                    if (configurationRootNode != null) {
                        this.persistInstalledConfigurations(historyNode, configurationRootNode, history);
                        session.save();
                        break block7;
                    }
                    String message = "Couldn't find configuration root Node under path: " + configurationRootPath;
                    LOG.error(message);
                    history.addWarning(message);
                }
                catch (RepositoryException e) {
                    LOG.error("RepositoryException: ", (Throwable)e);
                }
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    @Override
    public String[] getInstallationLogPaths() {
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            String[] stringArray = HistoryUtils.getHistoryInfos(session);
            return stringArray;
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    @Override
    public String getLogHtml(Session session, String path) {
        return HistoryUtils.getLogHtml(session, path);
    }

    @Override
    public String getLogTxt(Session session, String path) {
        return HistoryUtils.getLogTxt(session, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastInstallationHistory() {
        Session session = null;
        String history = "";
        try {
            session = this.repository.loginAdministrative(null);
            Node statisticsRootNode = HistoryUtils.getAcHistoryRootNode(session);
            NodeIterator it = statisticsRootNode.getNodes();
            if (it.hasNext()) {
                Node lastHistoryNode = it.nextNode();
                if (lastHistoryNode != null) {
                    history = this.getLogHtml(session, lastHistoryNode.getName());
                }
            } else {
                history = "no history found!";
            }
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return history;
    }

    public void persistInstalledConfigurations(Node historyNode, Node configurationRootNode, AcInstallationHistoryPojo history) {
        try {
            JcrUtil.copy((Node)configurationRootNode, (Node)historyNode, (String)INSTALLED_CONFIGS_NODE_NAME);
        }
        catch (RepositoryException e) {
            String message = e.toString();
            history.addError(e.toString());
            LOG.error("Exception: ", (Throwable)e);
        }
        try {
            history.addMessage("saved installed configuration files under : " + historyNode.getPath() + "/" + INSTALLED_CONFIGS_NODE_NAME);
        }
        catch (RepositoryException e) {
            LOG.error("Exception: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String showHistory(int n) {
        Session session = null;
        String history = "";
        try {
            session = this.repository.loginAdministrative(null);
            Node statisticsRootNode = HistoryUtils.getAcHistoryRootNode(session);
            NodeIterator it = statisticsRootNode.getNodes();
            int cnt = 1;
            while (it.hasNext()) {
                Node historyNode = it.nextNode();
                if (historyNode != null && cnt == n) {
                    history = this.getLogTxt(session, historyNode.getName());
                }
                ++cnt;
            }
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistAcePurgeHistory(AcInstallationHistoryPojo history) {
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
            NodeIterator nodeIterator = acHistoryRootNode.getNodes();
            TreeSet<Node> historyNodes = new TreeSet<Node>(new TimestampPropertyComparator());
            Node newestHistoryNode = null;
            while (nodeIterator.hasNext()) {
                historyNodes.add(nodeIterator.nextNode());
            }
            if (!historyNodes.isEmpty()) {
                newestHistoryNode = (Node)historyNodes.iterator().next();
                AcHistoryServiceImpl.persistPurgeAceHistory(session, history, newestHistoryNode);
                session.save();
            }
        }
        catch (RepositoryException e) {
            LOG.error("Exception: ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private static Node persistPurgeAceHistory(Session session, AcInstallationHistoryPojo history, Node historyNode) throws RepositoryException {
        Node purgeHistoryNode = historyNode.addNode("purge_" + System.currentTimeMillis(), "nt:unstructured");
        NodeIterator nodeIt = historyNode.getNodes();
        Node previousPurgeNode = null;
        while (nodeIt.hasNext()) {
            Node currNode = nodeIt.nextNode();
            if (!currNode.getName().contains("purge_")) continue;
            previousPurgeNode = currNode;
            break;
        }
        if (previousPurgeNode != null) {
            historyNode.orderBefore(purgeHistoryNode.getName(), previousPurgeNode.getName());
        }
        String message = "saved history in node: " + purgeHistoryNode.getPath();
        history.addMessage(message);
        LOG.info(message);
        HistoryUtils.setHistoryNodeProperties(purgeHistoryNode, history);
        return historyNode;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

