/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.installationhistory.impl;

import biz.netcentric.cq.tools.actool.comparators.TimestampPropertyComparator;
import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryUtils {
    public static final String HISTORY_NODE_NAME_PREFIX = "history_";
    public static final String NODETYPE_NT_UNSTRUCTURED = "nt:unstructured";
    private static final String PROPERTY_SLING_RESOURCE_TYPE = "sling:resourceType";
    public static final String ACHISTORY_ROOT_NODE = "achistory";
    public static final String STATISTICS_ROOT_NODE = "var/statistics";
    private static final String PROPERTY_TIMESTAMP = "timestamp";
    private static final String PROPERTY_MESSAGES = "messages";
    private static final String PROPERTY_EXECUTION_TIME = "executionTime";
    private static final String PROPERTY_SUCCESS = "success";
    private static final String PROPERTY_INSTALLATION_DATE = "installationDate";
    private static final Logger LOG = LoggerFactory.getLogger(HistoryUtils.class);

    public static Node getAcHistoryRootNode(Session session) throws RepositoryException {
        Node rootNode = session.getRootNode();
        Node statisticsRootNode = HistoryUtils.safeGetNode(rootNode, STATISTICS_ROOT_NODE, NODETYPE_NT_UNSTRUCTURED);
        Node acHistoryRootNode = HistoryUtils.safeGetNode(statisticsRootNode, ACHISTORY_ROOT_NODE, "sling:OrderedFolder");
        return acHistoryRootNode;
    }

    public static Node persistHistory(Session session, AcInstallationHistoryPojo history, int nrOfHistoriesToSave) throws RepositoryException {
        Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
        Node newHistoryNode = HistoryUtils.safeGetNode(acHistoryRootNode, HISTORY_NODE_NAME_PREFIX + System.currentTimeMillis(), NODETYPE_NT_UNSTRUCTURED);
        String path = newHistoryNode.getPath();
        HistoryUtils.setHistoryNodeProperties(newHistoryNode, history);
        HistoryUtils.deleteObsoleteHistoryNodes(acHistoryRootNode, nrOfHistoriesToSave);
        Node previousHistoryNode = (Node)acHistoryRootNode.getNodes().next();
        if (previousHistoryNode != null) {
            acHistoryRootNode.orderBefore(newHistoryNode.getName(), previousHistoryNode.getName());
        }
        String message = "saved history in node: " + path;
        history.addMessage(message);
        LOG.info(message);
        return newHistoryNode;
    }

    private static Node safeGetNode(Node baseNode, String name, String typeToCreate) throws RepositoryException {
        if (!baseNode.hasNode(name)) {
            LOG.info("create node: {}", (Object)name);
            return baseNode.addNode(name, typeToCreate);
        }
        return baseNode.getNode(name);
    }

    public static void setHistoryNodeProperties(Node historyNode, AcInstallationHistoryPojo history) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        historyNode.setProperty(PROPERTY_INSTALLATION_DATE, history.getInstallationDate().toString());
        historyNode.setProperty(PROPERTY_SUCCESS, history.isSuccess());
        historyNode.setProperty(PROPERTY_EXECUTION_TIME, history.getExecutionTime());
        historyNode.setProperty(PROPERTY_MESSAGES, history.getVerboseMessageHistory());
        historyNode.setProperty(PROPERTY_TIMESTAMP, history.getInstallationDate().getTime());
        historyNode.setProperty(PROPERTY_SLING_RESOURCE_TYPE, "/apps/netcentric/actool/components/historyRenderer");
    }

    private static void deleteObsoleteHistoryNodes(Node acHistoryRootNode, int nrOfHistoriesToSave) throws RepositoryException {
        NodeIterator childNodeIt = acHistoryRootNode.getNodes();
        TreeSet<Node> historyChildNodes = new TreeSet<Node>(new TimestampPropertyComparator());
        while (childNodeIt.hasNext()) {
            Node node = childNodeIt.nextNode();
            if (!node.getName().startsWith(HISTORY_NODE_NAME_PREFIX)) continue;
            historyChildNodes.add(node);
        }
        int index = 1;
        for (Node node : historyChildNodes) {
            if (index > nrOfHistoriesToSave) {
                LOG.info("delete obsolete history node: ", (Object)node.getPath());
                node.remove();
            }
            ++index;
        }
    }

    static String[] getHistoryInfos(Session session) throws RepositoryException, PathNotFoundException {
        Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        int cnt = 1;
        NodeIterator iterator = acHistoryRootNode.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node != null && node.getName().startsWith(HISTORY_NODE_NAME_PREFIX)) {
                String successStatusString = "failed";
                if (node.getProperty(PROPERTY_SUCCESS).getBoolean()) {
                    successStatusString = "ok";
                }
                String installationDate = node.getProperty(PROPERTY_INSTALLATION_DATE).getString();
                messages.add(cnt + ". " + node.getPath() + " " + "" + "(" + installationDate + ")" + "(" + successStatusString + ")");
            }
            ++cnt;
        }
        return messages.toArray(new String[messages.size()]);
    }

    public static String getLogTxt(Session session, String path) {
        return HistoryUtils.getLog(session, path, "\n").toString();
    }

    public static String getLogHtml(Session session, String path) {
        return HistoryUtils.getLog(session, path, "<br />").toString();
    }

    public static String getLog(Session session, String path, String lineFeedSymbol) {
        StringBuilder sb = new StringBuilder();
        try {
            Node acHistoryRootNode = HistoryUtils.getAcHistoryRootNode(session);
            Node historyNode = acHistoryRootNode.getNode(path);
            if (historyNode != null) {
                sb.append("Installation triggered: " + historyNode.getProperty(PROPERTY_INSTALLATION_DATE).getString());
                sb.append(lineFeedSymbol + historyNode.getProperty(PROPERTY_MESSAGES).getString().replace("\n", lineFeedSymbol));
                sb.append(lineFeedSymbol + "Execution time: " + historyNode.getProperty(PROPERTY_EXECUTION_TIME).getLong() + " ms");
                sb.append(lineFeedSymbol + "Success: " + historyNode.getProperty(PROPERTY_SUCCESS).getBoolean());
            }
        }
        catch (RepositoryException e) {
            LOG.error("RepositoryException: {}", (Throwable)e);
        }
        return sb.toString();
    }
}

