/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.installhook;

import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import biz.netcentric.cq.tools.actool.installationhistory.HistoryEntry;
import biz.netcentric.cq.tools.actool.installhook.AcToolInstallHookService;
import biz.netcentric.cq.tools.actool.installhook.OsgiAwareInstallHook;
import com.day.jcr.vault.packaging.InstallContext;
import com.day.jcr.vault.packaging.PackageException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcToolInstallHook
extends OsgiAwareInstallHook {
    private static final Logger LOG = LoggerFactory.getLogger(AcToolInstallHook.class);
    private boolean alreadyRan = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InstallContext context) throws PackageException {
        LOG.debug("Executing install hook for phase {}.", (Object)context.getPhase());
        switch (context.getPhase()) {
            case PREPARE: {
                if (this.alreadyRan) {
                    this.log("Evading attempt to run the install hook twice due to a bug in CQ.", context.getOptions());
                    return;
                }
                this.alreadyRan = true;
                this.log("Installing ACLs through AcToolInstallHook...", context.getOptions());
                ServiceReference acToolInstallHookService = this.getServiceReference("biz.netcentric.cq.tools.actool.installhook.AcToolInstallHookService");
                if (acToolInstallHookService == null) {
                    throw new PackageException("Could not get AceService from OSGI service registry. Make sure the ACTool is installed!");
                }
                AcToolInstallHookService acService = (AcToolInstallHookService)this.getBundleContext().getService(acToolInstallHookService);
                if (acService == null) {
                    throw new PackageException("Could not instanciate AceService. Make sure the ACTool is installed and check the log for errors");
                }
                try {
                    AcInstallationHistoryPojo history;
                    try {
                        history = acService.installYamlFilesFromPackage(context.getPackage().getArchive(), context.getSession());
                    }
                    catch (Exception e) {
                        this.log("Exception while installing configurations: " + e, context.getOptions());
                        throw new PackageException(e.getMessage(), (Throwable)e);
                    }
                    if (!history.isSuccess()) {
                        for (HistoryEntry entry : history.getException()) {
                            this.log(entry.toString(), context.getOptions());
                        }
                        throw new PackageException("Could not install configurations. Check log for detailed error message!");
                    }
                    String log = history.toString().replaceAll("\\\n", "<br />");
                    this.log(log, context.getOptions());
                    this.log("Installed ACLs successfully through AcToolInstallHook!", context.getOptions());
                    break;
                }
                finally {
                    this.getBundleContext().ungetService(acToolInstallHookService);
                }
            }
        }
    }
}

