/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.installhook;

import biz.netcentric.cq.tools.actool.aceservice.AceService;
import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableInstallationHistory;
import biz.netcentric.cq.tools.actool.configreader.ConfigFilesRetriever;
import biz.netcentric.cq.tools.actool.installationhistory.AcInstallationHistoryPojo;
import biz.netcentric.cq.tools.actool.installhook.AcToolInstallHookService;
import com.day.jcr.vault.fs.io.Archive;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={AcToolInstallHookService.class})
public class AcToolInstallHookServiceImpl
implements AcToolInstallHookService {
    private static final Logger LOG = LoggerFactory.getLogger(AcToolInstallHookServiceImpl.class);
    @Reference
    private AceService aceService;
    @Reference
    private ConfigFilesRetriever configFilesRetriever;

    @Override
    public AcInstallationHistoryPojo installYamlFilesFromPackage(Archive archive, Session session) throws Exception {
        AcInstallationHistoryPojo history = new AcInstallationHistoryPojo();
        LinkedHashSet<AuthorizableInstallationHistory> authorizableInstallationHistorySet = new LinkedHashSet<AuthorizableInstallationHistory>();
        try {
            Map<String, String> configs = this.configFilesRetriever.getConfigFileContentFromPackage(archive);
            this.aceService.installNewConfigurations(session, history, configs, authorizableInstallationHistorySet);
        }
        catch (Exception e) {
            history.addError(e.toString());
            throw e;
        }
        return history;
    }

    protected void bindAceService(AceService aceService) {
        this.aceService = aceService;
    }

    protected void unbindAceService(AceService aceService) {
        if (this.aceService == aceService) {
            this.aceService = null;
        }
    }

    protected void bindConfigFilesRetriever(ConfigFilesRetriever configFilesRetriever) {
        this.configFilesRetriever = configFilesRetriever;
    }

    protected void unbindConfigFilesRetriever(ConfigFilesRetriever configFilesRetriever) {
        if (this.configFilesRetriever == configFilesRetriever) {
            this.configFilesRetriever = null;
        }
    }
}

