/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators;

import com.day.cq.security.util.CqActions;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validators {
    private static final Logger LOG = LoggerFactory.getLogger(Validators.class);
    private static final Pattern GROUP_ID_PATTERN = Pattern.compile("([a-zA-Z0-9-_.]+)");

    public static boolean isValidNodePath(String path) {
        if (StringUtils.isBlank((String)path)) {
            return false;
        }
        return path != null && !path.equals("");
    }

    public static boolean isValidAuthorizableId(String name) {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        boolean isValid = false;
        Matcher matcher = GROUP_ID_PATTERN.matcher(name);
        if (matcher.matches()) {
            isValid = true;
        }
        return isValid;
    }

    public static boolean isValidRegex(String expression) {
        if (StringUtils.isBlank((String)expression)) {
            return true;
        }
        boolean isValid = true;
        if (expression.startsWith("*")) {
            expression = expression.replaceFirst("\\*", "\\\\*");
        }
        try {
            Pattern.compile(expression);
        }
        catch (PatternSyntaxException e) {
            LOG.error("Error while validating rep glob: {} ", (Object)expression, (Object)e);
            isValid = false;
        }
        return isValid;
    }

    public static boolean isValidAction(String action) {
        List<String> validActions = Arrays.asList(CqActions.ACTIONS);
        if (action == null) {
            return false;
        }
        return validActions.contains(action);
    }

    public static boolean isValidJcrPrivilege(String privilege, AccessControlManager aclManager) {
        if (privilege == null) {
            return false;
        }
        try {
            aclManager.privilegeFromName(privilege);
        }
        catch (RepositoryException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidPermission(String permission) {
        if (permission == null) {
            return false;
        }
        return StringUtils.equals((String)"allow", (String)permission) || StringUtils.equals((String)"deny", (String)permission);
    }
}

