/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators;

import biz.netcentric.cq.tools.actool.helper.Constants;
import biz.netcentric.cq.tools.actool.validators.ConfigurationsValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class YamlConfigurationsValidator
implements ConfigurationsValidator {
    @Override
    public void validateDuplicateAuthorizables(Set<String> groupsFromAllConfig, Set<String> groupsFromCurrentConfig, String configPath) throws IllegalArgumentException {
        if (CollectionUtils.containsAny(groupsFromAllConfig, groupsFromCurrentConfig)) {
            String errorMessage = "Already defined authorizable: ";
            for (String group : groupsFromCurrentConfig) {
                if (!groupsFromAllConfig.contains(group)) continue;
                errorMessage = errorMessage + group + " found in configuration file: " + configPath + "!";
                errorMessage = errorMessage + " This authorizable was already defined in another configuration file on the system!";
                break;
            }
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public void validateSectionContentExistence(String configPath, Collection configurations) throws IllegalArgumentException {
        new ArrayList(configurations);
    }

    @Override
    public void validateMandatorySectionIdentifiersExistence(String configuration, String filePath) {
    }

    @Override
    public void validateSectionIdentifiers(Set<String> sectionIdentifiers, String filePath) throws IllegalArgumentException {
        if (!Constants.VALID_CONFIG_SECTION_IDENTIFIERS.containsAll(sectionIdentifiers)) {
            for (String identifier : sectionIdentifiers) {
                if (Constants.VALID_CONFIG_SECTION_IDENTIFIERS.contains(identifier)) continue;
                throw new IllegalArgumentException("invalid section identifier: " + identifier + " in configuration file: " + filePath + "\n" + "valid configuration section identifiers are: " + Constants.VALID_CONFIG_SECTION_IDENTIFIERS);
            }
        }
    }
}

