/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators.impl;

import biz.netcentric.cq.tools.actool.helper.AceBean;
import biz.netcentric.cq.tools.actool.validators.AceBeanValidator;
import biz.netcentric.cq.tools.actool.validators.Validators;
import biz.netcentric.cq.tools.actool.validators.exceptions.AcConfigBeanValidationException;
import biz.netcentric.cq.tools.actool.validators.exceptions.AlreadyDefinedGroupException;
import biz.netcentric.cq.tools.actool.validators.exceptions.DoubledDefinedActionException;
import biz.netcentric.cq.tools.actool.validators.exceptions.DoubledDefinedJcrPrivilegeException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidActionException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidGroupNameException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidJcrPrivilegeException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidPathException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidPermissionException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidRepGlobException;
import biz.netcentric.cq.tools.actool.validators.exceptions.NoActionOrPrivilegeDefinedException;
import biz.netcentric.cq.tools.actool.validators.exceptions.NoGroupDefinedException;
import biz.netcentric.cq.tools.actool.validators.exceptions.TooManyActionsException;
import com.day.cq.security.util.CqActions;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.security.AccessControlManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AceBeanValidatorImpl
implements AceBeanValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AceBeanValidatorImpl.class);
    private long currentBeanCounter = 0L;
    private AceBean aceBean;
    private Set<String> groupsFromCurrentConfig;
    private Set<String> alreadyProcessedAuthorizables = new HashSet<String>();
    private boolean enabled = true;

    public AceBeanValidatorImpl(Set<String> groupsFromCurrentConfig) {
        this.groupsFromCurrentConfig = groupsFromCurrentConfig;
    }

    public AceBeanValidatorImpl() {
    }

    @Override
    public boolean validate(AceBean aceBean, AccessControlManager aclManager) throws AcConfigBeanValidationException {
        if (!this.enabled) {
            return true;
        }
        this.aceBean = aceBean;
        return this.validate(aclManager);
    }

    private boolean validate(AccessControlManager aclManager) throws AcConfigBeanValidationException {
        boolean isActionOrPrivilegeDefined;
        boolean isActionDefined = false;
        boolean isPrivilegeDefined = false;
        ++this.currentBeanCounter;
        this.validateAuthorizableId(this.groupsFromCurrentConfig, this.aceBean);
        this.validateAcePath(this.aceBean);
        isActionDefined = this.validateActions(this.aceBean);
        isPrivilegeDefined = this.validatePrivileges(this.aceBean, aclManager);
        this.validatePermission(this.aceBean);
        boolean bl = isActionOrPrivilegeDefined = isActionDefined || isPrivilegeDefined;
        if (!isActionOrPrivilegeDefined) {
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, this.aceBean.getPrincipalName()) + ", no actions or privileges defined" + "! Installation aborted!";
            LOG.error(errorMessage);
            throw new NoActionOrPrivilegeDefinedException(errorMessage);
        }
        this.validateGlobbing(this.aceBean);
        return true;
    }

    @Override
    public boolean validateGlobbing(AceBean tmpAclBean) throws InvalidRepGlobException {
        boolean valid = true;
        String currentEntryValue = tmpAclBean.getRepGlob();
        String principal = tmpAclBean.getPrincipalName();
        if (!Validators.isValidRegex(currentEntryValue)) {
            valid = false;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ",  invalid globbing expression: " + currentEntryValue;
            LOG.error(errorMessage);
            throw new InvalidRepGlobException(errorMessage);
        }
        tmpAclBean.setRepGlob(currentEntryValue);
        return valid;
    }

    @Override
    public boolean validatePermission(AceBean tmpAclBean) throws InvalidPermissionException {
        boolean valid = true;
        String permission = tmpAclBean.getPermission();
        String principal = tmpAclBean.getPrincipalName();
        if (!Validators.isValidPermission(permission)) {
            valid = false;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ", invalid permission: " + permission;
            LOG.error(errorMessage);
            throw new InvalidPermissionException(errorMessage);
        }
        tmpAclBean.setPermission(permission);
        return valid;
    }

    @Override
    public boolean validateActions(AceBean tmpAclBean) throws InvalidActionException, TooManyActionsException, DoubledDefinedActionException {
        String principal = tmpAclBean.getPrincipalName();
        if (!StringUtils.isNotBlank((String)tmpAclBean.getActionsStringFromConfig())) {
            return false;
        }
        String[] actions = tmpAclBean.getActionsStringFromConfig().split(",");
        if (actions.length > CqActions.ACTIONS.length) {
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + " too many actions defined!";
            LOG.error(errorMessage);
            throw new TooManyActionsException(errorMessage);
        }
        HashSet<String> actionsSet = new HashSet<String>();
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = StringUtils.strip((String)actions[i]);
            if (!Validators.isValidAction(actions[i])) {
                String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ", invalid action: " + actions[i];
                LOG.error(errorMessage);
                throw new InvalidActionException(errorMessage);
            }
            if (actionsSet.add(actions[i])) continue;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ", doubled defined action: " + actions[i];
            LOG.error(errorMessage);
            throw new DoubledDefinedActionException(errorMessage);
        }
        tmpAclBean.setActions(actions);
        return true;
    }

    @Override
    public boolean validatePrivileges(AceBean tmpAclBean, AccessControlManager aclManager) throws InvalidJcrPrivilegeException, DoubledDefinedJcrPrivilegeException {
        String currentEntryValue = tmpAclBean.getPrivilegesString();
        String principal = tmpAclBean.getPrincipalName();
        if (!StringUtils.isNotBlank((String)currentEntryValue)) {
            return false;
        }
        String[] privileges = currentEntryValue.split(",");
        HashSet<String> privilegesSet = new HashSet<String>();
        for (int i = 0; i < privileges.length; ++i) {
            privileges[i] = StringUtils.strip((String)privileges[i]);
            if (!Validators.isValidJcrPrivilege(privileges[i], aclManager)) {
                String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ",  invalid jcr privilege: " + privileges[i];
                LOG.error(errorMessage);
                throw new InvalidJcrPrivilegeException(errorMessage);
            }
            if (privilegesSet.add(privileges[i])) continue;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ", doubled defined jcr privilege: " + privileges[i];
            LOG.error(errorMessage);
            throw new DoubledDefinedJcrPrivilegeException(errorMessage);
        }
        tmpAclBean.setPrivilegesString(currentEntryValue);
        return true;
    }

    @Override
    public boolean validateAcePath(AceBean tmpAclBean) throws InvalidPathException {
        boolean isPathDefined = false;
        String currentEntryValue = tmpAclBean.getJcrPath();
        String principal = tmpAclBean.getPrincipalName();
        if (!Validators.isValidNodePath(currentEntryValue)) {
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + ", invalid path: " + currentEntryValue;
            LOG.error(errorMessage);
            throw new InvalidPathException(errorMessage);
        }
        tmpAclBean.setJcrPath(currentEntryValue);
        isPathDefined = true;
        return isPathDefined;
    }

    @Override
    public boolean validateAuthorizableId(Set<String> groupsFromCurrentConfig, AceBean tmpAclBean) throws NoGroupDefinedException, InvalidGroupNameException {
        boolean valid = true;
        String principal = tmpAclBean.getPrincipalName();
        if (Validators.isValidAuthorizableId(principal)) {
            if (!groupsFromCurrentConfig.contains(principal)) {
                String message = this.getBeanDescription(this.currentBeanCounter, principal) + " is not defined in group configuration";
                throw new NoGroupDefinedException(message);
            }
        } else {
            valid = false;
            String errorMessage = this.getBeanDescription(this.currentBeanCounter, principal) + principal + ", invalid authorizable name: " + principal;
            LOG.error(errorMessage);
            throw new InvalidGroupNameException(errorMessage);
        }
        tmpAclBean.setPrincipal(principal);
        return valid;
    }

    @Override
    public void setBean(AceBean aceBean) {
        this.aceBean = aceBean;
    }

    @Override
    public void setGroupsFromCurrentConfig(Set<String> groupsFromCurrentConfig) {
        this.groupsFromCurrentConfig = groupsFromCurrentConfig;
    }

    @Override
    public void setBeanCounter(long value) {
        this.currentBeanCounter = value;
    }

    private String getBeanDescription(long beanCounter, String principalName) {
        return "Validation error while reading ACE definition nr." + beanCounter + " of authorizable: " + principalName;
    }

    @Override
    public void setCurrentAuthorizableName(String name) throws AlreadyDefinedGroupException {
        if (this.enabled) {
            LOG.info("insert {} into set", (Object)name);
            if (!this.alreadyProcessedAuthorizables.add(name)) {
                String errorMessage = this.getBeanDescription(1L, name) + ", found more than one ACE definition block for this group!";
                LOG.error(errorMessage);
                throw new AlreadyDefinedGroupException(errorMessage);
            }
            LOG.info("start validation of ACEs for authorizable: {}", (Object)name);
            this.currentBeanCounter = 0L;
        }
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }
}

