/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators.impl;

import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidGroupNameException;
import java.util.Map;
import java.util.Set;

public class AuthorizableMemberGroupsValidator {
    public void validate(Map<String, Set<AuthorizableConfigBean>> authorizables) throws InvalidGroupNameException {
        for (Map.Entry<String, Set<AuthorizableConfigBean>> entry : authorizables.entrySet()) {
            String groupName = entry.getKey();
            AuthorizableConfigBean group = entry.getValue().iterator().next();
            String[] members = group.getMembers();
            if (members == null || members.length == 0) continue;
            for (String member : members) {
                if (!authorizables.containsKey(member)) {
                    throw new InvalidGroupNameException(String.format("Group %s defined as member in group %s is not specified.", member, groupName));
                }
                authorizables.get(member).iterator().next().addMemberOf(groupName);
            }
        }
    }
}

