/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators.impl;

import biz.netcentric.cq.tools.actool.authorizableutils.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.validators.AuthorizableValidator;
import biz.netcentric.cq.tools.actool.validators.Validators;
import biz.netcentric.cq.tools.actool.validators.exceptions.AcConfigBeanValidationException;
import biz.netcentric.cq.tools.actool.validators.exceptions.InvalidGroupNameException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizableValidatorImpl
implements AuthorizableValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizableValidatorImpl.class);
    private boolean enabled = true;
    AuthorizableConfigBean authorizableConfigBean;

    @Override
    public void validate(AuthorizableConfigBean authorizableConfigBean) throws AcConfigBeanValidationException {
        this.authorizableConfigBean = authorizableConfigBean;
        this.validate();
    }

    private boolean validate() throws AcConfigBeanValidationException {
        if (this.enabled) {
            return this.validateMemberOf(this.authorizableConfigBean) && this.validateMembers(this.authorizableConfigBean) && this.validateAuthorizableId(this.authorizableConfigBean);
        }
        return true;
    }

    @Override
    public boolean validateMemberOf(AuthorizableConfigBean tmpPrincipalConfigBean) throws InvalidGroupNameException {
        String currentPrincipal = tmpPrincipalConfigBean.getPrincipalID();
        String currentEntryValue = tmpPrincipalConfigBean.getMemberOfStringFromConfig();
        if (StringUtils.isNotBlank((String)currentEntryValue) && currentEntryValue != null) {
            String[] groups = currentEntryValue.split(",");
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = StringUtils.strip((String)groups[i]);
                if (Validators.isValidAuthorizableId(groups[i])) continue;
                LOG.error("Validation error while reading group property of authorizable:{}, invalid authorizable name: {}", (Object)currentPrincipal, (Object)groups[i]);
                throw new InvalidGroupNameException("Validation error while reading group property of authorizable: " + currentPrincipal + ", invalid group name: " + groups[i]);
            }
            tmpPrincipalConfigBean.setMemberOf(groups);
        }
        return true;
    }

    public boolean validateMembers(AuthorizableConfigBean tmpPrincipalConfigBean) throws InvalidGroupNameException {
        String currentPrincipal = tmpPrincipalConfigBean.getPrincipalID();
        String currentEntryValue = tmpPrincipalConfigBean.getMembersStringFromConfig();
        if (StringUtils.isNotBlank((String)currentEntryValue) && currentEntryValue != null) {
            String[] groups = currentEntryValue.split(",");
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = StringUtils.strip((String)groups[i]);
                if (Validators.isValidAuthorizableId(groups[i])) continue;
                LOG.error("Validation error while reading group property of authorizable:{}, invalid authorizable name: {}", (Object)currentPrincipal, (Object)groups[i]);
                throw new InvalidGroupNameException("Validation error while reading group property of authorizable: " + currentPrincipal + ", invalid group name: " + groups[i]);
            }
            tmpPrincipalConfigBean.setMembers(groups);
        }
        return true;
    }

    @Override
    public boolean validateAuthorizableId(AuthorizableConfigBean tmpPrincipalConfigBean) throws InvalidGroupNameException {
        String currentPrincipal = tmpPrincipalConfigBean.getPrincipalID();
        if (!Validators.isValidAuthorizableId(currentPrincipal)) {
            String message = "Validation error while reading group data: invalid group name: " + currentPrincipal;
            LOG.error(message);
            throw new InvalidGroupNameException(message);
        }
        tmpPrincipalConfigBean.setPrincipalID(currentPrincipal);
        return true;
    }

    @Override
    public void setBean(AuthorizableConfigBean authorizableConfigBean) {
        this.authorizableConfigBean = authorizableConfigBean;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }
}

